/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basecluster.fd;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import io.reactivex.rxjava3.annotations.NonNull;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.core.Scheduler;
import io.reactivex.rxjava3.disposables.CompositeDisposable;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.schedulers.Timed;
import io.reactivex.rxjava3.subjects.BehaviorSubject;
import io.reactivex.rxjava3.subjects.PublishSubject;
import io.reactivex.rxjava3.subjects.Subject;
import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.apache.bifromq.basecluster.fd.DirectProbingInfo;
import org.apache.bifromq.basecluster.fd.FailureDetectorMath;
import org.apache.bifromq.basecluster.fd.IFailureDetector;
import org.apache.bifromq.basecluster.fd.IProbingTarget;
import org.apache.bifromq.basecluster.fd.IProbingTargetSelector;
import org.apache.bifromq.basecluster.fd.proto.Ack;
import org.apache.bifromq.basecluster.fd.proto.Nack;
import org.apache.bifromq.basecluster.fd.proto.Ping;
import org.apache.bifromq.basecluster.fd.proto.PingReq;
import org.apache.bifromq.basecluster.messenger.IMessenger;
import org.apache.bifromq.basecluster.messenger.MessageEnvelope;
import org.apache.bifromq.basecluster.proto.ClusterMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FailureDetector
implements IFailureDetector {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FailureDetector.class);
    private final AtomicReference<State> state = new AtomicReference<State>(State.INIT);
    private final AtomicInteger seqNo = new AtomicInteger();
    private final IMessenger messenger;
    private final Subject<IProbingTarget> normalProbeSubject;
    private final Subject<IProbingTarget> suspicionSubject;
    private final Observable<Timed<IProbingTarget>> suspicionSink;
    private final Observable<Timed<IProbingTarget>> normalProbeSink;
    private final Subject<Integer> healthScoreSubject = BehaviorSubject.createDefault((Object)0).toSerialized();
    private final int indirectProbes;
    private final int worstHealthScore;
    private final Duration baseProbeInterval;
    private final Duration baseProbeTimeout;
    private final Scheduler scheduler;
    private final IProbingTarget local;
    private final AtomicBoolean probing = new AtomicBoolean();
    private final CompositeDisposable disposables = new CompositeDisposable();
    private volatile Disposable probeTask;
    private IProbingTargetSelector targetSelector;

    private FailureDetector(IProbingTarget local, IMessenger messenger, Scheduler scheduler, Duration baseProbeInterval, Duration baseProbeTimeout, int indirectProbes, int worstHealthScore) {
        Preconditions.checkArgument((indirectProbes > 0 ? 1 : 0) != 0, (Object)"Indirect probes must be positive");
        Preconditions.checkArgument((worstHealthScore > 0 ? 1 : 0) != 0, (Object)"Worst health score must be positive");
        this.local = local;
        this.messenger = messenger;
        this.scheduler = scheduler;
        this.baseProbeInterval = baseProbeInterval;
        this.baseProbeTimeout = baseProbeTimeout;
        this.indirectProbes = indirectProbes;
        this.worstHealthScore = worstHealthScore;
        this.normalProbeSubject = PublishSubject.create().toSerialized();
        this.normalProbeSink = this.normalProbeSubject.timestamp(scheduler);
        this.suspicionSubject = PublishSubject.create().toSerialized();
        this.suspicionSink = this.suspicionSubject.timestamp(scheduler);
    }

    @Override
    public Duration baseProbeInterval() {
        return this.baseProbeInterval;
    }

    @Override
    public Duration baseProbeTimeout() {
        return this.baseProbeTimeout;
    }

    @Override
    public void start(IProbingTargetSelector targetSelector) {
        if (this.state.compareAndSet(State.INIT, State.STARTING)) {
            log.debug("Start failure detector from local[{}]@{}", (Object)this.local.id(), (Object)this.local.addr());
            this.targetSelector = targetSelector;
            this.disposables.add(this.messenger.receive().observeOn(this.scheduler).subscribe(this::handleMessageEnvelope));
            this.state.set(State.STARTED);
            this.scheduleProbe();
        }
    }

    @Override
    public CompletableFuture<Void> shutdown() {
        if (this.state.compareAndSet(State.STARTED, State.STOPPING)) {
            log.debug("Stopping failure detector");
            if (this.probeTask != null && !this.probeTask.isDisposed()) {
                this.probeTask.dispose();
            }
            this.disposables.dispose();
            this.suspicionSubject.onComplete();
            this.healthScoreSubject.onComplete();
            this.state.set(State.STOPPED);
            return CompletableFuture.completedFuture(null);
        }
        switch (this.state.get()) {
            case STOPPED: {
                return CompletableFuture.completedFuture(null);
            }
        }
        return CompletableFuture.failedFuture(new IllegalStateException("Failure detector not stoppable"));
    }

    @Override
    public Observable<Timed<IProbingTarget>> succeeding() {
        return this.normalProbeSink;
    }

    @Override
    public Observable<Timed<IProbingTarget>> suspecting() {
        return this.suspicionSink;
    }

    @Override
    public void penaltyHealth() {
        this.updateLocalHealthScore((Integer)this.healthScoreSubject.blockingFirst() + 1);
    }

    @Override
    public Observable<Integer> healthScoring() {
        return this.healthScoreSubject;
    }

    private void handleMessageEnvelope(Timed<MessageEnvelope> messageEnvelopeTimed) {
        if (this.state.get() != State.STARTED) {
            return;
        }
        ClusterMessage clusterMessage = ((MessageEnvelope)messageEnvelopeTimed.value()).message;
        switch (clusterMessage.getClusterMessageTypeCase()) {
            case PING: {
                this.handlePing(clusterMessage.getPing());
                break;
            }
            case PINGREQ: {
                this.handlePingReq(clusterMessage.getPingReq());
            }
        }
    }

    private void scheduleProbe() {
        if (this.state.get() == State.STARTED && this.probing.compareAndSet(false, true)) {
            this.probeTask = this.scheduler.scheduleDirect(() -> this.probe().whenComplete((v, e) -> {
                this.probing.set(false);
                this.scheduleProbe();
            }), this.baseProbeInterval.toMillis(), TimeUnit.MILLISECONDS);
        }
    }

    private CompletableFuture<Void> probe() {
        if (this.state.get() != State.STARTED) {
            return CompletableFuture.completedFuture(null);
        }
        DirectProbingInfo directProbingInfo = this.targetSelector.targetForProbe();
        if (!directProbingInfo.target.isPresent()) {
            log.trace("No target eligible for probing");
            return CompletableFuture.completedFuture(null);
        }
        final int seqNum = this.nextSeqNum();
        final IProbingTarget target = directProbingInfo.target.get();
        final CompletableFuture<Void> doneSignal = new CompletableFuture<Void>();
        final int score = (Integer)this.healthScoreSubject.blockingFirst();
        Duration probeInterval = FailureDetectorMath.scale(this.baseProbeInterval, score);
        Duration directProbeTimeout = FailureDetectorMath.scale(this.baseProbeTimeout, score);
        Duration indirectProbeTimeout = probeInterval.minus(directProbeTimeout);
        log.trace("Probe with directTimeout[{}] and indirectTimeout[{}]: target={}, addr={}, localHealthScore={}", new Object[]{directProbeTimeout.toMillis(), indirectProbeTimeout.toMillis(), target.id(), target.addr(), score});
        this.messenger.receive().filter(msg -> {
            ClusterMessage clusterMsg = ((MessageEnvelope)msg.value()).message;
            return clusterMsg.hasAck() && clusterMsg.getAck().getSeqNo() == seqNum;
        }).map(msg -> ((MessageEnvelope)msg.value()).message.getAck()).take(1L).timeout(directProbeTimeout.toMillis(), TimeUnit.MILLISECONDS, this.scheduler).observeOn(this.scheduler).subscribe(ack -> {
            if (this.state.get() != State.STARTED) {
                doneSignal.complete(null);
                return;
            }
            log.trace("Probe[{}], direct probing succeed with ack: target={}, addr={}", new Object[]{seqNum, target.id(), target.addr()});
            this.updateLocalHealthScore(score - 1);
            this.normalProbeSubject.onNext((Object)target);
            doneSignal.complete(null);
        }, e -> {
            assert (e instanceof TimeoutException);
            if (this.state.get() != State.STARTED) {
                doneSignal.complete(null);
                return;
            }
            log.trace("Probe[{}], direct probing timeout: target={}, addr={}", new Object[]{seqNum, target.id(), target.addr()});
            final AtomicInteger localHealthDelta = new AtomicInteger(1);
            Collection<IProbingTarget> indirectProbers = this.targetSelector.targetForIndirectProbes(target, this.indirectProbes);
            if (!indirectProbers.isEmpty()) {
                ClusterMessage pingReq = ClusterMessage.newBuilder().setPingReq(PingReq.newBuilder().setSeqNo(seqNum).setId(target.id()).setAddr(target.addr().getAddress().getHostAddress()).setPort(target.addr().getPort()).setPingerId(this.local.id()).setPingerAddr(this.local.addr().getAddress().getHostAddress()).setPingerPort(this.local.addr().getPort()).build()).build();
                final int expectedNacks = indirectProbers.size();
                localHealthDelta.addAndGet(expectedNacks);
                final AtomicInteger nackReceived = new AtomicInteger(0);
                this.messenger.receive().map(envelop -> ((MessageEnvelope)envelop.value()).message).filter(clusterMsg -> clusterMsg.hasNack() && clusterMsg.getNack().getSeqNo() == seqNum || clusterMsg.hasAck() && clusterMsg.getAck().getSeqNo() == seqNum).timeout(indirectProbeTimeout.toMillis(), TimeUnit.MILLISECONDS, this.scheduler).observeOn(this.scheduler).subscribe((Observer)new Observer<ClusterMessage>(){
                    private Disposable indirectProbeObserver;

                    public void onSubscribe(@NonNull Disposable d) {
                        this.indirectProbeObserver = d;
                    }

                    public void onNext(@NonNull ClusterMessage clusterMessage) {
                        if (FailureDetector.this.state.get() != State.STARTED) {
                            this.indirectProbeObserver.dispose();
                            doneSignal.complete(null);
                            return;
                        }
                        switch (clusterMessage.getClusterMessageTypeCase()) {
                            case ACK: {
                                log.trace("Probe[{}], indirect probing succeed with ack: target={}, addr={}", new Object[]{seqNum, target.id(), target.addr()});
                                localHealthDelta.addAndGet(-1 - (expectedNacks - nackReceived.get()));
                                FailureDetector.this.normalProbeSubject.onNext((Object)target);
                                FailureDetector.this.updateLocalHealthScore(score + localHealthDelta.get());
                                this.indirectProbeObserver.dispose();
                                doneSignal.complete(null);
                                break;
                            }
                            case NACK: {
                                log.trace("Probe[{}], indirect probing received nack: target={}, addr={}", new Object[]{seqNum, target.id(), target.addr()});
                                localHealthDelta.addAndGet(-1);
                                if (nackReceived.incrementAndGet() < expectedNacks) break;
                                log.trace("Probe[{}], indirect probing finished with all nack received, raise suspicion: target={}, addr={}", new Object[]{seqNum, target.id(), target.addr()});
                                localHealthDelta.addAndGet(-1);
                                FailureDetector.this.suspicionSubject.onNext((Object)target);
                                FailureDetector.this.updateLocalHealthScore(score + localHealthDelta.get());
                                this.indirectProbeObserver.dispose();
                                doneSignal.complete(null);
                            }
                        }
                    }

                    public void onError(@NonNull Throwable e) {
                        assert (e instanceof TimeoutException);
                        if (FailureDetector.this.state.get() != State.STARTED) {
                            doneSignal.complete(null);
                            return;
                        }
                        log.trace("Probe[{}], indirect probing timeout, raise suspicion: target={}, addr={}", new Object[]{seqNum, target.id(), target.addr()});
                        FailureDetector.this.suspicionSubject.onNext((Object)target);
                        FailureDetector.this.updateLocalHealthScore(score + localHealthDelta.get());
                        doneSignal.complete(null);
                    }

                    public void onComplete() {
                    }
                });
                log.trace("Probe[{}], indirect probing start: target={}, addr={}, count={}", new Object[]{seqNum, target.id(), target.addr(), indirectProbers.size()});
                indirectProbers.forEach(indirectTarget -> {
                    log.trace("Probe[{}], sending ping-req: target={}, addr={}", new Object[]{seqNum, indirectTarget.id(), indirectTarget.addr()});
                    this.messenger.send(pingReq, directProbingInfo.piggybacked, indirectTarget.addr(), false);
                });
            } else {
                this.suspicionSubject.onNext((Object)target);
                doneSignal.complete(null);
            }
        });
        ClusterMessage ping = ClusterMessage.newBuilder().setPing(Ping.newBuilder().setSeqNo(seqNum).setId(target.id()).setPingerId(this.local.id()).setPingerAddr(this.local.addr().getAddress().getHostAddress()).setPingerPort(this.local.addr().getPort()).build()).build();
        log.trace("Probe[{}], direct probing start: target={}, addr={}", new Object[]{seqNum, target.id(), target.addr()});
        this.messenger.send(ping, directProbingInfo.piggybacked, target.addr(), false);
        return doneSignal;
    }

    private void updateLocalHealthScore(int rawScore) {
        this.healthScoreSubject.onNext((Object)Ints.constrainToRange((int)rawScore, (int)0, (int)this.worstHealthScore));
    }

    private void handlePing(Ping ping) {
        if (!ping.getId().equals((Object)this.local.id())) {
            return;
        }
        ClusterMessage ack = ClusterMessage.newBuilder().setAck(Ack.newBuilder().setSeqNo(ping.getSeqNo()).build()).build();
        log.trace("Received ping and sending ack: ping={}, ack={}", (Object)ping, (Object)ack);
        this.messenger.send(ack, new InetSocketAddress(ping.getPingerAddr(), ping.getPingerPort()), false);
    }

    private void handlePingReq(PingReq pingReq) {
        int seqNum = this.nextSeqNum();
        this.messenger.receive().filter(msg -> ((MessageEnvelope)msg.value()).message.hasAck() && ((MessageEnvelope)msg.value()).message.getAck().getSeqNo() == seqNum).map(msg -> ((MessageEnvelope)msg.value()).message.getAck()).take(1L).timeout(this.baseProbeTimeout.toMillis(), TimeUnit.MILLISECONDS, this.scheduler).observeOn(this.scheduler).subscribe(ack -> {
            ClusterMessage relayAck = ClusterMessage.newBuilder().setAck(Ack.newBuilder().setSeqNo(pingReq.getSeqNo()).build()).build();
            log.trace("Received ack and relaying back: ack={}, addr={}:{}", new Object[]{ack, pingReq.getPingerAddr(), pingReq.getPort()});
            this.messenger.send(relayAck, new InetSocketAddress(pingReq.getPingerAddr(), pingReq.getPort()), true);
        }, e -> {
            assert (e instanceof TimeoutException);
            ClusterMessage nack = ClusterMessage.newBuilder().setNack(Nack.newBuilder().setSeqNo(pingReq.getSeqNo()).build()).build();
            log.trace("Send nack: nack={}, addr={}:{}", new Object[]{nack, pingReq.getPingerAddr(), pingReq.getPort()});
            this.messenger.send(nack, new InetSocketAddress(pingReq.getPingerAddr(), pingReq.getPort()), true);
        });
        ClusterMessage ping = ClusterMessage.newBuilder().setPing(Ping.newBuilder().setSeqNo(seqNum).setId(pingReq.getId()).setPingerId(this.local.id()).setPingerAddr(this.local.addr().getAddress().getHostAddress()).setPingerPort(this.local.addr().getPort()).build()).build();
        log.trace("Received ping-req and sending ping: pingreq={}, ping={}", (Object)pingReq, (Object)ping);
        this.messenger.send(ping, new InetSocketAddress(pingReq.getAddr(), pingReq.getPort()), true);
    }

    private int nextSeqNum() {
        return this.seqNo.getAndIncrement();
    }

    @Generated
    public static FailureDetectorBuilder builder() {
        return new FailureDetectorBuilder();
    }

    private static enum State {
        INIT,
        STARTING,
        STARTED,
        STOPPING,
        STOPPED;

    }

    @Generated
    public static class FailureDetectorBuilder {
        @Generated
        private IProbingTarget local;
        @Generated
        private IMessenger messenger;
        @Generated
        private Scheduler scheduler;
        @Generated
        private Duration baseProbeInterval;
        @Generated
        private Duration baseProbeTimeout;
        @Generated
        private int indirectProbes;
        @Generated
        private int worstHealthScore;

        @Generated
        FailureDetectorBuilder() {
        }

        @Generated
        public FailureDetectorBuilder local(IProbingTarget local) {
            this.local = local;
            return this;
        }

        @Generated
        public FailureDetectorBuilder messenger(IMessenger messenger) {
            this.messenger = messenger;
            return this;
        }

        @Generated
        public FailureDetectorBuilder scheduler(Scheduler scheduler) {
            this.scheduler = scheduler;
            return this;
        }

        @Generated
        public FailureDetectorBuilder baseProbeInterval(Duration baseProbeInterval) {
            this.baseProbeInterval = baseProbeInterval;
            return this;
        }

        @Generated
        public FailureDetectorBuilder baseProbeTimeout(Duration baseProbeTimeout) {
            this.baseProbeTimeout = baseProbeTimeout;
            return this;
        }

        @Generated
        public FailureDetectorBuilder indirectProbes(int indirectProbes) {
            this.indirectProbes = indirectProbes;
            return this;
        }

        @Generated
        public FailureDetectorBuilder worstHealthScore(int worstHealthScore) {
            this.worstHealthScore = worstHealthScore;
            return this;
        }

        @Generated
        public FailureDetector build() {
            return new FailureDetector(this.local, this.messenger, this.scheduler, this.baseProbeInterval, this.baseProbeTimeout, this.indirectProbes, this.worstHealthScore);
        }

        @Generated
        public String toString() {
            return "FailureDetector.FailureDetectorBuilder(local=" + String.valueOf(this.local) + ", messenger=" + String.valueOf(this.messenger) + ", scheduler=" + String.valueOf(this.scheduler) + ", baseProbeInterval=" + String.valueOf(this.baseProbeInterval) + ", baseProbeTimeout=" + String.valueOf(this.baseProbeTimeout) + ", indirectProbes=" + this.indirectProbes + ", worstHealthScore=" + this.worstHealthScore + ")";
        }
    }
}

