/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basecluster.transport;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.protobuf.ByteString;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.subjects.PublishSubject;
import io.reactivex.rxjava3.subjects.Subject;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.apache.bifromq.basecluster.transport.ITransport;
import org.apache.bifromq.basecluster.transport.PacketEnvelope;
import org.apache.bifromq.basecluster.transport.proto.Packet;
import org.apache.bifromq.basehlc.HLC;

public abstract class AbstractTransport
implements ITransport {
    private final String env;
    private final Subject<PacketEnvelope> publisher = PublishSubject.create();
    private final AtomicBoolean hasStopped = new AtomicBoolean();

    @Override
    public abstract InetSocketAddress bindAddress();

    @Override
    public final CompletableFuture<Void> send(List<ByteString> data, InetSocketAddress recipient) {
        this.checkState();
        Packet.Builder builder = Packet.newBuilder().setHlc(HLC.INST.get()).addAllMessages(data);
        if (!Strings.isNullOrEmpty((String)this.env)) {
            builder.setClusterEnv(this.env);
        }
        Packet packet = builder.build();
        return this.doSend(packet, recipient);
    }

    @Override
    public final Observable<PacketEnvelope> receive() {
        this.checkState();
        return this.publisher;
    }

    @Override
    public final CompletableFuture<Void> shutdown() {
        if (this.hasStopped.compareAndSet(false, true)) {
            CompletableFuture<Void> onDone = new CompletableFuture<Void>();
            CompletableSource[] completableSourceArray = new CompletableSource[2];
            completableSourceArray[0] = this.doShutdown();
            completableSourceArray[1] = Completable.fromAction(() -> this.publisher.onComplete());
            Completable.concatArrayDelayError((CompletableSource[])completableSourceArray).onErrorComplete().subscribe(() -> onDone.complete(null));
            return onDone;
        }
        return CompletableFuture.completedFuture(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doReceive(Packet packet, InetSocketAddress sender, InetSocketAddress recipient) {
        if (!(Strings.isNullOrEmpty((String)this.env) || Strings.isNullOrEmpty((String)packet.getClusterEnv()) || this.env.equals(packet.getClusterEnv()))) {
            return;
        }
        Subject<PacketEnvelope> subject = this.publisher;
        synchronized (subject) {
            HLC.INST.update(packet.getHlc());
            this.publisher.onNext((Object)new PacketEnvelope(packet.getMessagesList(), recipient, sender));
        }
    }

    protected abstract CompletableFuture<Void> doSend(Packet var1, InetSocketAddress var2);

    protected abstract Completable doShutdown();

    private void checkState() {
        Preconditions.checkState((!this.hasStopped.get() ? 1 : 0) != 0, (Object)"Has stopped");
    }

    @Generated
    public AbstractTransport(String env) {
        this.env = env;
    }
}

