/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basekv.store.wal;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import io.reactivex.rxjava3.core.Observable;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Predicate;
import org.apache.bifromq.basekv.proto.KVRangeCommand;
import org.apache.bifromq.basekv.proto.KVRangeId;
import org.apache.bifromq.basekv.proto.KVRangeSnapshot;
import org.apache.bifromq.basekv.raft.ILogEntryIterator;
import org.apache.bifromq.basekv.raft.IRaftNode;
import org.apache.bifromq.basekv.raft.event.CommitEvent;
import org.apache.bifromq.basekv.raft.event.ElectionEvent;
import org.apache.bifromq.basekv.raft.proto.ClusterConfig;
import org.apache.bifromq.basekv.raft.proto.LogEntry;
import org.apache.bifromq.basekv.raft.proto.RaftMessage;
import org.apache.bifromq.basekv.raft.proto.RaftNodeStatus;
import org.apache.bifromq.basekv.raft.proto.RaftNodeSyncState;
import org.apache.bifromq.basekv.store.wal.IKVRangeWALSubscriber;
import org.apache.bifromq.basekv.store.wal.IKVRangeWALSubscription;

public interface IKVRangeWAL {
    public String storeId();

    public KVRangeId rangeId();

    public boolean isLeader();

    public Optional<String> currentLeader();

    public RaftNodeStatus currentState();

    public Observable<RaftNodeStatus> state();

    public Observable<ElectionEvent> election();

    public KVRangeSnapshot latestSnapshot();

    public ClusterConfig latestClusterConfig();

    public CompletableFuture<Long> propose(KVRangeCommand var1);

    public Observable<Map<String, RaftNodeSyncState>> replicationStatus();

    public IKVRangeWALSubscription subscribe(long var1, IKVRangeWALSubscriber var3, Executor var4);

    public CompletableFuture<LogEntry> once(long var1, Predicate<LogEntry> var3, Executor var4);

    public Observable<CommitEvent> commitIndex();

    public CompletableFuture<ILogEntryIterator> retrieveCommitted(long var1, long var3);

    public CompletableFuture<Long> readIndex();

    public CompletableFuture<Void> transferLeadership(String var1);

    public boolean stepDown();

    public CompletableFuture<Void> changeClusterConfig(String var1, Set<String> var2, Set<String> var3);

    public CompletableFuture<Void> compact(KVRangeSnapshot var1);

    public Observable<RestoreSnapshotTask> snapshotRestoreTask();

    public Observable<Map<String, List<RaftMessage>>> peerMessages();

    public CompletableFuture<Void> recover();

    public void receivePeerMessages(String var1, List<RaftMessage> var2);

    public long logDataSize();

    public void tick();

    public void start();

    public CompletableFuture<Void> close();

    public CompletableFuture<Void> destroy();

    public static class RestoreSnapshotTask {
        public final KVRangeSnapshot snapshot;
        public final String leader;
        private final IRaftNode.IAfterInstalledCallback callback;

        public RestoreSnapshotTask(ByteString snapshotData, String leader, IRaftNode.IAfterInstalledCallback callback) {
            this.leader = leader;
            this.callback = callback;
            KVRangeSnapshot ss = null;
            try {
                ss = KVRangeSnapshot.parseFrom((ByteString)snapshotData);
            }
            catch (InvalidProtocolBufferException e) {
                this.callback.call(null, (Throwable)e);
            }
            this.snapshot = ss;
        }

        public CompletableFuture<Void> afterRestored(KVRangeSnapshot snapshot, Throwable ex) {
            return this.callback.call(snapshot == null ? null : snapshot.toByteString(), ex);
        }
    }
}

