/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basekv.localengine.rocksdb;

import com.google.common.collect.Sets;
import com.google.protobuf.ByteString;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.apache.bifromq.basekv.localengine.IKVSpaceIterator;
import org.apache.bifromq.basekv.localengine.IKVSpaceRefreshableReader;
import org.apache.bifromq.basekv.localengine.ISyncContext;
import org.apache.bifromq.basekv.localengine.metrics.KVSpaceOpMeters;
import org.apache.bifromq.basekv.localengine.rocksdb.AbstractRocksDBKVSpaceReader;
import org.apache.bifromq.basekv.localengine.rocksdb.IRocksDBKVSpaceEpoch;
import org.apache.bifromq.basekv.localengine.rocksdb.IteratorOptions;
import org.apache.bifromq.basekv.localengine.rocksdb.RocksDBKVSpaceIterator;
import org.apache.bifromq.basekv.localengine.rocksdb.RocksDBSnapshot;
import org.apache.bifromq.basekv.proto.Boundary;
import org.apache.bifromq.basekv.utils.BoundaryUtil;
import org.slf4j.Logger;

class RocksDBKVSpaceReader
extends AbstractRocksDBKVSpaceReader
implements IKVSpaceRefreshableReader {
    private final ISyncContext.IRefresher refresher;
    private final Supplier<IRocksDBKVSpaceEpoch> dbSupplier;
    private final Supplier<Map<ByteString, ByteString>> metadataSupplier;
    private final AtomicReference<RocksDBSnapshot> snapshot = new AtomicReference();
    private final Set<RocksDBKVSpaceIterator> openedIterators = Sets.newConcurrentHashSet();
    private final IteratorOptions iteratorOptions;

    RocksDBKVSpaceReader(String id, KVSpaceOpMeters opMeters, Logger logger, ISyncContext.IRefresher refresher, Supplier<IRocksDBKVSpaceEpoch> dbSupplier, Supplier<Map<ByteString, ByteString>> metadataSupplier, IteratorOptions iteratorOptions) {
        super(id, opMeters, logger);
        this.refresher = refresher;
        this.dbSupplier = dbSupplier;
        this.metadataSupplier = metadataSupplier;
        this.snapshot.set(RocksDBSnapshot.take(dbSupplier.get()));
        this.iteratorOptions = iteratorOptions;
    }

    public void refresh() {
        this.refresher.runIfNeeded(genBumped -> {
            this.snapshot.getAndSet(RocksDBSnapshot.take(this.dbSupplier.get())).release();
            this.openedIterators.forEach(itr -> itr.refresh(this.snapshot.get()));
        });
    }

    public void close() {
        this.openedIterators.forEach(RocksDBKVSpaceIterator::close);
        RocksDBSnapshot oldSnapshot = this.snapshot.getAndSet(null);
        oldSnapshot.release();
    }

    @Override
    protected IRocksDBKVSpaceEpoch handle() {
        return this.dbSupplier.get();
    }

    @Override
    protected RocksDBSnapshot snapshot() {
        return this.snapshot.get();
    }

    protected Optional<ByteString> doMetadata(ByteString metaKey) {
        return (Optional)this.refresher.call(() -> {
            Map<ByteString, ByteString> metaMap = this.metadataSupplier.get();
            return Optional.ofNullable(metaMap.get(metaKey));
        });
    }

    protected IKVSpaceIterator doNewIterator(Boundary subBoundary) {
        assert (BoundaryUtil.isValid((Boundary)subBoundary));
        RocksDBKVSpaceIterator itr = new RocksDBKVSpaceIterator(this.snapshot(), subBoundary, this.openedIterators::remove, this.iteratorOptions);
        this.openedIterators.add(itr);
        return itr;
    }
}

