# Contributing to GeaFlow

Thank you for your interest in contributing to GeaFlow! We welcome all contributions and appreciate your support.

## Ways to Contribute

There are many ways to contribute to GeaFlow, and not all of them involve writing code. All forms of participation are valuable and help grow a healthy community. Here are some examples of how you can help:

- Answering questions and helping others in our community spaces (mailing list, GitHub Discussions, etc.).
- Reporting bugs, suggesting new features, or sharing your feedback.
- Reviewing and testing pull requests from other contributors.
- Translating documentation or other project materials.
- Organizing or promoting community events.
- Improving our project website, design, or user experience.
- Creating tutorials, blog posts, or videos to help others learn about GeaFlow.
- Spreading the word about GeaFlow through outreach and advocacy.
- Any other activity that helps the project and its users!

If you have an idea for a contribution, please share it with the community. Every contribution is welcome!

## Code of Conduct

Please follow our [Code of Conduct](../CODE_OF_CONDUCT.md) in all your interactions with the project.

## Coding Style

Please follow the Java style defined in `tools/intellij-java-style.xml` and the checkstyle rules in `tools/checkstyle.xml`. You can use IDE plugins to automatically format your code.

## Reporting Issues

If you find a bug or have a feature request, please open an issue on our [GitHub Issues](https://github.com/apache/geaflow/issues). Provide clear steps to reproduce the bug or a detailed description of your suggestion.

## Documentation

Our user and developer documentation can be found in the [docs folder](../docs). We welcome any improvements you can make!

## Community

- **Website**: [https://geaflow.apache.org/](https://geaflow.apache.org/)
- **Issue Tracker**: [https://github.com/apache/geaflow/issues](https://github.com/apache/geaflow/issues)
- **Mailing List**: [dev@geaflow.apache.org](mailto:dev@geaflow.apache.org)

Thank you for helping us improve GeaFlow!
