/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine.join;

import java.util.Iterator;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;

class JoinLib {
    static final boolean JOIN_EXPLAIN = false;
    public static final Object noKeyHash = new Object();
    public static final long nullHashCode = 5L;

    JoinLib() {
    }

    public static long hash(Var v, Node x) {
        long h = 17L;
        if (v != null) {
            h ^= (long)v.hashCode();
        }
        if (x != null) {
            h ^= (long)x.hashCode();
        }
        return h;
    }

    public static Object hash(Iterable<Var> joinKey, Binding row) {
        return JoinLib.hash(joinKey.iterator(), row);
    }

    public static Object hash(Iterator<Var> vars, Binding row) {
        long x = 31L;
        boolean seenJoinKeyVar = false;
        while (vars.hasNext()) {
            Var v = vars.next();
            Node value = row.get(v);
            long h = 5L;
            if (value != null) {
                seenJoinKeyVar = true;
                h = JoinLib.hash(v, value);
            }
            x ^= h;
        }
        if (!seenJoinKeyVar) {
            return noKeyHash;
        }
        return x;
    }
}

