/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shacl;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.lib.Pair;
import org.apache.jena.atlas.logging.FmtLog;
import org.apache.jena.atlas.web.HttpException;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.GraphUtil;
import org.apache.jena.graph.Node;
import org.apache.jena.irix.IRIs;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFParser;
import org.apache.jena.riot.RiotParseException;
import org.apache.jena.riot.system.stream.LocationMapper;
import org.apache.jena.riot.system.stream.StreamManager;
import org.apache.jena.shacl.sys.ShaclSystem;
import org.apache.jena.sparql.graph.GraphFactory;
import org.apache.jena.sparql.graph.NodeConst;
import org.apache.jena.system.G;
import org.apache.jena.system.RDFDataException;
import org.slf4j.Logger;

public class Imports {
    public static Logger importsLogger = ShaclSystem.shaclSystemLogger;
    private static final LocationMapper mapSHACL = new LocationMapper();
    public static StreamManager shaclImportsStreamManager;

    private Imports() {
    }

    public static Graph loadWithImports(String url) {
        url = IRIs.resolve(url);
        Graph graph = RDFDataMgr.loadGraph(url);
        return Imports.withImportsWorker(url, graph);
    }

    public static Graph withImports(Graph graph) {
        return Imports.withImportsWorker(null, graph);
    }

    public static Graph withImports(String url, Graph graph) {
        url = IRIs.resolve(url);
        return Imports.withImportsWorker(url, graph);
    }

    private static Graph withImportsWorker(String url, Graph graph) {
        boolean hasImports = G.contains(graph, null, NodeConst.nodeOwlImports, null);
        if (!hasImports) {
            return graph;
        }
        if (importsLogger.isDebugEnabled()) {
            importsLogger.debug("Imports");
        }
        Graph acc = GraphFactory.createDefaultGraph();
        GraphUtil.addInto(acc, graph);
        HashSet<String> visited = new HashSet<String>();
        if (url != null) {
            visited.add(url);
        }
        Imports.processImports(visited, graph, acc);
        return acc;
    }

    private static void processImports(Set<String> visited, Graph graph, Graph acc) {
        List<Node> imports = Imports.imports(graph);
        for (Node imported : imports) {
            if (!imported.isURI()) continue;
            String uri = imported.getURI();
            if (importsLogger.isDebugEnabled()) {
                importsLogger.debug("Import: " + uri);
            }
            if (visited.contains(uri)) {
                if (!importsLogger.isDebugEnabled()) continue;
                importsLogger.debug("Skipped: " + uri);
                continue;
            }
            visited.add(uri);
            Graph g2 = Imports.loadOneGraph(uri);
            GraphUtil.addInto(acc, g2);
            Imports.processImports(visited, g2, acc);
        }
    }

    private static Graph loadOneGraph(String uriOrFile) {
        try {
            return RDFParser.source(uriOrFile).streamManager(shaclImportsStreamManager).toGraph();
        }
        catch (HttpException ex) {
            if (ex.getStatusCode() == 404) {
                FmtLog.error(importsLogger, "Not found: %s", uriOrFile);
            } else {
                FmtLog.error(importsLogger, "HTTP exception: " + ex.getMessage(), new Object[0]);
            }
            throw ex;
        }
        catch (RiotParseException ex) {
            FmtLog.error(importsLogger, "Parse error reading '%s': %s", uriOrFile, ex.getMessage());
            throw ex;
        }
    }

    public static List<Node> imports(Graph graph) {
        Pair<Node, List<Node>> pair = Imports.baseAndImports(graph);
        return pair.getRight();
    }

    public static Pair<Node, List<Node>> baseAndImports(Graph graph) {
        Node base = null;
        if (G.containsOne(graph, null, NodeConst.nodeRDFType, NodeConst.nodeOwlOntology)) {
            base = G.getOnePO(graph, NodeConst.nodeRDFType, NodeConst.nodeOwlOntology);
        }
        List<Node> imports = Imports.allImports(base, graph);
        return Pair.create(base, imports);
    }

    public static Node base(Graph graph) {
        try {
            return G.getZeroOrOnePO(graph, NodeConst.nodeRDFType, NodeConst.nodeOwlOntology);
        }
        catch (RDFDataException ex) {
            return null;
        }
    }

    public static List<Node> allImports(Node base, Graph graph) {
        List<Node> imports = Iter.iter(G.listSP(graph, base, NodeConst.nodeOwlImports)).filter(Node::isURI).toList();
        return imports;
    }

    static {
        mapSHACL.addAltEntry("http://topbraid.org/tosh", "http://topbraid.org/tosh.ttl");
        mapSHACL.addAltEntry("http://datashapes.org/dash", "http://datashapes.org/dash.ttl");
        mapSHACL.addAltEntry("https://topbraid.org/tosh", "https://topbraid.org/tosh.ttl");
        mapSHACL.addAltEntry("https://datashapes.org/dash", "https://datashapes.org/dash.ttl");
        shaclImportsStreamManager = StreamManager.get().clone();
        if (!mapSHACL.isEmpty()) {
            shaclImportsStreamManager.locationMapper(mapSHACL.clone());
        }
    }
}

