/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.part;

import java.util.Map;
import java.util.function.Supplier;
import org.apache.http.Header;
import org.apache.http.NameValuePair;
import org.apache.juneau.annotation.BeanIgnore;
import org.apache.juneau.assertions.FluentStringAssertion;
import org.apache.juneau.commons.reflect.ClassInfo;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.ThrowableUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.http.header.BasicHeader;
import org.apache.juneau.http.header.Headerable;
import org.apache.juneau.http.part.NameValuePairable;

@BeanIgnore
public class BasicPart
implements NameValuePair,
Headerable {
    private final String name;
    private final Object value;

    public static boolean canCast(Object o) {
        if (o == null) {
            return false;
        }
        ClassInfo ci = ClassInfo.of(o);
        return Utils.nn(ci) && ci.isChildOfAny(Headerable.class, NameValuePair.class, NameValuePairable.class, Map.Entry.class);
    }

    public static NameValuePair cast(Object o) {
        if (o instanceof NameValuePair) {
            NameValuePair o2 = (NameValuePair)o;
            return o2;
        }
        if (o instanceof NameValuePairable) {
            NameValuePairable o3 = (NameValuePairable)o;
            return o3.asNameValuePair();
        }
        if (o instanceof NameValuePair) {
            NameValuePair o2 = (NameValuePair)o;
            return BasicPart.of(o2.getName(), o2.getValue());
        }
        if (o instanceof Headerable) {
            Headerable o2 = (Headerable)o;
            Header x = o2.asHeader();
            return BasicPart.of(x.getName(), x.getValue());
        }
        if (o instanceof Map.Entry) {
            Map.Entry e = (Map.Entry)o;
            return BasicPart.of(Utils.s(e.getKey()), e.getValue());
        }
        throw ThrowableUtils.rex("Object of type {0} could not be converted to a Part.", Utils.cn(o));
    }

    public static BasicPart of(String name, Object value) {
        return new BasicPart(name, value);
    }

    public static BasicPart ofPair(String pair) {
        if (pair == null) {
            return null;
        }
        int i = pair.indexOf(58);
        if (i == -1) {
            i = pair.indexOf(61);
        }
        if (i == -1) {
            return BasicPart.of(pair, "");
        }
        return BasicPart.of(pair.substring(0, i).trim(), pair.substring(i + 1).trim());
    }

    public BasicPart(String name, Object value) {
        this.name = name;
        this.value = value;
    }

    protected BasicPart(BasicPart copyFrom) {
        AssertionUtils.assertArgNotNull("copyFrom", copyFrom);
        this.name = copyFrom.name;
        this.value = copyFrom.value;
    }

    @Override
    public BasicHeader asHeader() {
        return BasicHeader.of(this.name, Utils.s(this.value));
    }

    public FluentStringAssertion<BasicPart> assertName() {
        return new FluentStringAssertion<BasicPart>(this.getName(), this);
    }

    public FluentStringAssertion<BasicPart> assertValue() {
        return new FluentStringAssertion<BasicPart>(this.getValue(), this);
    }

    public String getName() {
        return this.name;
    }

    public Object getRawValue() {
        return BasicPart.unwrap(this.value);
    }

    public String getValue() {
        return Utils.s(BasicPart.unwrap(this.value));
    }

    public String toString() {
        return this.getName() + "=" + this.getValue();
    }

    private static Object unwrap(Object o) {
        while (o instanceof Supplier) {
            o = ((Supplier)o).get();
        }
        return o;
    }
}

