/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.bean.openapi3;

import java.util.Set;
import org.apache.juneau.bean.openapi3.OAuthFlow;
import org.apache.juneau.bean.openapi3.OpenApiElement;
import org.apache.juneau.commons.collections.MultiSet;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.internal.ConverterUtils;

public class OAuthFlows
extends OpenApiElement {
    private OAuthFlow implicit;
    private OAuthFlow password;
    private OAuthFlow clientCredentials;
    private OAuthFlow authorizationCode;

    public OAuthFlows() {
    }

    public OAuthFlows(OAuthFlows copyFrom) {
        super(copyFrom);
        this.implicit = copyFrom.implicit;
        this.password = copyFrom.password;
        this.clientCredentials = copyFrom.clientCredentials;
        this.authorizationCode = copyFrom.authorizationCode;
    }

    public OAuthFlows copy() {
        return new OAuthFlows(this);
    }

    @Override
    public <T> T get(String property, Class<T> type) {
        AssertionUtils.assertArgNotNull("property", property);
        return switch (property) {
            case "implicit" -> ConverterUtils.toType(this.getImplicit(), type);
            case "password" -> ConverterUtils.toType(this.getPassword(), type);
            case "clientCredentials" -> ConverterUtils.toType(this.getClientCredentials(), type);
            case "authorizationCode" -> ConverterUtils.toType(this.getAuthorizationCode(), type);
            default -> super.get(property, type);
        };
    }

    public OAuthFlow getAuthorizationCode() {
        return this.authorizationCode;
    }

    public OAuthFlow getClientCredentials() {
        return this.clientCredentials;
    }

    public OAuthFlow getImplicit() {
        return this.implicit;
    }

    public OAuthFlow getPassword() {
        return this.password;
    }

    @Override
    public Set<String> keySet() {
        Set<String> s = CollectionUtils.setb(String.class).addIf(Utils.nn(this.authorizationCode), "authorizationCode").addIf(Utils.nn(this.clientCredentials), "clientCredentials").addIf(Utils.nn(this.implicit), "implicit").addIf(Utils.nn(this.password), "password").build();
        return new MultiSet<String>(s, super.keySet());
    }

    @Override
    public OAuthFlows set(String property, Object value) {
        AssertionUtils.assertArgNotNull("property", property);
        return switch (property) {
            case "authorizationCode" -> this.setAuthorizationCode(ConverterUtils.toType(value, OAuthFlow.class));
            case "clientCredentials" -> this.setClientCredentials(ConverterUtils.toType(value, OAuthFlow.class));
            case "implicit" -> this.setImplicit(ConverterUtils.toType(value, OAuthFlow.class));
            case "password" -> this.setPassword(ConverterUtils.toType(value, OAuthFlow.class));
            default -> {
                super.set(property, value);
                yield this;
            }
        };
    }

    public OAuthFlows setAuthorizationCode(OAuthFlow value) {
        this.authorizationCode = value;
        return this;
    }

    public OAuthFlows setClientCredentials(OAuthFlow value) {
        this.clientCredentials = value;
        return this;
    }

    public OAuthFlows setImplicit(OAuthFlow value) {
        this.implicit = value;
        return this;
    }

    public OAuthFlows setPassword(OAuthFlow value) {
        this.password = value;
        return this;
    }

    @Override
    public OAuthFlows strict(Object value) {
        super.strict(value);
        return this;
    }

    @Override
    protected OAuthFlows strict() {
        super.strict();
        return this;
    }
}

