/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.assertions;

import java.io.PrintStream;
import org.apache.juneau.assertions.Assertion;
import org.apache.juneau.assertions.FluentComparableAssertion;
import org.apache.juneau.cp.Messages;

public class FluentBooleanAssertion<R>
extends FluentComparableAssertion<Boolean, R> {
    private static final Messages MESSAGES = Messages.of(FluentBooleanAssertion.class, (String)"Messages");
    private static final String MSG_valueWasFalse = MESSAGES.getString("valueWasFalse");
    private static final String MSG_valueWasTrue = MESSAGES.getString("valueWasTrue");

    public FluentBooleanAssertion(Assertion creator, Boolean value, R returns) {
        super(creator, value, returns);
    }

    public FluentBooleanAssertion(Boolean value, R returns) {
        this((Assertion)null, value, returns);
    }

    public R isFalse() throws AssertionError {
        if (Boolean.TRUE.equals(this.value())) {
            throw this.error(MSG_valueWasTrue, new Object[0]);
        }
        return this.returns();
    }

    public R isTrue() throws AssertionError {
        if (Boolean.FALSE.equals(this.value())) {
            throw this.error(MSG_valueWasFalse, new Object[0]);
        }
        return this.returns();
    }

    @Override
    public FluentBooleanAssertion<R> setMsg(String msg, Object ... args) {
        super.setMsg(msg, args);
        return this;
    }

    @Override
    public FluentBooleanAssertion<R> setOut(PrintStream value) {
        super.setOut(value);
        return this;
    }

    @Override
    public FluentBooleanAssertion<R> setSilent() {
        super.setSilent();
        return this;
    }

    @Override
    public FluentBooleanAssertion<R> setStdOut() {
        super.setStdOut();
        return this;
    }

    @Override
    public FluentBooleanAssertion<R> setThrowable(Class<? extends RuntimeException> value) {
        super.setThrowable((Class)value);
        return this;
    }
}

