/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.rest;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.model.rest.CollectionFormat;
import org.apache.camel.model.rest.RestOperationResponseMsgDefinition;
import org.apache.camel.spi.Metadata;
import org.apache.camel.util.StringHelper;

@Metadata(label="rest")
@XmlRootElement(name="responseHeader")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class RestOperationResponseHeaderDefinition {
    @XmlTransient
    private RestOperationResponseMsgDefinition response;
    @XmlAttribute(required=true)
    private String name;
    @XmlAttribute
    @Metadata(defaultValue="")
    private String description;
    @XmlAttribute
    @Metadata(defaultValue="csv")
    private CollectionFormat collectionFormat = CollectionFormat.csv;
    @XmlAttribute
    @Metadata(defaultValue="string")
    private String arrayType = "string";
    @XmlAttribute
    @Metadata(defaultValue="string")
    private String dataType = "string";
    @XmlAttribute
    private String dataFormat;
    @XmlElementWrapper(name="allowableValues")
    @XmlElement(name="value")
    private List<String> allowableValues;
    @XmlAttribute
    private String example;

    public RestOperationResponseHeaderDefinition(RestOperationResponseMsgDefinition response) {
        this();
        this.response = response;
    }

    public RestOperationResponseHeaderDefinition() {
    }

    public RestOperationResponseMsgDefinition endResponseHeader() {
        return this.response;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public CollectionFormat getCollectionFormat() {
        return this.collectionFormat;
    }

    public void setCollectionFormat(CollectionFormat collectionFormat) {
        this.collectionFormat = collectionFormat;
    }

    public String getArrayType() {
        return this.arrayType;
    }

    public void setArrayType(String arrayType) {
        this.arrayType = arrayType;
    }

    public String getDataType() {
        return this.dataType;
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    public String getDataFormat() {
        return this.dataFormat;
    }

    public void setDataFormat(String dataFormat) {
        this.dataFormat = dataFormat;
    }

    public List<String> getAllowableValues() {
        if (this.allowableValues != null) {
            return this.allowableValues;
        }
        return new ArrayList<String>();
    }

    public String getExample() {
        return this.example;
    }

    public void setExample(String example) {
        this.example = example;
    }

    public void setAllowableValues(List<String> allowableValues) {
        this.allowableValues = allowableValues;
    }

    public RestOperationResponseHeaderDefinition name(String name) {
        this.setName(name);
        return this;
    }

    public RestOperationResponseHeaderDefinition description(String name) {
        this.setDescription(name);
        return this;
    }

    public RestOperationResponseHeaderDefinition collectionFormat(CollectionFormat collectionFormat) {
        this.setCollectionFormat(collectionFormat);
        return this;
    }

    public RestOperationResponseHeaderDefinition arrayType(String arrayType) {
        this.setArrayType(arrayType);
        return this;
    }

    public RestOperationResponseHeaderDefinition dataType(String type) {
        this.setDataType(type);
        return this;
    }

    public RestOperationResponseHeaderDefinition dataFormat(String type) {
        this.setDataFormat(type);
        return this;
    }

    public RestOperationResponseHeaderDefinition allowableValues(List<String> allowableValues) {
        this.setAllowableValues(allowableValues);
        return this;
    }

    public RestOperationResponseHeaderDefinition allowableValues(String ... allowableValues) {
        this.setAllowableValues(Arrays.asList(allowableValues));
        return this;
    }

    public RestOperationResponseHeaderDefinition example(String example) {
        this.setExample(example);
        return this;
    }

    public RestOperationResponseMsgDefinition endHeader() {
        StringHelper.notEmpty((String)this.name, (String)"name");
        StringHelper.notEmpty((String)this.dataType, (String)"dataType");
        return this.response;
    }
}

