/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.config.command;

import org.apache.felix.utils.properties.TypedProperties;
import org.apache.karaf.config.command.ConfigCommandSupport;
import org.apache.karaf.config.command.completers.ConfigurationCompleter;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;

public abstract class ConfigPropertyCommandSupport
extends ConfigCommandSupport {
    @Option(name="-p", aliases={"--pid"}, description="The configuration pid", required=false, multiValued=false)
    @Completion(value=ConfigurationCompleter.class)
    protected String pid;

    @Override
    protected Object doExecute() throws Exception {
        TypedProperties props = this.getEditedProps();
        if (props == null && this.pid == null) {
            System.err.println("No configuration is being edited--run the edit command first");
        } else {
            if (props == null) {
                props = new TypedProperties();
            }
            this.propertyAction(props);
            if (this.requiresUpdate(this.pid)) {
                this.configRepository.update(this.pid, props);
            }
        }
        return null;
    }

    protected abstract void propertyAction(TypedProperties var1);

    protected boolean requiresUpdate(String pid) {
        return pid != null;
    }

    @Override
    protected TypedProperties getEditedProps() throws Exception {
        if (this.pid != null) {
            return this.configRepository.getConfig(this.pid);
        }
        return super.getEditedProps();
    }
}

