/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.features.internal.download.impl;

import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class DownloadManagerHelper {
    private static final String DEFAULT_IGNORED_PROTOCOL_PATTERN = "jar|war|war-i|warref|webbundle|wrap|spring|blueprint";
    private static Pattern ignoredProtocolPattern;

    private DownloadManagerHelper() {
    }

    public static Pattern getIgnoredProtocolPattern() {
        return ignoredProtocolPattern;
    }

    private static void setIgnoredProtocolPattern(String pattern) {
        String defaultPattRegex = "^(" + pattern + "):.*$";
        ignoredProtocolPattern = Pattern.compile(defaultPattRegex);
    }

    public static void setExtraProtocols(Collection<String> protocols) {
        StringBuilder sb = new StringBuilder(DEFAULT_IGNORED_PROTOCOL_PATTERN);
        for (String proto : protocols) {
            sb.append("|" + proto);
        }
        DownloadManagerHelper.setIgnoredProtocolPattern(sb.toString());
    }

    public static String stripUrl(String url) {
        String strippedUrl = url;
        Matcher matcher = ignoredProtocolPattern.matcher(strippedUrl);
        while (matcher.matches()) {
            String protocol = matcher.group(1);
            strippedUrl = strippedUrl.substring(protocol.length() + 1);
            matcher = ignoredProtocolPattern.matcher(strippedUrl);
        }
        if (strippedUrl.contains("?")) {
            strippedUrl = strippedUrl.substring(0, strippedUrl.indexOf(63));
        }
        if (strippedUrl.contains("$")) {
            strippedUrl = strippedUrl.substring(0, strippedUrl.indexOf(36));
        }
        if (strippedUrl.contains("#")) {
            strippedUrl = strippedUrl.substring(0, strippedUrl.indexOf(35));
        }
        if (strippedUrl.contains(";start-level=")) {
            strippedUrl = strippedUrl.substring(0, strippedUrl.indexOf(";start-level="));
        }
        return strippedUrl;
    }

    public static String stripStartLevel(String url) {
        String strippedUrl = url;
        if (strippedUrl.contains(";start-level=")) {
            strippedUrl = strippedUrl.substring(0, strippedUrl.indexOf(";start-level="));
        }
        return strippedUrl;
    }

    public static String stripInlinedMavenRepositoryUrl(String url) {
        if (url.startsWith("mvn:") && url.contains("!")) {
            return url.substring(4, url.indexOf(33));
        }
        return null;
    }

    public static String removeInlinedMavenRepositoryUrl(String url) {
        if (url.startsWith("mvn:") && url.contains("!")) {
            return "mvn:" + url.substring(url.indexOf(33) + 1);
        }
        return url;
    }

    static {
        DownloadManagerHelper.setIgnoredProtocolPattern(DEFAULT_IGNORED_PROTOCOL_PATTERN);
    }
}

