/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.service.authentication;

import javax.security.sasl.AuthenticationException;
import org.apache.commons.lang3.StringUtils;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.config.KyuubiConf$;
import org.apache.kyuubi.service.authentication.AnonymousAuthenticationProviderImpl;
import org.apache.kyuubi.service.authentication.AuthMethods$;
import org.apache.kyuubi.service.authentication.EngineSecureAuthenticationProviderImpl;
import org.apache.kyuubi.service.authentication.JdbcAuthenticationProviderImpl;
import org.apache.kyuubi.service.authentication.LdapAuthenticationProviderImpl;
import org.apache.kyuubi.service.authentication.LdapAuthenticationProviderImpl$;
import org.apache.kyuubi.service.authentication.PasswdAuthenticationProvider;
import org.apache.kyuubi.service.authentication.TokenAuthenticationProvider;
import org.apache.kyuubi.util.ClassUtils$;
import scala.Enumeration;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.runtime.BoxesRunTime;

public final class AuthenticationProviderFactory$ {
    public static AuthenticationProviderFactory$ MODULE$;

    static {
        new AuthenticationProviderFactory$();
    }

    public PasswdAuthenticationProvider getAuthenticationProvider(Enumeration.Value method, KyuubiConf conf, boolean isServer) throws AuthenticationException {
        if (isServer) {
            return this.getAuthenticationProviderForServer(method, conf);
        }
        return this.getAuthenticationProviderForEngine(conf);
    }

    public boolean getAuthenticationProvider$default$3() {
        return true;
    }

    private PasswdAuthenticationProvider getAuthenticationProviderForServer(Enumeration.Value method, KyuubiConf conf) {
        Enumeration.Value value = method;
        Enumeration.Value value2 = AuthMethods$.MODULE$.NONE();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            return new AnonymousAuthenticationProviderImpl();
        }
        Enumeration.Value value4 = AuthMethods$.MODULE$.LDAP();
        Enumeration.Value value5 = value;
        if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
            return new LdapAuthenticationProviderImpl(conf, LdapAuthenticationProviderImpl$.MODULE$.$lessinit$greater$default$2());
        }
        Enumeration.Value value6 = AuthMethods$.MODULE$.JDBC();
        Enumeration.Value value7 = value;
        if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
            return new JdbcAuthenticationProviderImpl(conf);
        }
        Enumeration.Value value8 = AuthMethods$.MODULE$.CUSTOM();
        Enumeration.Value value9 = value;
        if (!(value8 != null ? !value8.equals(value9) : value9 != null)) {
            Option className = (Option)conf.get(KyuubiConf$.MODULE$.AUTHENTICATION_CUSTOM_CLASS());
            Predef$.MODULE$.require(className.nonEmpty(), (Function0 & java.io.Serializable & Serializable)() -> "kyuubi.authentication.custom.class must be set when auth method was CUSTOM.");
            return ClassUtils$.MODULE$.createInstance((String)className.get(), PasswdAuthenticationProvider.class, conf);
        }
        throw new AuthenticationException("Not a valid authentication method");
    }

    private PasswdAuthenticationProvider getAuthenticationProviderForEngine(KyuubiConf conf) {
        if (BoxesRunTime.unboxToBoolean((Object)conf.get(KyuubiConf$.MODULE$.ENGINE_SECURITY_ENABLED()))) {
            return new EngineSecureAuthenticationProviderImpl();
        }
        return new AnonymousAuthenticationProviderImpl();
    }

    public PasswdAuthenticationProvider getHttpBasicAuthenticationProvider(Enumeration.Value method, KyuubiConf conf) {
        Enumeration.Value value = method;
        Enumeration.Value value2 = AuthMethods$.MODULE$.NONE();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            return new AnonymousAuthenticationProviderImpl();
        }
        Enumeration.Value value4 = AuthMethods$.MODULE$.LDAP();
        Enumeration.Value value5 = value;
        if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
            return new LdapAuthenticationProviderImpl(conf, LdapAuthenticationProviderImpl$.MODULE$.$lessinit$greater$default$2());
        }
        Enumeration.Value value6 = AuthMethods$.MODULE$.JDBC();
        Enumeration.Value value7 = value;
        if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
            return new JdbcAuthenticationProviderImpl(conf);
        }
        Enumeration.Value value8 = AuthMethods$.MODULE$.CUSTOM();
        Enumeration.Value value9 = value;
        if (!(value8 != null ? !value8.equals(value9) : value9 != null)) {
            Option<String> className = conf.get(KyuubiConf$.MODULE$.AUTHENTICATION_CUSTOM_BASIC_CLASS());
            Predef$.MODULE$.require(className.nonEmpty(), (Function0 & java.io.Serializable & Serializable)() -> "kyuubi.authentication.custom.basic.class must be set for http basic authentication.");
            return ClassUtils$.MODULE$.createInstance((String)className.get(), PasswdAuthenticationProvider.class, conf);
        }
        throw new AuthenticationException("Not a valid authentication method");
    }

    public TokenAuthenticationProvider getHttpBearerAuthenticationProvider(String providerClass, KyuubiConf conf) {
        Predef$.MODULE$.require(!StringUtils.isBlank((CharSequence)providerClass), (Function0 & java.io.Serializable & Serializable)() -> "kyuubi.authentication.custom.bearer.class must be set for http bearer authentication.");
        return ClassUtils$.MODULE$.createInstance(providerClass, TokenAuthenticationProvider.class, conf);
    }

    private AuthenticationProviderFactory$() {
        MODULE$ = this;
    }
}

