/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.kyuubi;

import java.io.Serializable;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.config.KyuubiConf$;
import org.apache.kyuubi.engine.spark.events.SessionEvent;
import org.apache.kyuubi.engine.spark.events.SparkOperationEvent;
import org.apache.spark.scheduler.SparkListener;
import org.apache.spark.scheduler.SparkListenerEvent;
import org.apache.spark.status.ElementTrackingStore;
import org.apache.spark.status.KVUtils$;
import org.apache.spark.util.kvstore.KVStoreView;
import scala.Function1;
import scala.collection.immutable.Seq;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005-4AAD\b\u00011!Aq\u0004\u0001B\u0001B\u0003%\u0001\u0005\u0003\u0005'\u0001\t\u0005\t\u0015!\u0003(\u0011\u0015q\u0003\u0001\"\u00010\u0011\u001d!\u0004A1A\u0005\nUBa\u0001\u0010\u0001!\u0002\u00131\u0004bB\u001f\u0001\u0005\u0004%I!\u000e\u0005\u0007}\u0001\u0001\u000b\u0011\u0002\u001c\t\u000b}\u0002A\u0011\t!\t\u000b%\u0003A\u0011\u0002&\t\u000bU\u0003A\u0011\u0002,\t\u000bm\u0003A\u0011\u0002/\t\u000b\t\u0004A\u0011B2\t\u000b\u0015\u0004A\u0011\u00024\u00037M\u0003\u0018M]6T#2+enZ5oK\u00163XM\u001c;MSN$XM\\3s\u0015\t\u0001\u0012#\u0001\u0004lsV,(-\u001b\u0006\u0003%M\tQa\u001d9be.T!\u0001F\u000b\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u00051\u0012aA8sO\u000e\u00011C\u0001\u0001\u001a!\tQR$D\u0001\u001c\u0015\ta\u0012#A\u0005tG\",G-\u001e7fe&\u0011ad\u0007\u0002\u000e'B\f'o\u001b'jgR,g.\u001a:\u0002\u000f-48\u000f^8sKB\u0011\u0011\u0005J\u0007\u0002E)\u00111%E\u0001\u0007gR\fG/^:\n\u0005\u0015\u0012#\u0001F#mK6,g\u000e\u001e+sC\u000e\\\u0017N\\4Ti>\u0014X-\u0001\u0006lsV,(-[\"p]\u001a\u0004\"\u0001\u000b\u0017\u000e\u0003%R!AK\u0016\u0002\r\r|gNZ5h\u0015\t\u00012#\u0003\u0002.S\tQ1*_;vE&\u001cuN\u001c4\u0002\rqJg.\u001b;?)\r\u0001$g\r\t\u0003c\u0001i\u0011a\u0004\u0005\u0006?\r\u0001\r\u0001\t\u0005\u0006M\r\u0001\raJ\u0001\u0011e\u0016$\u0018-\u001b8fIN+7o]5p]N,\u0012A\u000e\t\u0003oij\u0011\u0001\u000f\u0006\u0002s\u0005)1oY1mC&\u00111\b\u000f\u0002\u0004\u0013:$\u0018!\u0005:fi\u0006Lg.\u001a3TKN\u001c\u0018n\u001c8tA\u0005\u0011\"/\u001a;bS:,Gm\u0015;bi\u0016lWM\u001c;t\u0003M\u0011X\r^1j]\u0016$7\u000b^1uK6,g\u000e^:!\u00031ygn\u0014;iKJ,e/\u001a8u)\t\tE\t\u0005\u00028\u0005&\u00111\t\u000f\u0002\u0005+:LG\u000fC\u0003F\u0011\u0001\u0007a)A\u0003fm\u0016tG\u000f\u0005\u0002\u001b\u000f&\u0011\u0001j\u0007\u0002\u0013'B\f'o\u001b'jgR,g.\u001a:Fm\u0016tG/\u0001\nva\u0012\fG/Z*fgNLwN\\*u_J,GCA!L\u0011\u0015)\u0015\u00021\u0001M!\ti5+D\u0001O\u0015\ty\u0005+\u0001\u0004fm\u0016tGo\u001d\u0006\u0003%ES!AU\u0016\u0002\r\u0015tw-\u001b8f\u0013\t!fJ\u0001\u0007TKN\u001c\u0018n\u001c8Fm\u0016tG/\u0001\u000bva\u0012\fG/Z*uCR,W.\u001a8u'R|'/\u001a\u000b\u0003\u0003^CQ!\u0012\u0006A\u0002a\u0003\"!T-\n\u0005is%aE*qCJ\\w\n]3sCRLwN\\#wK:$\u0018AD2mK\u0006tW\u000f]*fgNLwN\u001c\u000b\u0003\u0003vCQAX\u0006A\u0002}\u000bQaY8v]R\u0004\"a\u000e1\n\u0005\u0005D$\u0001\u0002'p]\u001e\f\u0001c\u00197fC:,\bo\u00149fe\u0006$\u0018n\u001c8\u0015\u0005\u0005#\u0007\"\u00020\r\u0001\u0004y\u0016aF2bY\u000e,H.\u0019;f\u001dVl'-\u001a:U_J+Wn\u001c<f)\ryv-\u001b\u0005\u0006Q6\u0001\raX\u0001\tI\u0006$\u0018mU5{K\")!.\u0004a\u0001?\u0006a!/\u001a;bS:,GmU5{K\u0002")
public class SparkSQLEngineEventListener
extends SparkListener {
    private final ElementTrackingStore kvstore;
    private final int retainedSessions;
    private final int retainedStatements;

    private int retainedSessions() {
        return this.retainedSessions;
    }

    private int retainedStatements() {
        return this.retainedStatements;
    }

    public void onOtherEvent(SparkListenerEvent event) {
        SparkListenerEvent sparkListenerEvent = event;
        if (sparkListenerEvent instanceof SessionEvent) {
            SessionEvent sessionEvent = (SessionEvent)sparkListenerEvent;
            this.updateSessionStore(sessionEvent);
            return;
        }
        if (sparkListenerEvent instanceof SparkOperationEvent) {
            SparkOperationEvent sparkOperationEvent = (SparkOperationEvent)sparkListenerEvent;
            this.updateStatementStore(sparkOperationEvent);
            return;
        }
    }

    private void updateSessionStore(SessionEvent event) {
        this.kvstore.write((Object)event, event.endTime() == -1L);
    }

    private void updateStatementStore(SparkOperationEvent event) {
        this.kvstore.write((Object)event, true);
    }

    private void cleanupSession(long count) {
        long countToDelete = this.calculateNumberToRemove(count, this.retainedSessions());
        if (countToDelete <= 0L) {
            return;
        }
        KVStoreView view = this.kvstore.view(SessionEvent.class).index("endTime").first((Object)BoxesRunTime.boxToLong((long)0L));
        Seq toDelete = KVUtils$.MODULE$.viewToSeq(view, (int)countToDelete, (Function1 & Serializable)j -> BoxesRunTime.boxToBoolean((boolean)SparkSQLEngineEventListener.$anonfun$cleanupSession$1(j)));
        toDelete.foreach((Function1 & Serializable)j -> {
            this.kvstore.delete(j.getClass(), (Object)j.sessionId());
            return BoxedUnit.UNIT;
        });
    }

    private void cleanupOperation(long count) {
        long countToDelete = this.calculateNumberToRemove(count, this.retainedStatements());
        if (countToDelete <= 0L) {
            return;
        }
        KVStoreView view = this.kvstore.view(SparkOperationEvent.class).index("completeTime").first((Object)BoxesRunTime.boxToLong((long)0L));
        Seq toDelete = KVUtils$.MODULE$.viewToSeq(view, (int)countToDelete, (Function1 & Serializable)j -> BoxesRunTime.boxToBoolean((boolean)SparkSQLEngineEventListener.$anonfun$cleanupOperation$1(j)));
        toDelete.foreach((Function1 & Serializable)j -> {
            this.kvstore.delete(j.getClass(), (Object)j.statementId());
            return BoxedUnit.UNIT;
        });
    }

    private long calculateNumberToRemove(long dataSize, long retainedSize) {
        if (dataSize > retainedSize) {
            return package$.MODULE$.max(retainedSize / 10L, dataSize - retainedSize);
        }
        return 0L;
    }

    public static final /* synthetic */ boolean $anonfun$cleanupSession$1(SessionEvent j) {
        return j.endTime() != 0L;
    }

    public static final /* synthetic */ boolean $anonfun$cleanupOperation$1(SparkOperationEvent j) {
        return j.completeTime() != 0L;
    }

    public SparkSQLEngineEventListener(ElementTrackingStore kvstore, KyuubiConf kyuubiConf) {
        this.kvstore = kvstore;
        this.retainedSessions = BoxesRunTime.unboxToInt((Object)kyuubiConf.get(KyuubiConf$.MODULE$.ENGINE_UI_SESSION_LIMIT()));
        this.retainedStatements = BoxesRunTime.unboxToInt((Object)kyuubiConf.get(KyuubiConf$.MODULE$.ENGINE_UI_STATEMENT_LIMIT()));
        kvstore.addTrigger(SessionEvent.class, (long)this.retainedSessions(), (Function1)(JFunction1.mcVJ.sp & Serializable)count -> this.cleanupSession(count));
        kvstore.addTrigger(SparkOperationEvent.class, (long)this.retainedStatements(), (Function1)(JFunction1.mcVJ.sp & Serializable)count -> this.cleanupOperation(count));
    }
}

