/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.byTask.tasks;

import java.util.ArrayList;
import org.apache.lucene.benchmark.byTask.PerfRunData;
import org.apache.lucene.benchmark.byTask.feeds.FacetSource;
import org.apache.lucene.benchmark.byTask.tasks.AddDocTask;
import org.apache.lucene.facet.FacetField;
import org.apache.lucene.facet.FacetsConfig;
import org.apache.lucene.index.IndexableField;

public class AddFacetedDocTask
extends AddDocTask {
    private FacetsConfig config;

    public AddFacetedDocTask(PerfRunData runData) {
        super(runData);
    }

    @Override
    public void setup() throws Exception {
        boolean withFacets;
        super.setup();
        if (this.config == null && (withFacets = this.getRunData().getConfig().get("with.facets", true))) {
            FacetSource facetsSource = this.getRunData().getFacetSource();
            this.config = new FacetsConfig();
            facetsSource.configure(this.config);
        }
    }

    @Override
    protected String getLogMessage(int recsCount) {
        if (this.config == null) {
            return super.getLogMessage(recsCount);
        }
        return super.getLogMessage(recsCount) + " with facets";
    }

    @Override
    public int doLogic() throws Exception {
        if (this.config != null) {
            ArrayList<FacetField> facets = new ArrayList<FacetField>();
            this.getRunData().getFacetSource().getNextFacets(facets);
            for (FacetField ff : facets) {
                this.doc.add((IndexableField)ff);
            }
            this.doc = this.config.build(this.getRunData().getTaxonomyWriter(), this.doc);
        }
        return super.doLogic();
    }
}

