/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.editor.document;

import java.util.logging.Logger;
import javax.swing.text.Document;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.modules.editor.lib2.document.EditorDocumentHandler;
import org.netbeans.spi.editor.document.DocumentFactory;
import org.openide.filesystems.FileObject;
import org.openide.util.Parameters;

public final class EditorDocumentUtils {
    private static final Logger LOG = Logger.getLogger(EditorDocumentUtils.class.getName());

    private EditorDocumentUtils() {
    }

    public static void runExclusive(Document doc, Runnable r) {
        EditorDocumentHandler.runExclusive(doc, r);
    }

    @CheckForNull
    public static FileObject getFileObject(@NonNull Document doc) {
        Parameters.notNull("doc", doc);
        DocumentFactory df = MimeLookup.getLookup(MimePath.EMPTY).lookup(DocumentFactory.class);
        if (df != null) {
            return df.getFileObject(doc);
        }
        LOG.warning("No DocumentFactory registered in the lookup.");
        return null;
    }
}

