/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.query.engine.parsing.expression.accessor;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Locale;
import org.apache.qpid.server.query.engine.exception.QueryEvaluationException;
import org.apache.qpid.server.query.engine.parsing.expression.AbstractExpressionNode;

public class ObjectAccessorExpression<T, R>
extends AbstractExpressionNode<T, R> {
    private final String _property;

    public ObjectAccessorExpression(String property) {
        this._property = property;
    }

    @Override
    public R apply(T value) {
        if ("*".equals(this._property)) {
            return (R)this._property;
        }
        if (value == null) {
            return null;
        }
        if (this._property.charAt(0) == '$') {
            return null;
        }
        try {
            String property = this._property.charAt(0) == '_' ? this._property.substring(1) : this._property;
            String getter = "get" + property.substring(0, 1).toUpperCase(Locale.US) + property.substring(1);
            PropertyDescriptor propertyDescriptor = new PropertyDescriptor(this._property, value.getClass(), getter, null);
            Method method = propertyDescriptor.getReadMethod();
            return (R)method.invoke(value, new Object[0]);
        }
        catch (IntrospectionException | IllegalAccessException | InvocationTargetException e) {
            throw QueryEvaluationException.of("Field '%s' inaccessible: %s", e.getMessage());
        }
    }
}

