/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.protobuf.internal.schema.serializer.repeated.impl.ints;

import io.protostuff.compiler.model.Field;
import io.protostuff.runtime.FieldSchema;
import org.apache.servicecomb.foundation.protobuf.internal.ProtoUtils;
import org.apache.servicecomb.foundation.protobuf.internal.bean.PropertyDescriptor;
import org.apache.servicecomb.foundation.protobuf.internal.schema.serializer.repeated.AbstractPrimitiveWriters;
import org.apache.servicecomb.foundation.protobuf.internal.schema.serializer.repeated.RepeatedPrimitiveWriteSchemas;

public class Int32NotPackedWriteSchemas {
    public static <T> FieldSchema<T> create(Field protoField, PropertyDescriptor propertyDescriptor) {
        return RepeatedPrimitiveWriteSchemas.create(protoField, propertyDescriptor, new Int32NotPackedWriters(protoField));
    }

    private static class Int32NotPackedWriters
    extends AbstractPrimitiveWriters<int[], Integer> {
        public Int32NotPackedWriters(Field protoField) {
            super(protoField);
            this.primitiveArrayWriter = (output, array) -> {
                for (int element : array) {
                    output.writeInt32(this.tag, this.tagSize, element);
                }
            };
            this.arrayWriter = (output, array) -> {
                for (Integer element : array) {
                    if (element != null) {
                        output.writeInt32(this.tag, this.tagSize, element);
                        continue;
                    }
                    ProtoUtils.throwNotSupportNullElement(protoField);
                }
            };
            this.collectionWriter = (output, collection) -> {
                for (Integer element : collection) {
                    if (element != null) {
                        output.writeInt32(this.tag, this.tagSize, element);
                        continue;
                    }
                    ProtoUtils.throwNotSupportNullElement(protoField);
                }
            };
            this.stringArrayWriter = (output, array) -> {
                for (String element : array) {
                    if (element != null) {
                        int parsedValue = Integer.parseInt(element, 10);
                        output.writeInt32(this.tag, this.tagSize, parsedValue);
                        continue;
                    }
                    ProtoUtils.throwNotSupportNullElement(protoField);
                }
            };
        }
    }
}

