/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.library.pprof.parser;

import java.util.List;
import org.apache.skywalking.oap.server.library.pprof.type.Frame;
import org.apache.skywalking.oap.server.library.pprof.type.FrameTree;

public class PprofMergeBuilder {
    private final Frame root = new Frame("root");

    public PprofMergeBuilder merge(List<FrameTree> trees) {
        if (trees == null || trees.isEmpty()) {
            return this;
        }
        for (FrameTree tree : trees) {
            this.merge0(this.root, tree);
        }
        return this;
    }

    public PprofMergeBuilder merge(FrameTree tree) {
        this.merge0(this.root, tree);
        return this;
    }

    private void merge0(Frame frame, FrameTree tree) {
        if (tree == null) {
            return;
        }
        if (tree.getChildren() != null) {
            for (FrameTree childTree : tree.getChildren()) {
                Frame child = this.addChild(frame, childTree.getSignature());
                this.merge0(child, childTree);
            }
        }
        frame.setTotal(frame.getTotal() + tree.getTotal());
        frame.setSelf(frame.getSelf() + tree.getSelf());
    }

    private Frame addChild(Frame parent, String signature) {
        return parent.getChild(signature);
    }

    public FrameTree build() {
        return FrameTree.buildTree(this.root);
    }
}

