/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base;

import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.storage.StorageException;
import org.apache.skywalking.oap.server.core.storage.annotation.ElasticSearch;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.StorageModuleElasticsearchConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnalyzerSetting {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AnalyzerSetting.class);
    private Map<String, Object> tokenizer = new HashMap<String, Object>();
    @SerializedName(value="char_filter")
    private Map<String, Object> charFilter = new HashMap<String, Object>();
    private Map<String, Object> filter = new HashMap<String, Object>();
    private Map<String, Object> analyzer = new HashMap<String, Object>();

    public void combine(AnalyzerSetting analyzerSetting) {
        this.analyzer.putAll(analyzerSetting.getAnalyzer());
        this.tokenizer.putAll(analyzerSetting.tokenizer);
        this.filter.putAll(analyzerSetting.filter);
        this.charFilter.putAll(analyzerSetting.charFilter);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AnalyzerSetting)) {
            return false;
        }
        AnalyzerSetting that = (AnalyzerSetting)o;
        return this.getTokenizer().equals(that.getTokenizer()) && this.getCharFilter().equals(that.getCharFilter()) && this.getFilter().equals(that.getFilter()) && this.getAnalyzer().equals(that.getAnalyzer());
    }

    public int hashCode() {
        return Objects.hash(this.getTokenizer(), this.getCharFilter(), this.getFilter(), this.getAnalyzer());
    }

    @Generated
    public Map<String, Object> getTokenizer() {
        return this.tokenizer;
    }

    @Generated
    public Map<String, Object> getCharFilter() {
        return this.charFilter;
    }

    @Generated
    public Map<String, Object> getFilter() {
        return this.filter;
    }

    @Generated
    public Map<String, Object> getAnalyzer() {
        return this.analyzer;
    }

    @Generated
    public void setTokenizer(Map<String, Object> tokenizer) {
        this.tokenizer = tokenizer;
    }

    @Generated
    public void setCharFilter(Map<String, Object> charFilter) {
        this.charFilter = charFilter;
    }

    @Generated
    public void setFilter(Map<String, Object> filter) {
        this.filter = filter;
    }

    @Generated
    public void setAnalyzer(Map<String, Object> analyzer) {
        this.analyzer = analyzer;
    }

    @FunctionalInterface
    public static interface GenerateAnalyzerSettingFunc {
        public AnalyzerSetting generate(StorageModuleElasticsearchConfig var1);
    }

    public static enum Generator {
        OAP_ANALYZER_SETTING_GENERATOR(ElasticSearch.MatchQuery.AnalyzerType.OAP_ANALYZER, config -> (AnalyzerSetting)new Gson().fromJson(config.getOapAnalyzer(), AnalyzerSetting.class)),
        OAP_LOG_ANALYZER_SETTING_GENERATOR(ElasticSearch.MatchQuery.AnalyzerType.OAP_LOG_ANALYZER, config -> (AnalyzerSetting)new Gson().fromJson(config.getOapLogAnalyzer(), AnalyzerSetting.class));

        private final ElasticSearch.MatchQuery.AnalyzerType type;
        private final GenerateAnalyzerSettingFunc func;

        private Generator(ElasticSearch.MatchQuery.AnalyzerType type, GenerateAnalyzerSettingFunc func) {
            this.type = type;
            this.func = func;
        }

        public GenerateAnalyzerSettingFunc getGenerateFunc() {
            return this.func;
        }

        public static Generator getGenerator(ElasticSearch.MatchQuery.AnalyzerType type) throws StorageException {
            for (Generator value : Generator.values()) {
                if (value.type != type) continue;
                return value;
            }
            throw new StorageException("cannot found the AnalyzerSettingGenerator for the " + type.getName() + " type");
        }
    }
}

