% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/mllib_regression.R
\name{spark.survreg}
\alias{spark.survreg}
\alias{spark.survreg,SparkDataFrame,formula-method}
\alias{summary,AFTSurvivalRegressionModel-method}
\alias{predict,AFTSurvivalRegressionModel-method}
\alias{write.ml,AFTSurvivalRegressionModel,character-method}
\title{Accelerated Failure Time (AFT) Survival Regression Model}
\usage{
spark.survreg(data, formula, ...)

\S4method{spark.survreg}{SparkDataFrame,formula}(
  data,
  formula,
  aggregationDepth = 2,
  stringIndexerOrderType = c("frequencyDesc", "frequencyAsc", "alphabetDesc",
    "alphabetAsc")
)

\S4method{summary}{AFTSurvivalRegressionModel}(object)

\S4method{predict}{AFTSurvivalRegressionModel}(object, newData)

\S4method{write.ml}{AFTSurvivalRegressionModel,character}(object, path, overwrite = FALSE)
}
\arguments{
\item{data}{a SparkDataFrame for training.}

\item{formula}{a symbolic description of the model to be fitted. Currently only a few formula
operators are supported, including '~', ':', '+', and '-'.
Note that operator '.' is not supported currently.}

\item{...}{additional arguments passed to the method.}

\item{aggregationDepth}{The depth for treeAggregate (greater than or equal to 2). If the
dimensions of features or the number of partitions are large, this
param could be adjusted to a larger size. This is an expert parameter.
Default value should be good for most cases.}

\item{stringIndexerOrderType}{how to order categories of a string feature column. This is used to
decide the base level of a string feature as the last category
after ordering is dropped when encoding strings. Supported options
are "frequencyDesc", "frequencyAsc", "alphabetDesc", and
"alphabetAsc". The default value is "frequencyDesc". When the
ordering is set to "alphabetDesc", this drops the same category
as R when encoding strings.}

\item{object}{a fitted AFT survival regression model.}

\item{newData}{a SparkDataFrame for testing.}

\item{path}{the directory where the model is saved.}

\item{overwrite}{overwrites or not if the output path already exists. Default is FALSE
which means throw exception if the output path exists.}
}
\value{
\code{spark.survreg} returns a fitted AFT survival regression model.

\code{summary} returns summary information of the fitted model, which is a list.
        The list includes the model's \code{coefficients} (features, coefficients,
        intercept and log(scale)).

\code{predict} returns a SparkDataFrame containing predicted values
        on the original scale of the data (mean predicted value at scale = 1.0).
}
\description{
\code{spark.survreg} fits an accelerated failure time (AFT) survival regression model on
a SparkDataFrame. Users can call \code{summary} to get a summary of the fitted AFT model,
\code{predict} to make predictions on new data, and \code{write.ml}/\code{read.ml} to
save/load fitted models.
}
\note{
spark.survreg since 2.0.0

summary(AFTSurvivalRegressionModel) since 2.0.0

predict(AFTSurvivalRegressionModel) since 2.0.0

write.ml(AFTSurvivalRegressionModel, character) since 2.0.0
}
\examples{
\dontrun{
df <- createDataFrame(ovarian)
model <- spark.survreg(df, Surv(futime, fustat) ~ ecog_ps + rx)

# get a summary of the model
summary(model)

# make predictions
predicted <- predict(model, df)
showDF(predicted)

# save and load the model
path <- "path/to/model"
write.ml(model, path)
savedModel <- read.ml(path)
summary(savedModel)
}
}
\seealso{
survival: \url{https://cran.r-project.org/package=survival}

\link{write.ml}
}
