/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.pipelines.graph;

import java.io.Serializable;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.pipelines.graph.DataflowGraph;
import org.apache.spark.sql.pipelines.graph.Flow;
import org.apache.spark.sql.pipelines.graph.FlowFunction;
import org.apache.spark.sql.pipelines.graph.GraphRegistrationContext$SinkType$;
import org.apache.spark.sql.pipelines.graph.GraphRegistrationContext$TableType$;
import org.apache.spark.sql.pipelines.graph.GraphRegistrationContext$ViewType$;
import org.apache.spark.sql.pipelines.graph.PersistedView;
import org.apache.spark.sql.pipelines.graph.QueryContext;
import org.apache.spark.sql.pipelines.graph.QueryOrigin;
import org.apache.spark.sql.pipelines.graph.Sink;
import org.apache.spark.sql.pipelines.graph.Table;
import org.apache.spark.sql.pipelines.graph.UnresolvedFlow;
import org.apache.spark.sql.pipelines.graph.View;
import scala.Function1;
import scala.MatchError;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ListBuffer;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005mf\u0001\u0002\u0016,\u0001aB\u0001b\u0010\u0001\u0003\u0006\u0004%\t\u0001\u0011\u0005\t\u0019\u0002\u0011\t\u0011)A\u0005\u0003\"AQ\n\u0001BC\u0002\u0013\u0005\u0001\t\u0003\u0005O\u0001\t\u0005\t\u0015!\u0003B\u0011!y\u0005A!b\u0001\n\u0003\u0001\u0006\u0002\u0003+\u0001\u0005\u0003\u0005\u000b\u0011B)\t\u000bU\u0003A\u0011\u0001,\t\u000fq\u0003!\u0019!C\t;\"1\u0011\u000e\u0001Q\u0001\nyCqA\u001b\u0001C\u0002\u0013E1\u000e\u0003\u0004q\u0001\u0001\u0006I\u0001\u001c\u0005\bc\u0002\u0011\r\u0011\"\u0005s\u0011\u00199\b\u0001)A\u0005g\"9\u0001\u0010\u0001b\u0001\n#I\bB\u0002@\u0001A\u0003%!\u0010\u0003\u0004\u0000\u0001\u0011\u0005\u0011\u0011\u0001\u0005\b\u0003\u001b\u0001A\u0011AA\b\u0011\u001d\t)\u0002\u0001C\u0001\u0003/Aq!!\b\u0001\t\u0003\ty\u0002C\u0004\u00024\u0001!\t!!\u000e\t\u000f\u0005e\u0002\u0001\"\u0001\u0002<!9\u0011\u0011\t\u0001\u0005\u0002\u0005\r\u0003bBA&\u0001\u0011%\u0011Q\n\u0005\b\u0003G\u0002A\u0011BA3\u0011\u001d\ti\b\u0001C\u0005\u0003\u007f:q!a\",\u0011\u0003\tII\u0002\u0004+W!\u0005\u00111\u0012\u0005\u0007+n!\t!!$\u0007\u0013\u0005=5\u0004%A\u0012\"\u0005EuaBA[7!%\u00111\u0016\u0004\b\u0003K[\u0002\u0012BAT\u0011\u0019)v\u0004\"\u0001\u0002*\"9\u0011\u0011U\u0010\u0005B\u0005\rvaBA\\7!%\u00111\u0017\u0004\b\u0003[[\u0002\u0012BAX\u0011\u0019)6\u0005\"\u0001\u00022\"9\u0011\u0011U\u0012\u0005B\u0005\rvaBA]7!%\u0011q\u0014\u0004\b\u0003+[\u0002\u0012BAL\u0011\u0019)v\u0005\"\u0001\u0002\u001e\"9\u0011\u0011U\u0014\u0005B\u0005\r&\u0001G$sCBD'+Z4jgR\u0014\u0018\r^5p]\u000e{g\u000e^3yi*\u0011A&L\u0001\u0006OJ\f\u0007\u000f\u001b\u0006\u0003]=\n\u0011\u0002]5qK2Lg.Z:\u000b\u0005A\n\u0014aA:rY*\u0011!gM\u0001\u0006gB\f'o\u001b\u0006\u0003iU\na!\u00199bG\",'\"\u0001\u001c\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001I\u0004C\u0001\u001e>\u001b\u0005Y$\"\u0001\u001f\u0002\u000bM\u001c\u0017\r\\1\n\u0005yZ$AB!osJ+g-\u0001\beK\u001a\fW\u000f\u001c;DCR\fGn\\4\u0016\u0003\u0005\u0003\"AQ%\u000f\u0005\r;\u0005C\u0001#<\u001b\u0005)%B\u0001$8\u0003\u0019a$o\\8u}%\u0011\u0001jO\u0001\u0007!J,G-\u001a4\n\u0005)[%AB*ue&twM\u0003\u0002Iw\u0005yA-\u001a4bk2$8)\u0019;bY><\u0007%A\beK\u001a\fW\u000f\u001c;ECR\f'-Y:f\u0003A!WMZ1vYR$\u0015\r^1cCN,\u0007%\u0001\beK\u001a\fW\u000f\u001c;Tc2\u001cuN\u001c4\u0016\u0003E\u0003BA\u0011*B\u0003&\u00111k\u0013\u0002\u0004\u001b\u0006\u0004\u0018a\u00043fM\u0006,H\u000e^*rY\u000e{gN\u001a\u0011\u0002\rqJg.\u001b;?)\u00119\u0016LW.\u0011\u0005a\u0003Q\"A\u0016\t\u000b}:\u0001\u0019A!\t\u000b5;\u0001\u0019A!\t\u000b=;\u0001\u0019A)\u0002\rQ\f'\r\\3t+\u0005q\u0006cA0eM6\t\u0001M\u0003\u0002bE\u00069Q.\u001e;bE2,'BA2<\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003K\u0002\u0014!\u0002T5ti\n+hMZ3s!\tAv-\u0003\u0002iW\t)A+\u00192mK\u00069A/\u00192mKN\u0004\u0013!\u0002<jK^\u001cX#\u00017\u0011\u0007}#W\u000e\u0005\u0002Y]&\u0011qn\u000b\u0002\u0005-&,w/\u0001\u0004wS\u0016<8\u000fI\u0001\u0006g&t7n]\u000b\u0002gB\u0019q\f\u001a;\u0011\u0005a+\u0018B\u0001<,\u0005\u0011\u0019\u0016N\\6\u0002\rMLgn[:!\u0003\u00151Gn\\<t+\u0005Q\bcA0ewB\u0011\u0001\f`\u0005\u0003{.\u0012a\"\u00168sKN|GN^3e\r2|w/\u0001\u0004gY><8\u000fI\u0001\u000ee\u0016<\u0017n\u001d;feR\u000b'\r\\3\u0015\t\u0005\r\u0011\u0011\u0002\t\u0004u\u0005\u0015\u0011bAA\u0004w\t!QK\\5u\u0011\u0019\tY\u0001\u0005a\u0001M\u0006AA/\u00192mK\u0012+g-\u0001\u0007sK\u001eL7\u000f^3s-&,w\u000f\u0006\u0003\u0002\u0004\u0005E\u0001BBA\n#\u0001\u0007Q.A\u0004wS\u0016<H)\u001a4\u0002\u0019I,w-[:uKJ\u001c\u0016N\\6\u0015\t\u0005\r\u0011\u0011\u0004\u0005\u0007\u00037\u0011\u0002\u0019\u0001;\u0002\u000fMLgn\u001b#fM\u0006Aq-\u001a;WS\u0016<8\u000f\u0006\u0002\u0002\"A)\u00111EA\u0017[:!\u0011QEA\u0015\u001d\r!\u0015qE\u0005\u0002y%\u0019\u00111F\u001e\u0002\u000fA\f7m[1hK&!\u0011qFA\u0019\u0005\r\u0019V-\u001d\u0006\u0004\u0003WY\u0014\u0001C4fiNKgn[:\u0016\u0005\u0005]\u0002#BA\u0012\u0003[!\u0018\u0001\u0004:fO&\u001cH/\u001a:GY><H\u0003BA\u0002\u0003{Aa!a\u0010\u0016\u0001\u0004Y\u0018a\u00024m_^$UMZ\u0001\u0010i>$\u0015\r^1gY><xI]1qQV\u0011\u0011Q\t\t\u00041\u0006\u001d\u0013bAA%W\tiA)\u0019;bM2|wo\u0012:ba\"\f!#Y:tKJ$hj\u001c#va2L7-\u0019;fgRQ\u00111AA(\u0003+\nI&!\u0018\t\u000f\u0005Es\u00031\u0001\u0002T\u0005y\u0011/^1mS\u001aLW\r\u001a+bE2,7\u000fE\u0003\u0002$\u00055b\rC\u0004\u0002X]\u0001\r!!\t\u0002\u001dY\fG.\u001b3bi\u0016$g+[3xg\"9\u00111L\fA\u0002\u0005]\u0012A\u0004<bY&$\u0017\r^3e'&t7n\u001d\u0005\b\u0003?:\u0002\u0019AA1\u00039\tX/\u00197jM&,GM\u00127poN\u0004R!a\t\u0002.m\fa$Y:tKJ$x*\u001e;qkRLE-\u001a8uS\u001aLWM]%t+:L\u0017/^3\u0015\u0015\u0005\r\u0011qMA<\u0003s\nY\bC\u0004\u0002ja\u0001\r!a\u001b\u0002\u0015%$WM\u001c;jM&,'\u000f\u0005\u0003\u0002n\u0005MTBAA8\u0015\r\t\thL\u0001\tG\u0006$\u0018\r\\=ti&!\u0011QOA8\u0005=!\u0016M\u00197f\u0013\u0012,g\u000e^5gS\u0016\u0014\bB\u0002/\u0019\u0001\u0004\t\u0019\u0006\u0003\u0004r1\u0001\u0007\u0011q\u0007\u0005\u0007Ub\u0001\r!!\t\u00029\u0005\u001c8/\u001a:u\r2|w/\u00133f]RLg-[3s\u0013N,f.[9vKR1\u00111AAA\u0003\u000bCa!a!\u001a\u0001\u0004Y\u0018\u0001\u00024m_^Da\u0001_\rA\u0002\u0005\u0005\u0014\u0001G$sCBD'+Z4jgR\u0014\u0018\r^5p]\u000e{g\u000e^3yiB\u0011\u0001lG\n\u00037e\"\"!!#\u0003\u0015=+H\u000f];u)f\u0004Xm\u0005\u0002\u001es%\"QdJ\u0010$\u0005!\u0019\u0016N\\6UsB,7\u0003B\u0014:\u00033\u00032!a'\u001e\u001b\u0005YBCAAP!\r\tYjJ\u0001\ti>\u001cFO]5oOR\t\u0011IA\u0005UC\ndW\rV=qKN!q$OAM)\t\tY\u000bE\u0002\u0002\u001c~\u0011\u0001BV5foRK\b/Z\n\u0005Ge\nI\n\u0006\u0002\u00024B\u0019\u00111T\u0012\u0002\u0013Q\u000b'\r\\3UsB,\u0017\u0001\u0003,jK^$\u0016\u0010]3\u0002\u0011MKgn\u001b+za\u0016\u0004")
public class GraphRegistrationContext {
    private final String defaultCatalog;
    private final String defaultDatabase;
    private final Map<String, String> defaultSqlConf;
    private final ListBuffer<Table> tables;
    private final ListBuffer<View> views;
    private final ListBuffer<Sink> sinks;
    private final ListBuffer<UnresolvedFlow> flows;

    public String defaultCatalog() {
        return this.defaultCatalog;
    }

    public String defaultDatabase() {
        return this.defaultDatabase;
    }

    public Map<String, String> defaultSqlConf() {
        return this.defaultSqlConf;
    }

    public ListBuffer<Table> tables() {
        return this.tables;
    }

    public ListBuffer<View> views() {
        return this.views;
    }

    public ListBuffer<Sink> sinks() {
        return this.sinks;
    }

    public ListBuffer<UnresolvedFlow> flows() {
        return this.flows;
    }

    public void registerTable(Table tableDef) {
        this.tables().$plus$eq((Object)tableDef);
    }

    public void registerView(View viewDef) {
        this.views().$plus$eq((Object)viewDef);
    }

    public void registerSink(Sink sinkDef) {
        this.sinks().$plus$eq((Object)sinkDef);
    }

    public Seq<View> getViews() {
        return this.views().toSeq();
    }

    public Seq<Sink> getSinks() {
        return this.sinks().toSeq();
    }

    public void registerFlow(UnresolvedFlow flowDef) {
        Map x$1 = (Map)this.defaultSqlConf().$plus$plus(flowDef.sqlConf());
        TableIdentifier x$2 = flowDef.copy$default$1();
        TableIdentifier x$3 = flowDef.copy$default$2();
        FlowFunction x$4 = flowDef.copy$default$3();
        QueryContext x$5 = flowDef.copy$default$4();
        boolean x$6 = flowDef.copy$default$6();
        QueryOrigin x$7 = flowDef.copy$default$7();
        this.flows().$plus$eq((Object)flowDef.copy(x$2, x$3, x$4, x$5, (Map<String, String>)x$1, x$6, x$7));
    }

    public DataflowGraph toDataflowGraph() {
        if (this.tables().isEmpty() && ((ListBuffer)this.views().collect((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends View, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof PersistedView) {
                    PersistedView persistedView = (PersistedView)A1;
                    return (B1)persistedView;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(View x1) {
                View view = x1;
                return view instanceof PersistedView;
            }
        })).isEmpty() && this.sinks().isEmpty()) {
            throw new AnalysisException("RUN_EMPTY_PIPELINE", Predef$.MODULE$.Map().empty());
        }
        Seq x$1 = this.tables().toSeq();
        Seq x$2 = this.views().toSeq();
        Seq x$3 = this.flows().toSeq();
        Seq x$4 = this.sinks().toSeq();
        this.assertNoDuplicates((Seq<Table>)x$1, (Seq<View>)x$2, (Seq<Sink>)x$4, (Seq<UnresolvedFlow>)x$3);
        Seq x$5 = this.tables().toSeq();
        Seq x$6 = this.views().toSeq();
        Seq x$7 = this.sinks().toSeq();
        Seq x$8 = this.flows().toSeq();
        return new DataflowGraph((Seq<Flow>)x$8, (Seq<Table>)x$5, (Seq<Sink>)x$7, (Seq<View>)x$6);
    }

    private void assertNoDuplicates(Seq<Table> qualifiedTables, Seq<View> validatedViews, Seq<Sink> validatedSinks, Seq<UnresolvedFlow> qualifiedFlows) {
        ((IterableOnceOps)((IterableOps)qualifiedTables.map((Function1 & Serializable)x$1 -> x$1.identifier())).$plus$plus((IterableOnce)validatedViews.map((Function1 & Serializable)x$2 -> x$2.identifier()))).foreach((Function1 & Serializable)identifier -> {
            this.assertOutputIdentifierIsUnique(identifier, (Seq<Table>)qualifiedTables, (Seq<Sink>)validatedSinks, (Seq<View>)validatedViews);
            return BoxedUnit.UNIT;
        });
        qualifiedFlows.foreach((Function1 & Serializable)flow -> {
            this.assertFlowIdentifierIsUnique(flow, (Seq<UnresolvedFlow>)qualifiedFlows);
            return BoxedUnit.UNIT;
        });
    }

    private void assertOutputIdentifierIsUnique(TableIdentifier identifier, Seq<Table> tables, Seq<Sink> sinks, Seq<View> views) {
        Seq allOutputs = (Seq)((IterableOps)((IterableOps)tables.map((Function1 & Serializable)t -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)t.identifier()), (Object)GraphRegistrationContext$TableType$.MODULE$))).$plus$plus((IterableOnce)views.map((Function1 & Serializable)v -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)v.identifier()), (Object)GraphRegistrationContext$ViewType$.MODULE$)))).$plus$plus((IterableOnce)sinks.map((Function1 & Serializable)s -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)s.identifier()), (Object)GraphRegistrationContext$SinkType$.MODULE$)));
        Map grouped = allOutputs.groupBy((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                TableIdentifier id = (TableIdentifier)tuple2._1();
                return id;
            }
            throw new MatchError((Object)tuple2);
        });
        List list = ((IterableOnceOps)grouped.apply((Object)identifier)).toList();
        if (list instanceof .colon.colon) {
            .colon.colon colon2 = (.colon.colon)list;
            Tuple2 tuple2 = (Tuple2)colon2.head();
            List list2 = colon2.next$access$1();
            if (tuple2 != null) {
                .colon.colon colon3;
                Tuple2 tuple22;
                OutputType firstType = (OutputType)tuple2._2();
                if (list2 instanceof .colon.colon && (tuple22 = (Tuple2)(colon3 = (.colon.colon)list2).head()) != null) {
                    OutputType secondType = (OutputType)tuple22._2();
                    Seq sortedTypes = (Seq)new .colon.colon((Object)firstType.toString(), (List)new .colon.colon((Object)secondType.toString(), (List)Nil$.MODULE$)).sorted((Ordering)Ordering.String$.MODULE$);
                    throw new AnalysisException("PIPELINE_DUPLICATE_IDENTIFIERS.OUTPUT", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"outputName"), (Object)identifier.quotedString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"outputType1"), sortedTypes.head()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"outputType2"), sortedTypes.last())})));
                }
            }
        }
    }

    private void assertFlowIdentifierIsUnique(UnresolvedFlow flow, Seq<UnresolvedFlow> flows) {
        flows.groupBy((Function1 & Serializable)i -> i.identifier()).get((Object)flow.identifier()).filter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)GraphRegistrationContext.$anonfun$assertFlowIdentifierIsUnique$2(x$3))).foreach((Function1 & Serializable)duplicateFlows -> {
            UnresolvedFlow duplicateFlow = (UnresolvedFlow)((IterableOps)duplicateFlows.filter((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)GraphRegistrationContext.$anonfun$assertFlowIdentifierIsUnique$4(flow, x$4)))).head();
            throw new AnalysisException("PIPELINE_DUPLICATE_IDENTIFIERS.FLOW", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"flowName"), (Object)flow.identifier().unquotedString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"datasetNames"), (Object)((IterableOnceOps)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{flow.destinationIdentifier().quotedString(), duplicateFlow.destinationIdentifier().quotedString()}))).mkString(","))})));
        });
    }

    public static final /* synthetic */ boolean $anonfun$assertFlowIdentifierIsUnique$2(Seq x$3) {
        return x$3.size() > 1;
    }

    public static final /* synthetic */ boolean $anonfun$assertFlowIdentifierIsUnique$4(UnresolvedFlow flow$1, UnresolvedFlow x$4) {
        UnresolvedFlow unresolvedFlow = x$4;
        UnresolvedFlow unresolvedFlow2 = flow$1;
        return unresolvedFlow == null ? unresolvedFlow2 != null : !((Object)unresolvedFlow).equals(unresolvedFlow2);
    }

    public GraphRegistrationContext(String defaultCatalog, String defaultDatabase, Map<String, String> defaultSqlConf) {
        this.defaultCatalog = defaultCatalog;
        this.defaultDatabase = defaultDatabase;
        this.defaultSqlConf = defaultSqlConf;
        this.tables = new ListBuffer();
        this.views = new ListBuffer();
        this.sinks = new ListBuffer();
        this.flows = new ListBuffer();
    }

    public static interface OutputType {
    }
}

