/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.io.InputFormatChecker;
import org.apache.hadoop.hive.ql.io.RCFile;
import org.apache.hadoop.hive.ql.io.RCFileRecordReader;
import org.apache.hadoop.hive.serde2.columnar.BytesRefArrayWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;

public class RCFileInputFormat<K extends LongWritable, V extends BytesRefArrayWritable>
extends FileInputFormat<K, V>
implements InputFormatChecker {
    public RCFileInputFormat() {
        this.setMinSplitSize(2000L);
    }

    public RecordReader<K, V> getRecordReader(InputSplit split, JobConf job, Reporter reporter) throws IOException {
        reporter.setStatus(split.toString());
        return new RCFileRecordReader((Configuration)job, (FileSplit)split);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean validateInput(FileSystem fs, HiveConf conf, List<FileStatus> files) throws IOException {
        if (files.size() <= 0) {
            return false;
        }
        for (int fileId = 0; fileId < files.size(); ++fileId) {
            RCFile.Reader reader = null;
            try {
                reader = new RCFile.Reader(fs, files.get(fileId).getPath(), (Configuration)conf);
                reader.close();
                reader = null;
                continue;
            }
            catch (IOException e) {
                boolean bl = false;
                return bl;
            }
            finally {
                if (null != reader) {
                    reader.close();
                }
            }
        }
        return true;
    }
}

