/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.util.Map;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.StringTranslate$;
import org.apache.spark.sql.catalyst.expressions.TernaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.CollationSupport;
import org.apache.spark.sql.internal.types.StringTypeNonCSAICollation$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function3;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(input, from, to) - Translates the `input` string by replacing the characters present in the `from` string with the corresponding characters in the `to` string.", examples="\n    Examples:\n      > SELECT _FUNC_('AaBbCc', 'abc', '123');\n       A1B2C3\n  ", since="1.5.0", group="string_funcs")
@ScalaSignature(bytes="\u0006\u0005\tEu!B\u00181\u0011\u0003id!B 1\u0011\u0003\u0001\u0005\"B(\u0002\t\u0003\u0001\u0006\"B)\u0002\t\u0003\u0011\u0006\"B)\u0002\t\u0013A\bbB?\u0002\u0003\u0003%\tI \u0005\n\u0005g\n\u0011\u0011!CA\u0005kB\u0011Ba\"\u0002\u0003\u0003%IA!#\u0007\u000b}\u0002\u0004)!\u0001\t\u0015\u0005\u0015\u0002B!f\u0001\n\u0003\t9\u0003\u0003\u0006\u00020!\u0011\t\u0012)A\u0005\u0003SA!\"!\r\t\u0005+\u0007I\u0011AA\u0014\u0011)\t\u0019\u0004\u0003B\tB\u0003%\u0011\u0011\u0006\u0005\u000b\u0003kA!Q3A\u0005\u0002\u0005\u001d\u0002BCA\u001c\u0011\tE\t\u0015!\u0003\u0002*!1q\n\u0003C\u0001\u0003sAq!!\u0011\t\t\u0003\n\u0019\u0005C\u0006\u0002L!\u0001\r\u00111A\u0005\n\u00055\u0003bCA(\u0011\u0001\u0007\t\u0019!C\u0005\u0003#B!\"!\u0018\t\u0001\u0004\u0005\t\u0015)\u0003g\u0011-\t9\u0007\u0003a\u0001\u0002\u0004%I!!\u0014\t\u0017\u0005%\u0004\u00021AA\u0002\u0013%\u00111\u000e\u0005\u000b\u0003_B\u0001\u0019!A!B\u00131\u0007bCA:\u0011\u0001\u0007\t\u0019!C\u0005\u0003kB1\"a\u001e\t\u0001\u0004\u0005\r\u0011\"\u0003\u0002z!Q\u0011Q\u0010\u0005A\u0002\u0003\u0005\u000b\u0015B*\t\u0013ED\u0001R1A\u0005\u0006\u0005\u0005\u0005bBAE\u0011\u0011\u0005\u00131\u0012\u0005\b\u0003?CA\u0011IAQ\u0011\u001d\ti\f\u0003C!\u0003\u007fCq!a3\t\t\u0003\ni\rC\u0004\u0002\\\"!\t%a\n\t\u000f\u0005u\u0007\u0002\"\u0011\u0002(!9\u0011q\u001c\u0005\u0005B\u0005\u001d\u0002bBAq\u0011\u0011\u0005\u00131\u001d\u0005\b\u0003KDA\u0011KAt\u0011%\t)\u0010CA\u0001\n\u0003\t9\u0010C\u0005\u0002\u0000\"\t\n\u0011\"\u0001\u0003\u0002!I!q\u0003\u0005\u0012\u0002\u0013\u0005!\u0011\u0001\u0005\n\u00053A\u0011\u0013!C\u0001\u0005\u0003A\u0011Ba\u0007\t\u0003\u0003%\tE!\b\t\u0013\t\r\u0002\"!A\u0005\u0002\u0005\u0005\u0005\"\u0003B\u0013\u0011\u0005\u0005I\u0011\u0001B\u0014\u0011%\u0011Y\u0003CA\u0001\n\u0003\u0012i\u0003C\u0005\u0003<!\t\t\u0011\"\u0001\u0003>!I!\u0011\t\u0005\u0002\u0002\u0013\u0005#1\t\u0005\n\u0005\u000fB\u0011\u0011!C!\u0005\u0013\nqb\u0015;sS:<GK]1og2\fG/\u001a\u0006\u0003cI\n1\"\u001a=qe\u0016\u001c8/[8og*\u00111\u0007N\u0001\tG\u0006$\u0018\r\\=ti*\u0011QGN\u0001\u0004gFd'BA\u001c9\u0003\u0015\u0019\b/\u0019:l\u0015\tI$(\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002w\u0005\u0019qN]4\u0004\u0001A\u0011a(A\u0007\u0002a\ty1\u000b\u001e:j]\u001e$&/\u00198tY\u0006$XmE\u0002\u0002\u0003\u001e\u0003\"AQ#\u000e\u0003\rS\u0011\u0001R\u0001\u0006g\u000e\fG.Y\u0005\u0003\r\u000e\u0013a!\u00118z%\u00164\u0007C\u0001%N\u001b\u0005I%B\u0001&L\u0003\tIwNC\u0001M\u0003\u0011Q\u0017M^1\n\u00059K%\u0001D*fe&\fG.\u001b>bE2,\u0017A\u0002\u001fj]&$h\bF\u0001>\u0003%\u0011W/\u001b7e\t&\u001cG\u000f\u0006\u0003TI:\u0004\b\u0003\u0002+X3fk\u0011!\u0016\u0006\u0003-.\u000bA!\u001e;jY&\u0011\u0001,\u0016\u0002\u0004\u001b\u0006\u0004\bC\u0001.b\u001d\tYv\f\u0005\u0002]\u00076\tQL\u0003\u0002_y\u00051AH]8pizJ!\u0001Y\"\u0002\rA\u0013X\rZ3g\u0013\t\u00117M\u0001\u0004TiJLgn\u001a\u0006\u0003A\u000eCQ!Z\u0002A\u0002\u0019\fa\"\\1uG\"LgnZ*ue&tw\r\u0005\u0002hY6\t\u0001N\u0003\u0002jU\u0006)A/\u001f9fg*\u00111NN\u0001\u0007k:\u001c\u0018MZ3\n\u00055D'AC+U\rb\u001aFO]5oO\")qn\u0001a\u0001M\u0006i!/\u001a9mC\u000e,7\u000b\u001e:j]\u001eDQ!]\u0002A\u0002I\f1bY8mY\u0006$\u0018n\u001c8JIB\u00111O^\u0007\u0002i*\u0011QoS\u0001\u0005Y\u0006tw-\u0003\u0002xi\n9\u0011J\u001c;fO\u0016\u0014HcA*zw\")!\u0010\u0002a\u00013\u0006AQ.\u0019;dQ&tw\rC\u0003}\t\u0001\u0007\u0011,A\u0004sKBd\u0017mY3\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000f}\u0014iGa\u001c\u0003rA\u0011a\bC\n\n\u0011\u0005\r\u0011\u0011BA\b\u0003+\u00012APA\u0003\u0013\r\t9\u0001\r\u0002\u0012)\u0016\u0014h.\u0019:z\u000bb\u0004(/Z:tS>t\u0007c\u0001 \u0002\f%\u0019\u0011Q\u0002\u0019\u0003-%k\u0007\u000f\\5dSR\u001c\u0015m\u001d;J]B,H\u000fV=qKN\u00042AQA\t\u0013\r\t\u0019b\u0011\u0002\b!J|G-^2u!\u0011\t9\"!\t\u000f\t\u0005e\u0011Q\u0004\b\u00049\u0006m\u0011\"\u0001#\n\u0007\u0005}1)A\u0004qC\u000e\\\u0017mZ3\n\u00079\u000b\u0019CC\u0002\u0002 \r\u000bqa\u001d:d\u000bb\u0004(/\u0006\u0002\u0002*A\u0019a(a\u000b\n\u0007\u00055\u0002G\u0001\u0006FqB\u0014Xm]:j_:\f\u0001b\u001d:d\u000bb\u0004(\u000fI\u0001\r[\u0006$8\r[5oO\u0016C\bO]\u0001\u000e[\u0006$8\r[5oO\u0016C\bO\u001d\u0011\u0002\u0017I,\u0007\u000f\\1dK\u0016C\bO]\u0001\re\u0016\u0004H.Y2f\u000bb\u0004(\u000f\t\u000b\b\u007f\u0006m\u0012QHA \u0011\u001d\t)c\u0004a\u0001\u0003SAq!!\r\u0010\u0001\u0004\tI\u0003C\u0004\u00026=\u0001\r!!\u000b\u0002\u001d9,H\u000e\\%oi>dWM]1oiV\u0011\u0011Q\t\t\u0004\u0005\u0006\u001d\u0013bAA%\u0007\n9!i\\8mK\u0006t\u0017\u0001\u00047bgRl\u0015\r^2iS:<W#\u00014\u0002!1\f7\u000f^'bi\u000eD\u0017N\\4`I\u0015\fH\u0003BA*\u00033\u00022AQA+\u0013\r\t9f\u0011\u0002\u0005+:LG\u000f\u0003\u0005\u0002\\I\t\t\u00111\u0001g\u0003\rAH%M\u0001\u000eY\u0006\u001cH/T1uG\"Lgn\u001a\u0011)\u0007M\t\t\u0007E\u0002C\u0003GJ1!!\u001aD\u0005%!(/\u00198tS\u0016tG/A\u0006mCN$(+\u001a9mC\u000e,\u0017a\u00047bgR\u0014V\r\u001d7bG\u0016|F%Z9\u0015\t\u0005M\u0013Q\u000e\u0005\t\u00037*\u0012\u0011!a\u0001M\u0006aA.Y:u%\u0016\u0004H.Y2fA!\u001aa#!\u0019\u0002\t\u0011L7\r^\u000b\u0002'\u0006AA-[2u?\u0012*\u0017\u000f\u0006\u0003\u0002T\u0005m\u0004\u0002CA.1\u0005\u0005\t\u0019A*\u0002\u000b\u0011L7\r\u001e\u0011)\u0007e\t\t'\u0006\u0002\u0002\u0004B\u0019!)!\"\n\u0007\u0005\u001d5IA\u0002J]R\fAB\\;mYN\u000bg-Z#wC2$\u0002\"!$\u0002\u0014\u0006]\u00151\u0014\t\u0004\u0005\u0006=\u0015bAAI\u0007\n\u0019\u0011I\\=\t\u000f\u0005U5\u00041\u0001\u0002\u000e\u000691O]2Fm\u0006d\u0007bBAM7\u0001\u0007\u0011QR\u0001\r[\u0006$8\r[5oO\u00163\u0018\r\u001c\u0005\b\u0003;[\u0002\u0019AAG\u0003-\u0011X\r\u001d7bG\u0016,e/\u00197\u0002\u0013\u0011|w)\u001a8D_\u0012,GCBAR\u0003_\u000bI\f\u0005\u0003\u0002&\u0006-VBAAT\u0015\r\tI\u000bM\u0001\bG>$WmZ3o\u0013\u0011\ti+a*\u0003\u0011\u0015C\bO]\"pI\u0016Dq!!-\u001d\u0001\u0004\t\u0019,A\u0002dib\u0004B!!*\u00026&!\u0011qWAT\u00059\u0019u\u000eZ3hK:\u001cuN\u001c;fqRDq!a/\u001d\u0001\u0004\t\u0019+\u0001\u0002fm\u0006AA-\u0019;b)f\u0004X-\u0006\u0002\u0002BB!\u00111YAd\u001b\t\t)M\u0003\u0002ji%!\u0011\u0011ZAc\u0005!!\u0015\r^1UsB,\u0017AC5oaV$H+\u001f9fgV\u0011\u0011q\u001a\t\u0007\u0003/\t\t.!6\n\t\u0005M\u00171\u0005\u0002\u0004'\u0016\f\b\u0003BAb\u0003/LA!!7\u0002F\n\u0001\u0012IY:ue\u0006\u001cG\u000fR1uCRK\b/Z\u0001\u0006M&\u00148\u000f^\u0001\u0007g\u0016\u001cwN\u001c3\u0002\u000bQD\u0017N\u001d3\u0002\u0015A\u0014X\r\u001e;z\u001d\u0006lW-F\u0001Z\u0003]9\u0018\u000e\u001e5OK^\u001c\u0005.\u001b7ee\u0016t\u0017J\u001c;fe:\fG\u000eF\u0004\u0000\u0003S\fi/!=\t\u000f\u0005-8\u00051\u0001\u0002*\u0005Aa.Z<GSJ\u001cH\u000fC\u0004\u0002p\u000e\u0002\r!!\u000b\u0002\u00139,woU3d_:$\u0007bBAzG\u0001\u0007\u0011\u0011F\u0001\t]\u0016<H\u000b[5sI\u0006!1m\u001c9z)\u001dy\u0018\u0011`A~\u0003{D\u0011\"!\n%!\u0003\u0005\r!!\u000b\t\u0013\u0005EB\u0005%AA\u0002\u0005%\u0002\"CA\u001bIA\u0005\t\u0019AA\u0015\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"Aa\u0001+\t\u0005%\"QA\u0016\u0003\u0005\u000f\u0001BA!\u0003\u0003\u00145\u0011!1\u0002\u0006\u0005\u0005\u001b\u0011y!A\u0005v]\u000eDWmY6fI*\u0019!\u0011C\"\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003\u0016\t-!!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012\u0014AD2paf$C-\u001a4bk2$HeM\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\t}\u0001cA:\u0003\"%\u0011!\r^\u0001\raJ|G-^2u\u0003JLG/_\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\tiI!\u000b\t\u0013\u0005m#&!AA\u0002\u0005\r\u0015a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\t=\u0002C\u0002B\u0019\u0005o\ti)\u0004\u0002\u00034)\u0019!QG\"\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0003:\tM\"\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!!\u0012\u0003@!I\u00111\f\u0017\u0002\u0002\u0003\u0007\u0011QR\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\r\u0006\u0003\u0003 \t\u0015\u0003\"CA.[\u0005\u0005\t\u0019AAB\u0003\u0019)\u0017/^1mgR!\u0011Q\tB&\u0011%\tYFLA\u0001\u0002\u0004\ti\tK\n\t\u0005\u001f\u0012)Fa\u0016\u0003\\\tu#\u0011\rB2\u0005O\u0012I\u0007E\u0002?\u0005#J1Aa\u00151\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#A!\u0017\u0002\u0003\u001bzf)\u0016(D?\"Jg\u000e];uY\u00012'o\\7-AQ|\u0017\u0006I\u0017!)J\fgn\u001d7bi\u0016\u001c\b\u0005\u001e5fA\u0001Lg\u000e];uA\u0002\u001aHO]5oO\u0002\u0012\u0017\u0010\t:fa2\f7-\u001b8hAQDW\rI2iCJ\f7\r^3sg\u0002\u0002(/Z:f]R\u0004\u0013N\u001c\u0011uQ\u0016\u0004\u0003M\u001a:p[\u0002\u00043\u000f\u001e:j]\u001e\u0004s/\u001b;iAQDW\rI2peJ,7\u000f]8oI&tw\rI2iCJ\f7\r^3sg\u0002Jg\u000e\t;iK\u0002\u0002Go\u001c1!gR\u0014\u0018N\\4/\u0003!)\u00070Y7qY\u0016\u001c\u0018E\u0001B0\u00039S\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006fJ!b\u0005\n\u001c5m\n\u0017!O\u0005\u00147m\n\u0017!OE\u00124gJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0005\u000b$IM\"4\u0015\u0001\u0002\u0013!B:j]\u000e,\u0017E\u0001B3\u0003\u0015\td&\u000e\u00181\u0003\u00159'o\\;qC\t\u0011Y'\u0001\u0007tiJLgnZ0gk:\u001c7\u000fC\u0004\u0002&\u0015\u0001\r!!\u000b\t\u000f\u0005ER\u00011\u0001\u0002*!9\u0011QG\u0003A\u0002\u0005%\u0012aB;oCB\u0004H.\u001f\u000b\u0005\u0005o\u0012\u0019\tE\u0003C\u0005s\u0012i(C\u0002\u0003|\r\u0013aa\u00149uS>t\u0007#\u0003\"\u0003\u0000\u0005%\u0012\u0011FA\u0015\u0013\r\u0011\ti\u0011\u0002\u0007)V\u0004H.Z\u001a\t\u0011\t\u0015e!!AA\u0002}\f1\u0001\u001f\u00131\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\u0011Y\tE\u0002t\u0005\u001bK1Aa$u\u0005\u0019y%M[3di\u0002")
public class StringTranslate
extends TernaryExpression
implements ImplicitCastInputTypes,
Serializable {
    private int collationId;
    private final Expression srcExpr;
    private final Expression matchingExpr;
    private final Expression replaceExpr;
    private transient UTF8String lastMatching;
    private transient UTF8String lastReplace;
    private transient Map<String, String> dict;
    private volatile boolean bitmap$0;

    public static Option<Tuple3<Expression, Expression, Expression>> unapply(StringTranslate x$0) {
        return StringTranslate$.MODULE$.unapply(x$0);
    }

    public static Map<String, String> buildDict(UTF8String matchingString, UTF8String replaceString, Integer collationId) {
        return StringTranslate$.MODULE$.buildDict(matchingString, replaceString, collationId);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Expression srcExpr() {
        return this.srcExpr;
    }

    public Expression matchingExpr() {
        return this.matchingExpr;
    }

    public Expression replaceExpr() {
        return this.replaceExpr;
    }

    @Override
    public boolean nullIntolerant() {
        return true;
    }

    private UTF8String lastMatching() {
        return this.lastMatching;
    }

    private void lastMatching_$eq(UTF8String x$1) {
        this.lastMatching = x$1;
    }

    private UTF8String lastReplace() {
        return this.lastReplace;
    }

    private void lastReplace_$eq(UTF8String x$1) {
        this.lastReplace = x$1;
    }

    private Map<String, String> dict() {
        return this.dict;
    }

    private void dict_$eq(Map<String, String> x$1) {
        this.dict = x$1;
    }

    private int collationId$lzycompute() {
        StringTranslate stringTranslate = this;
        synchronized (stringTranslate) {
            if (!this.bitmap$0) {
                this.collationId = ((StringType)this.first().dataType()).collationId();
                this.bitmap$0 = true;
            }
        }
        return this.collationId;
    }

    public final int collationId() {
        if (!this.bitmap$0) {
            return this.collationId$lzycompute();
        }
        return this.collationId;
    }

    @Override
    public Object nullSafeEval(Object srcEval, Object matchingEval, Object replaceEval) {
        block1: {
            block0: {
                Object object = matchingEval;
                UTF8String uTF8String = this.lastMatching();
                if (object != null ? !object.equals(uTF8String) : uTF8String != null) break block0;
                Object object2 = replaceEval;
                UTF8String uTF8String2 = this.lastReplace();
                if (!(object2 == null ? uTF8String2 != null : !object2.equals(uTF8String2))) break block1;
            }
            this.lastMatching_$eq(((UTF8String)matchingEval).clone());
            this.lastReplace_$eq(((UTF8String)replaceEval).clone());
            this.dict_$eq(StringTranslate$.MODULE$.buildDict(this.lastMatching(), this.lastReplace(), Predef$.MODULE$.int2Integer(this.collationId())));
        }
        return CollationSupport.StringTranslate.exec((UTF8String)((UTF8String)srcEval), this.dict(), (int)this.collationId());
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String classNameDict = Map.class.getCanonicalName();
        String termLastMatching = ctx.addMutableState("UTF8String", "lastMatching", ctx.addMutableState$default$3(), ctx.addMutableState$default$4(), ctx.addMutableState$default$5());
        String termLastReplace = ctx.addMutableState("UTF8String", "lastReplace", ctx.addMutableState$default$3(), ctx.addMutableState$default$4(), ctx.addMutableState$default$5());
        String termDict = ctx.addMutableState(classNameDict, "dict", ctx.addMutableState$default$3(), ctx.addMutableState$default$4(), ctx.addMutableState$default$5());
        return this.nullSafeCodeGen(ctx, ev, (Function3<String, String, String, String>)(Function3 & Serializable)(src, matching, replace) -> {
            String check = this.matchingExpr().foldable() && this.replaceExpr().foldable() ? termDict + " == null" : "!" + matching + ".equals(" + termLastMatching + ") || !" + replace + ".equals(" + termLastReplace + ")";
            return "if (" + check + ") {\n        // Not all of them is literal or matching or replace value changed\n        " + termLastMatching + " = " + matching + ".clone();\n        " + termLastReplace + " = " + replace + ".clone();\n        " + termDict + " = org.apache.spark.sql.catalyst.expressions.StringTranslate\n          .buildDict(" + termLastMatching + ", " + termLastReplace + ", " + this.collationId() + ");\n      }\n      " + ev.value() + " = CollationSupport.StringTranslate.exec(" + src + ", " + termDict + ", " + this.collationId() + ");\n      ";
        });
    }

    @Override
    public DataType dataType() {
        return this.srcExpr().dataType();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)StringTypeNonCSAICollation$.MODULE$.apply(true), (List)new .colon.colon((Object)StringTypeNonCSAICollation$.MODULE$.apply(true), (List)new .colon.colon((Object)StringTypeNonCSAICollation$.MODULE$.apply(true), (List)Nil$.MODULE$)));
    }

    @Override
    public Expression first() {
        return this.srcExpr();
    }

    @Override
    public Expression second() {
        return this.matchingExpr();
    }

    @Override
    public Expression third() {
        return this.replaceExpr();
    }

    @Override
    public String prettyName() {
        return "translate";
    }

    @Override
    public StringTranslate withNewChildrenInternal(Expression newFirst, Expression newSecond, Expression newThird) {
        return this.copy(newFirst, newSecond, newThird);
    }

    public StringTranslate copy(Expression srcExpr, Expression matchingExpr, Expression replaceExpr) {
        return new StringTranslate(srcExpr, matchingExpr, replaceExpr);
    }

    public Expression copy$default$1() {
        return this.srcExpr();
    }

    public Expression copy$default$2() {
        return this.matchingExpr();
    }

    public Expression copy$default$3() {
        return this.replaceExpr();
    }

    @Override
    public String productPrefix() {
        return "StringTranslate";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.srcExpr();
            }
            case 1: {
                return this.matchingExpr();
            }
            case 2: {
                return this.replaceExpr();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof StringTranslate;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "srcExpr";
            }
            case 1: {
                return "matchingExpr";
            }
            case 2: {
                return "replaceExpr";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof StringTranslate)) return false;
        boolean bl = true;
        if (!bl) return false;
        StringTranslate stringTranslate = (StringTranslate)x$1;
        Expression expression = this.srcExpr();
        Expression expression2 = stringTranslate.srcExpr();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.matchingExpr();
        Expression expression4 = stringTranslate.matchingExpr();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.replaceExpr();
        Expression expression6 = stringTranslate.replaceExpr();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!stringTranslate.canEqual(this)) return false;
        return true;
    }

    public StringTranslate(Expression srcExpr, Expression matchingExpr, Expression replaceExpr) {
        this.srcExpr = srcExpr;
        this.matchingExpr = matchingExpr;
        this.replaceExpr = replaceExpr;
        ExpectsInputTypes.$init$(this);
    }
}

