/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.CharArrayWriter;
import java.io.Serializable;
import java.time.ZoneId;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.csv.CSVOptions;
import org.apache.spark.sql.catalyst.csv.UnivocityGenerator;
import org.apache.spark.sql.catalyst.expressions.DefaultStringProducingExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.ExprUtils$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.StructsToCsv$;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.TypeUtils$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.UserDefinedType;
import org.apache.spark.sql.types.VariantType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Enumeration;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(expr[, options]) - Returns a CSV string with a given struct value", examples="\n    Examples:\n      > SELECT _FUNC_(named_struct('a', 1, 'b', 2));\n       1,2\n      > SELECT _FUNC_(named_struct('time', to_timestamp('2015-08-26', 'yyyy-MM-dd')), map('timestampFormat', 'dd/MM/yyyy'));\n       26/08/2015\n  ", since="3.0.0", group="csv_funcs")
@ScalaSignature(bytes="\u0006\u0005\t5f\u0001B\u0017/\u0001nB\u0001b\u0017\u0001\u0003\u0016\u0004%\t\u0001\u0018\u0005\tQ\u0002\u0011\t\u0012)A\u0005;\"A\u0011\u000e\u0001BK\u0002\u0013\u0005!\u000e\u0003\u0005o\u0001\tE\t\u0015!\u0003l\u0011!y\u0007A!f\u0001\n\u0003\u0001\b\u0002\u0003;\u0001\u0005#\u0005\u000b\u0011B9\t\u000bU\u0004A\u0011\u0001<\t\u000bm\u0004A\u0011\t?\t\r\u0005\u0005\u0001\u0001\"\u0011}\u0011\u0019)\b\u0001\"\u0001\u0002\u0004!1Q\u000f\u0001C\u0001\u0003\u0013Aa!\u001e\u0001\u0005\u0002\u00055\u0001bBA\n\u0001\u0011\u0005\u0013Q\u0003\u0005\b\u0003G\u0001A\u0011BA\u0013\u0011)\t9\u0004\u0001EC\u0002\u0013\u0005\u0011\u0011\b\u0005\u000b\u0003'\u0002\u0001R1A\u0005\u0002\u0005U\u0003BCA0\u0001!\u0015\r\u0011\"\u0001\u0002b!Q\u0011\u0011\u000f\u0001\t\u0006\u0004%\t!a\u001d\t\u000f\u0005E\u0005\u0001\"\u0011\u0002\u0014\"9\u0011q\u0013\u0001\u0005B\u0005e\u0005bBAP\u0001\u0011\u0005\u0013\u0011\u0015\u0005\b\u0003_\u0003A\u0011IAY\u0011\u001d\t\u0019\f\u0001C)\u0003kCq!a/\u0001\t#\ni\fC\u0005\u0002Z\u0002\t\t\u0011\"\u0001\u0002\\\"I\u00111\u001d\u0001\u0012\u0002\u0013\u0005\u0011Q\u001d\u0005\n\u0003w\u0004\u0011\u0013!C\u0001\u0003{D\u0011B!\u0001\u0001#\u0003%\tAa\u0001\t\u0013\t\u001d\u0001!!A\u0005B\t%\u0001\"\u0003B\u000b\u0001\u0005\u0005I\u0011\u0001B\f\u0011%\u0011y\u0002AA\u0001\n\u0003\u0011\t\u0003C\u0005\u0003(\u0001\t\t\u0011\"\u0011\u0003*!I!q\u0007\u0001\u0002\u0002\u0013\u0005!\u0011\b\u0005\n\u0005{\u0001\u0011\u0011!C!\u0005\u007fA\u0011Ba\u0011\u0001\u0003\u0003%\tE!\u0012\b\u0013\t%d&!A\t\u0002\t-d\u0001C\u0017/\u0003\u0003E\tA!\u001c\t\rU,C\u0011\u0001B@\u0011%\u0011\t)JA\u0001\n\u000b\u0012\u0019\tC\u0005\u0003\u0006\u0016\n\t\u0011\"!\u0003\b\"I!qR\u0013\u0012\u0002\u0013\u0005!1\u0001\u0005\n\u0005#+\u0013\u0011!CA\u0005'C\u0011B!)&#\u0003%\tAa\u0001\t\u0013\t\rV%!A\u0005\n\t\u0015&\u0001D*ueV\u001cGo\u001d+p\u0007N4(BA\u00181\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005E\u0012\u0014\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005M\"\u0014aA:rY*\u0011QGN\u0001\u0006gB\f'o\u001b\u0006\u0003oa\na!\u00199bG\",'\"A\u001d\u0002\u0007=\u0014xm\u0001\u0001\u0014\u000f\u0001a\u0004i\u0011$J\u001fB\u0011QHP\u0007\u0002]%\u0011qH\f\u0002\u0010+:\f'/_#yaJ,7o]5p]B\u0011Q(Q\u0005\u0003\u0005:\u0012q\u0003V5nKj{g.Z!xCJ,W\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u0005u\"\u0015BA#/\u0005\u0001\"UMZ1vYR\u001cFO]5oOB\u0013x\u000eZ;dS:<W\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u0005u:\u0015B\u0001%/\u0005E)\u0005\u0010]3diNLe\u000e];u)f\u0004Xm\u001d\t\u0003\u00156k\u0011a\u0013\u0006\u0002\u0019\u0006)1oY1mC&\u0011aj\u0013\u0002\b!J|G-^2u!\t\u0001\u0006L\u0004\u0002R-:\u0011!+V\u0007\u0002'*\u0011AKO\u0001\u0007yI|w\u000e\u001e \n\u00031K!aV&\u0002\u000fA\f7m[1hK&\u0011\u0011L\u0017\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0006\u0003/.\u000bqa\u001c9uS>t7/F\u0001^!\u0011q&-Z3\u000f\u0005}\u0003\u0007C\u0001*L\u0013\t\t7*\u0001\u0004Qe\u0016$WMZ\u0005\u0003G\u0012\u00141!T1q\u0015\t\t7\n\u0005\u0002_M&\u0011q\r\u001a\u0002\u0007'R\u0014\u0018N\\4\u0002\u0011=\u0004H/[8og\u0002\nQa\u00195jY\u0012,\u0012a\u001b\t\u0003{1L!!\u001c\u0018\u0003\u0015\u0015C\bO]3tg&|g.\u0001\u0004dQ&dG\rI\u0001\u000bi&lWMW8oK&#W#A9\u0011\u0007)\u0013X-\u0003\u0002t\u0017\n1q\n\u001d;j_:\f1\u0002^5nKj{g.Z%eA\u00051A(\u001b8jiz\"Ba\u001e=zuB\u0011Q\b\u0001\u0005\u00067\u001e\u0001\r!\u0018\u0005\u0006S\u001e\u0001\ra\u001b\u0005\b_\u001e\u0001\n\u00111\u0001r\u00039qW\u000f\u001c7J]R|G.\u001a:b]R,\u0012! \t\u0003\u0015zL!a`&\u0003\u000f\t{w\u000e\\3b]\u0006Aa.\u001e7mC\ndW\rF\u0003x\u0003\u000b\t9\u0001C\u0003\\\u0015\u0001\u0007Q\fC\u0003j\u0015\u0001\u00071\u000eF\u0002x\u0003\u0017AQ![\u0006A\u0002-$Ra^A\b\u0003#AQ!\u001b\u0007A\u0002-DQa\u0017\u0007A\u0002-\f1c\u00195fG.Le\u000e];u\t\u0006$\u0018\rV=qKN$\"!a\u0006\u0011\t\u0005e\u0011qD\u0007\u0003\u00037Q1!!\b1\u0003!\tg.\u00197zg&\u001c\u0018\u0002BA\u0011\u00037\u0011q\u0002V=qK\u000eCWmY6SKN,H\u000e^\u0001\u0014SN\u001cV\u000f\u001d9peR,G\rR1uCRK\b/\u001a\u000b\u0004{\u0006\u001d\u0002bBA\u0015\u001d\u0001\u0007\u00111F\u0001\tI\u0006$\u0018\rV=qKB!\u0011QFA\u001a\u001b\t\tyCC\u0002\u00022I\nQ\u0001^=qKNLA!!\u000e\u00020\tAA)\u0019;b)f\u0004X-\u0001\u0004xe&$XM]\u000b\u0003\u0003w\u0001B!!\u0010\u0002H5\u0011\u0011q\b\u0006\u0005\u0003\u0003\n\u0019%\u0001\u0002j_*\u0011\u0011QI\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002J\u0005}\"aD\"iCJ\f%O]1z/JLG/\u001a:)\u0007=\ti\u0005E\u0002K\u0003\u001fJ1!!\u0015L\u0005%!(/\u00198tS\u0016tG/A\u0006j]B,HoU2iK6\fWCAA,!\u0011\ti#!\u0017\n\t\u0005m\u0013q\u0006\u0002\u000b'R\u0014Xo\u0019;UsB,\u0007f\u0001\t\u0002N\u0005\u0019q-\u001a8\u0016\u0005\u0005\r\u0004\u0003BA3\u0003Wj!!a\u001a\u000b\u0007\u0005%\u0004'A\u0002dgZLA!!\u001c\u0002h\t\u0011RK\\5w_\u000eLG/_$f]\u0016\u0014\u0018\r^8sQ\r\t\u0012QJ\u0001\nG>tg/\u001a:uKJ,\"!!\u001e\u0011\u000f)\u000b9(a\u001f\u0002\u0002&\u0019\u0011\u0011P&\u0003\u0013\u0019+hn\u0019;j_:\f\u0004c\u0001&\u0002~%\u0019\u0011qP&\u0003\u0007\u0005s\u0017\u0010\u0005\u0003\u0002\u0004\u0006-UBAAC\u0015\u0011\t\t$a\"\u000b\u0007\u0005%E'\u0001\u0004v]N\fg-Z\u0005\u0005\u0003\u001b\u000b)I\u0001\u0006V)\u001aC4\u000b\u001e:j]\u001eD3AEA'\u000319\u0018\u000e\u001e5US6,'l\u001c8f)\r\u0001\u0015Q\u0013\u0005\u0006_N\u0001\r!Z\u0001\r]VdGnU1gK\u00163\u0018\r\u001c\u000b\u0005\u0003w\nY\nC\u0004\u0002\u001eR\u0001\r!a\u001f\u0002\u000bY\fG.^3\u0002\u0015%t\u0007/\u001e;UsB,7/\u0006\u0002\u0002$B)\u0001+!*\u0002*&\u0019\u0011q\u0015.\u0003\u0007M+\u0017\u000f\u0005\u0003\u0002.\u0005-\u0016\u0002BAW\u0003_\u0011\u0001#\u00112tiJ\f7\r\u001e#bi\u0006$\u0016\u0010]3\u0002\u0015A\u0014X\r\u001e;z\u001d\u0006lW-F\u0001f\u0003Q9\u0018\u000e\u001e5OK^\u001c\u0005.\u001b7e\u0013:$XM\u001d8bYR\u0019q/a.\t\r\u0005ev\u00031\u0001l\u0003!qWm^\"iS2$\u0017!\u00033p\u000f\u0016t7i\u001c3f)\u0019\ty,a3\u0002VB!\u0011\u0011YAd\u001b\t\t\u0019MC\u0002\u0002F:\nqaY8eK\u001e,g.\u0003\u0003\u0002J\u0006\r'\u0001C#yaJ\u001cu\u000eZ3\t\u000f\u00055\u0007\u00041\u0001\u0002P\u0006\u00191\r\u001e=\u0011\t\u0005\u0005\u0017\u0011[\u0005\u0005\u0003'\f\u0019M\u0001\bD_\u0012,w-\u001a8D_:$X\r\u001f;\t\u000f\u0005]\u0007\u00041\u0001\u0002@\u0006\u0011QM^\u0001\u0005G>\u0004\u0018\u0010F\u0004x\u0003;\fy.!9\t\u000fmK\u0002\u0013!a\u0001;\"9\u0011.\u0007I\u0001\u0002\u0004Y\u0007bB8\u001a!\u0003\u0005\r!]\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\t9OK\u0002^\u0003S\\#!a;\u0011\t\u00055\u0018q_\u0007\u0003\u0003_TA!!=\u0002t\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003k\\\u0015AC1o]>$\u0018\r^5p]&!\u0011\u0011`Ax\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\tyPK\u0002l\u0003S\fabY8qs\u0012\"WMZ1vYR$3'\u0006\u0002\u0003\u0006)\u001a\u0011/!;\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\u0011Y\u0001\u0005\u0003\u0003\u000e\tMQB\u0001B\b\u0015\u0011\u0011\t\"a\u0011\u0002\t1\fgnZ\u0005\u0004O\n=\u0011\u0001\u00049s_\u0012,8\r^!sSRLXC\u0001B\r!\rQ%1D\u0005\u0004\u0005;Y%aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BA>\u0005GA\u0011B!\n \u0003\u0003\u0005\rA!\u0007\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\u0011Y\u0003\u0005\u0004\u0003.\tM\u00121P\u0007\u0003\u0005_Q1A!\rL\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0005k\u0011yC\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dGcA?\u0003<!I!QE\u0011\u0002\u0002\u0003\u0007\u00111P\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\r\u0006\u0003\u0003\f\t\u0005\u0003\"\u0003B\u0013E\u0005\u0005\t\u0019\u0001B\r\u0003\u0019)\u0017/^1mgR\u0019QPa\u0012\t\u0013\t\u00152%!AA\u0002\u0005m\u0004f\u0005\u0001\u0003L\tE#1\u000bB,\u00053\u0012iFa\u0018\u0003d\t\u0015\u0004cA\u001f\u0003N%\u0019!q\n\u0018\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012!QK\u0001I?\u001a+fjQ0)Kb\u0004(o\u0017\u0017!_B$\u0018n\u001c8t;&\u0002S\u0006\t*fiV\u0014hn\u001d\u0011bA\r\u001bf\u000bI:ue&tw\rI<ji\"\u0004\u0013\rI4jm\u0016t\u0007e\u001d;sk\u000e$\bE^1mk\u0016\f\u0001\"\u001a=b[BdWm]\u0011\u0003\u00057\n\u0011\u0011\u0019\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)]\u0006lW\rZ0tiJ,8\r\u001e\u0015(C\u001eb\u0003%\r\u0017!O\t<C\u0006\t\u001a*SmR\u0001\u0005\t\u0011!A\u0001\u0002\u0013\u0007\f\u001a\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q9\fW.\u001a3`gR\u0014Xo\u0019;)OQLW.Z\u0014-AQ|w\f^5nKN$\u0018-\u001c9)OI\u0002\u0014'N\u00171q5\u0012dg\n\u0017!OeL\u00180_\u0017N\u001b6\"GmJ\u0015*Y\u0001j\u0017\r\u001d\u0015(i&lWm\u001d;b[B4uN]7bi\u001eb\u0003e\n3e_5ku&_=zs\u001eJ\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00113m=\u0002\u0004h\f\u001a1cUR\u0001\u0005I\u0001\u0006g&t7-Z\u0011\u0003\u0005C\nQa\r\u00181]A\nQa\u001a:pkB\f#Aa\u001a\u0002\u0013\r\u001cho\u00184v]\u000e\u001c\u0018\u0001D*ueV\u001cGo\u001d+p\u0007N4\bCA\u001f&'\u0015)#q\u000eB>!!\u0011\tHa\u001e^WF<XB\u0001B:\u0015\r\u0011)hS\u0001\beVtG/[7f\u0013\u0011\u0011IHa\u001d\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t7\u0007\u0005\u0003\u0002>\tu\u0014bA-\u0002@Q\u0011!1N\u0001\ti>\u001cFO]5oOR\u0011!1B\u0001\u0006CB\u0004H.\u001f\u000b\bo\n%%1\u0012BG\u0011\u0015Y\u0006\u00061\u0001^\u0011\u0015I\u0007\u00061\u0001l\u0011\u001dy\u0007\u0006%AA\u0002E\fq\"\u00199qYf$C-\u001a4bk2$HeM\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0011)J!(\u0011\t)\u0013(q\u0013\t\u0007\u0015\neUl[9\n\u0007\tm5J\u0001\u0004UkBdWm\r\u0005\t\u0005?S\u0013\u0011!a\u0001o\u0006\u0019\u0001\u0010\n\u0019\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00134\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\u00119\u000b\u0005\u0003\u0003\u000e\t%\u0016\u0002\u0002BV\u0005\u001f\u0011aa\u00142kK\u000e$\b")
public class StructsToCsv
extends UnaryExpression
implements TimeZoneAwareExpression,
DefaultStringProducingExpression,
ExpectsInputTypes,
Serializable {
    private transient CharArrayWriter writer;
    private transient StructType inputSchema;
    private transient UnivocityGenerator gen;
    private transient Function1<Object, UTF8String> converter;
    private final Map<String, String> options;
    private final Expression child;
    private final Option<String> timeZoneId;
    private boolean resolved;
    private Seq<Enumeration.Value> nodePatterns;
    private transient ZoneId zoneId;
    private volatile transient byte bitmap$trans$0;
    private volatile boolean bitmap$0;

    public static Option<String> $lessinit$greater$default$3() {
        return StructsToCsv$.MODULE$.$lessinit$greater$default$3();
    }

    public static Option<Tuple3<Map<String, String>, Expression, Option<String>>> unapply(StructsToCsv x$0) {
        return StructsToCsv$.MODULE$.unapply(x$0);
    }

    public static Option<String> apply$default$3() {
        return StructsToCsv$.MODULE$.apply$default$3();
    }

    public static Function1<Tuple3<Map<String, String>, Expression, Option<String>>, StructsToCsv> tupled() {
        return StructsToCsv$.MODULE$.tupled();
    }

    public static Function1<Map<String, String>, Function1<Expression, Function1<Option<String>, StructsToCsv>>> curried() {
        return StructsToCsv$.MODULE$.curried();
    }

    @Override
    public DataType dataType() {
        return DefaultStringProducingExpression.dataType$(this);
    }

    @Override
    public Seq<Enumeration.Value> nodePatternsInternal() {
        return TimeZoneAwareExpression.nodePatternsInternal$(this);
    }

    @Override
    public ZoneId zoneIdForType(DataType dataType) {
        return TimeZoneAwareExpression.zoneIdForType$(this, dataType);
    }

    private boolean resolved$lzycompute() {
        StructsToCsv structsToCsv = this;
        synchronized (structsToCsv) {
            if (!this.bitmap$0) {
                this.resolved = TimeZoneAwareExpression.resolved$(this);
                this.bitmap$0 = true;
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        if (!this.bitmap$0) {
            return this.resolved$lzycompute();
        }
        return this.resolved;
    }

    @Override
    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private ZoneId zoneId$lzycompute() {
        StructsToCsv structsToCsv = this;
        synchronized (structsToCsv) {
            if ((byte)(this.bitmap$trans$0 & 0x10) == 0) {
                this.zoneId = TimeZoneAwareExpression.zoneId$(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 0x10);
            }
        }
        return this.zoneId;
    }

    @Override
    public ZoneId zoneId() {
        if ((byte)(this.bitmap$trans$0 & 0x10) == 0) {
            return this.zoneId$lzycompute();
        }
        return this.zoneId;
    }

    @Override
    public final void org$apache$spark$sql$catalyst$expressions$TimeZoneAwareExpression$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public Map<String, String> options() {
        return this.options;
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public Option<String> timeZoneId() {
        return this.timeZoneId;
    }

    @Override
    public boolean nullIntolerant() {
        return true;
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        StructType structType;
        DataType dataType = this.child().dataType();
        if (dataType instanceof StructType && ((IterableOnceOps)(structType = (StructType)dataType).map((Function1 & Serializable)x$1 -> x$1.dataType())).forall((Function1 & Serializable)dt -> BoxesRunTime.boxToBoolean((boolean)this.isSupportedDataType(dt)))) {
            return TypeCheckResult$TypeCheckSuccess$.MODULE$;
        }
        return new TypeCheckResult.DataTypeMismatch("UNSUPPORTED_INPUT_TYPE", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"functionName"), (Object)TypeUtils$.MODULE$.toSQLId(this.prettyName())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dataType"), (Object)TypeUtils$.MODULE$.toSQLType((AbstractDataType)this.child().dataType()))}))));
    }

    private boolean isSupportedDataType(DataType dataType) {
        while (true) {
            DataType dataType2;
            if ((dataType2 = dataType) instanceof VariantType) {
                return false;
            }
            if (dataType2 instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)dataType2;
                dataType = arrayType.elementType();
                continue;
            }
            if (dataType2 instanceof MapType) {
                MapType mapType = (MapType)dataType2;
                if (this.isSupportedDataType(mapType.keyType())) {
                    dataType = mapType.valueType();
                    continue;
                }
                return false;
            }
            if (dataType2 instanceof StructType) {
                StructType structType = (StructType)dataType2;
                return ((IterableOnceOps)structType.map((Function1 & Serializable)x$2 -> x$2.dataType())).forall((Function1 & Serializable)dt -> BoxesRunTime.boxToBoolean((boolean)this.isSupportedDataType(dt)));
            }
            if (!(dataType2 instanceof UserDefinedType)) break;
            UserDefinedType userDefinedType = (UserDefinedType)dataType2;
            dataType = userDefinedType.sqlType();
        }
        return true;
    }

    private CharArrayWriter writer$lzycompute() {
        StructsToCsv structsToCsv = this;
        synchronized (structsToCsv) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.writer = new CharArrayWriter();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.writer;
    }

    public CharArrayWriter writer() {
        if ((byte)(this.bitmap$trans$0 & 1) == 0) {
            return this.writer$lzycompute();
        }
        return this.writer;
    }

    private StructType inputSchema$lzycompute() {
        StructsToCsv structsToCsv = this;
        synchronized (structsToCsv) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.inputSchema = (StructType)this.child().dataType();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.inputSchema;
    }

    public StructType inputSchema() {
        if ((byte)(this.bitmap$trans$0 & 2) == 0) {
            return this.inputSchema$lzycompute();
        }
        return this.inputSchema;
    }

    private UnivocityGenerator gen$lzycompute() {
        StructsToCsv structsToCsv = this;
        synchronized (structsToCsv) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                this.gen = new UnivocityGenerator(this.inputSchema(), this.writer(), new CSVOptions(this.options(), true, (String)this.timeZoneId().get()));
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
        }
        return this.gen;
    }

    public UnivocityGenerator gen() {
        if ((byte)(this.bitmap$trans$0 & 4) == 0) {
            return this.gen$lzycompute();
        }
        return this.gen;
    }

    private Function1<Object, UTF8String> converter$lzycompute() {
        StructsToCsv structsToCsv = this;
        synchronized (structsToCsv) {
            if ((byte)(this.bitmap$trans$0 & 8) == 0) {
                this.converter = (Function1 & Serializable)row -> UTF8String.fromString((String)this.gen().writeToString((InternalRow)row));
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 8);
            }
        }
        return this.converter;
    }

    public Function1<Object, UTF8String> converter() {
        if ((byte)(this.bitmap$trans$0 & 8) == 0) {
            return this.converter$lzycompute();
        }
        return this.converter;
    }

    @Override
    public TimeZoneAwareExpression withTimeZone(String timeZoneId) {
        Option x$1 = Option$.MODULE$.apply((Object)timeZoneId);
        Map<String, String> x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        return this.copy(x$2, x$3, (Option<String>)x$1);
    }

    @Override
    public Object nullSafeEval(Object value) {
        return this.converter().apply(value);
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        StructType$ structType$ = StructType$.MODULE$;
        return Nil$.MODULE$.$colon$colon((Object)structType$);
    }

    @Override
    public String prettyName() {
        return "to_csv";
    }

    @Override
    public StructsToCsv withNewChildInternal(Expression newChild) {
        Expression x$1 = newChild;
        Map<String, String> x$2 = this.copy$default$1();
        Option<String> x$3 = this.copy$default$3();
        return this.copy(x$2, x$1, x$3);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String structsToCsv = ctx.addReferenceObj("structsToCsv", this, ctx.addReferenceObj$default$3());
        return this.nullSafeCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable)eval -> ev.value() + " = (UTF8String) " + structsToCsv + ".converter().apply(" + eval + ");");
    }

    public StructsToCsv copy(Map<String, String> options, Expression child, Option<String> timeZoneId) {
        return new StructsToCsv(options, child, timeZoneId);
    }

    public Map<String, String> copy$default$1() {
        return this.options();
    }

    public Expression copy$default$2() {
        return this.child();
    }

    public Option<String> copy$default$3() {
        return this.timeZoneId();
    }

    @Override
    public String productPrefix() {
        return "StructsToCsv";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.options();
            }
            case 1: {
                return this.child();
            }
            case 2: {
                return this.timeZoneId();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof StructsToCsv;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "options";
            }
            case 1: {
                return "child";
            }
            case 2: {
                return "timeZoneId";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof StructsToCsv)) return false;
        boolean bl = true;
        if (!bl) return false;
        StructsToCsv structsToCsv = (StructsToCsv)x$1;
        Map<String, String> map = this.options();
        Map<String, String> map2 = structsToCsv.options();
        if (map == null) {
            if (map2 != null) {
                return false;
            }
        } else if (!map.equals(map2)) return false;
        Expression expression = this.child();
        Expression expression2 = structsToCsv.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Option<String> option = this.timeZoneId();
        Option<String> option2 = structsToCsv.timeZoneId();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!structsToCsv.canEqual(this)) return false;
        return true;
    }

    public StructsToCsv(Map<String, String> options, Expression child, Option<String> timeZoneId) {
        this.options = options;
        this.child = child;
        this.timeZoneId = timeZoneId;
        TimeZoneAwareExpression.$init$(this);
        DefaultStringProducingExpression.$init$(this);
        ExpectsInputTypes.$init$(this);
        Statics.releaseFence();
    }

    public StructsToCsv(Map<String, String> options, Expression child) {
        this(options, child, (Option<String>)None$.MODULE$);
    }

    public StructsToCsv(Expression child) {
        this((Map<String, String>)Predef$.MODULE$.Map().empty(), child, (Option<String>)None$.MODULE$);
    }

    public StructsToCsv(Expression child, Expression options) {
        this(ExprUtils$.MODULE$.convertToMapData(options), child, (Option<String>)None$.MODULE$);
    }
}

