/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect.client;

import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Stream;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.spark.SparkException;
import org.apache.spark.connect.proto.AddArtifactsRequest;
import org.apache.spark.connect.proto.AddArtifactsResponse;
import org.apache.spark.connect.proto.ArtifactStatusesRequest;
import org.apache.spark.connect.proto.ArtifactStatusesResponse;
import org.apache.spark.sql.Artifact;
import org.apache.spark.sql.Artifact$;
import org.apache.spark.sql.connect.client.ClassFinder;
import org.apache.spark.sql.connect.client.CustomSparkConnectBlockingStub;
import org.apache.spark.sql.connect.client.CustomSparkConnectStub;
import org.apache.spark.sql.connect.client.SparkConnectClient;
import org.apache.spark.sql.connect.client.SparkConnectStubState;
import org.apache.spark.util.SparkFileUtils$;
import org.apache.spark.util.SparkStringUtils$;
import org.apache.spark.util.SparkThreadUtils$;
import org.sparkproject.connect.grpc.StatusRuntimeException;
import org.sparkproject.connect.grpc.stub.StreamObserver;
import org.sparkproject.connect.protobuf.ByteString;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Builder;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.concurrent.Awaitable;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.java8.JFunction0;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\t\ra\u0001\u0002\u000f\u001e\u0001)B\u0001\"\r\u0001\u0003\u0002\u0003\u0006IA\r\u0005\tu\u0001\u0011\t\u0011)A\u0005w!Aa\t\u0001B\u0001B\u0003%q\t\u0003\u0005K\u0001\t\u0005\t\u0015!\u0003L\u0011\u0015q\u0005\u0001\"\u0001P\u0011\u001d)\u0006A1A\u0005\nYCaA\u0017\u0001!\u0002\u00139\u0006BB.\u0001A\u0003%A\f\u0003\u0004j\u0001\u0001\u0006IA\u001b\u0005\u0006[\u0002!\tA\u001c\u0005\u0006i\u0002!\t!\u001e\u0005\u0006q\u0002!I!\u001f\u0005\u0007i\u0002!\t!a\b\t\rQ\u0004A\u0011AA\u0012\u0011\u0019!\b\u0001\"\u0001\u0002:!9\u0011\u0011\t\u0001\u0005\u0002\u0005\r\u0003\u0002CA&\u0001\u0011\u0005Q$!\u0014\t\u0011\u0005e\u0003\u0001\"\u0001\u001e\u00037Bq!!\u001b\u0001\t\u0003\tY\u0007C\u0004\u0002r\u0001!\t!a\u001d\t\u0011\u0005m\u0004\u0001\"\u0001\u001e\u0003{B\u0001\"a \u0001\t\u0003\t\u0013\u0011\u0011\u0005\t\u0003\u0003\u0002A\u0011A\u000f\u0002\u0018\"A\u00111\u0015\u0001\u0005\u0002u\t)\u000bC\u0004\u0002*\u0002!I!a+\t\u000f\u0005M\u0007\u0001\"\u0003\u0002V\"9\u0011\u0011 \u0001\u0005\n\u0005m(aD!si&4\u0017m\u0019;NC:\fw-\u001a:\u000b\u0005yy\u0012AB2mS\u0016tGO\u0003\u0002!C\u000591m\u001c8oK\u000e$(B\u0001\u0012$\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003I\u0015\nQa\u001d9be.T!AJ\u0014\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005A\u0013aA8sO\u000e\u00011C\u0001\u0001,!\tas&D\u0001.\u0015\u0005q\u0013!B:dC2\f\u0017B\u0001\u0019.\u0005\u0019\te.\u001f*fM\u0006a1\r\\5f]R\u001cuN\u001c4jOB\u00111g\u000e\b\u0003iUj\u0011!H\u0005\u0003mu\t!c\u00159be.\u001cuN\u001c8fGR\u001cE.[3oi&\u0011\u0001(\u000f\u0002\u000e\u0007>tg-[4ve\u0006$\u0018n\u001c8\u000b\u0005Yj\u0012!C:fgNLwN\\%e!\ta4I\u0004\u0002>\u0003B\u0011a(L\u0007\u0002\u007f)\u0011\u0001)K\u0001\u0007yI|w\u000e\u001e \n\u0005\tk\u0013A\u0002)sK\u0012,g-\u0003\u0002E\u000b\n11\u000b\u001e:j]\u001eT!AQ\u0017\u0002\u000b\t\u001cH/\u001e2\u0011\u0005QB\u0015BA%\u001e\u0005y\u0019Uo\u001d;p[N\u0003\u0018M]6D_:tWm\u0019;CY>\u001c7.\u001b8h'R,(-\u0001\u0003tiV\u0014\u0007C\u0001\u001bM\u0013\tiUD\u0001\fDkN$x.\\*qCJ\\7i\u001c8oK\u000e$8\u000b^;c\u0003\u0019a\u0014N\\5u}Q)\u0001+\u0015*T)B\u0011A\u0007\u0001\u0005\u0006c\u0015\u0001\rA\r\u0005\u0006u\u0015\u0001\ra\u000f\u0005\u0006\r\u0016\u0001\ra\u0012\u0005\u0006\u0015\u0016\u0001\raS\u0001\u000b\u0007\"+fjS0T\u0013j+U#A,\u0011\u00051B\u0016BA-.\u0005\rIe\u000e^\u0001\f\u0007\"+fjS0T\u0013j+\u0005%\u0001\u0007dY\u0006\u001c8OR5oI\u0016\u00148\u000fE\u0002^I\u001al\u0011A\u0018\u0006\u0003?\u0002\f!bY8oGV\u0014(/\u001a8u\u0015\t\t'-\u0001\u0003vi&d'\"A2\u0002\t)\fg/Y\u0005\u0003Kz\u0013AcQ8qs>swK]5uK\u0006\u0013(/Y=MSN$\bC\u0001\u001bh\u0013\tAWDA\u0006DY\u0006\u001c8OR5oI\u0016\u0014\u0018!C:uk\n\u001cF/\u0019;f!\t!4.\u0003\u0002m;\t)2\u000b]1sW\u000e{gN\\3diN#XOY*uCR,\u0017a\u0005:fO&\u001cH/\u001a:DY\u0006\u001c8OR5oI\u0016\u0014HCA8s!\ta\u0003/\u0003\u0002r[\t!QK\\5u\u0011\u0015\u0019(\u00021\u0001g\u0003\u00191\u0017N\u001c3fe\u0006Y\u0011\r\u001a3BeRLg-Y2u)\tyg\u000fC\u0003x\u0017\u0001\u00071(\u0001\u0003qCRD\u0017A\u00049beN,\u0017I\u001d;jM\u0006\u001cGo\u001d\u000b\u0004u\u0006=\u0001#B>\u0002\u0002\u0005\u001daB\u0001?\u007f\u001d\tqT0C\u0001/\u0013\tyX&A\u0004qC\u000e\\\u0017mZ3\n\t\u0005\r\u0011Q\u0001\u0002\u0004'\u0016\f(BA@.!\u0011\tI!a\u0003\u000e\u0003\u0005J1!!\u0004\"\u0005!\t%\u000f^5gC\u000e$\bbBA\t\u0019\u0001\u0007\u00111C\u0001\u0004kJL\u0007\u0003BA\u000b\u00037i!!a\u0006\u000b\u0007\u0005e!-A\u0002oKRLA!!\b\u0002\u0018\t\u0019QKU%\u0015\u0007=\f\t\u0003C\u0004\u0002\u00125\u0001\r!a\u0005\u0015\u000b=\f)#!\u000e\t\u000f\u0005\u001db\u00021\u0001\u0002*\u0005)!-\u001f;fgB)A&a\u000b\u00020%\u0019\u0011QF\u0017\u0003\u000b\u0005\u0013(/Y=\u0011\u00071\n\t$C\u0002\u000245\u0012AAQ=uK\"1\u0011q\u0007\bA\u0002m\na\u0001^1sO\u0016$H#B8\u0002<\u0005}\u0002BBA\u001f\u001f\u0001\u00071(\u0001\u0004t_V\u00148-\u001a\u0005\u0007\u0003oy\u0001\u0019A\u001e\u0002\u0019\u0005$G-\u0011:uS\u001a\f7\r^:\u0015\u0007=\f)\u0005C\u0004\u0002HA\u0001\r!!\u0013\u0002\tU\u0014\u0018n\u001d\t\u0006w\u0006\u0005\u00111C\u0001\u0011SN\u001c\u0015m\u00195fI\u0006\u0013H/\u001b4bGR$B!a\u0014\u0002VA\u0019A&!\u0015\n\u0007\u0005MSFA\u0004C_>dW-\u00198\t\r\u0005]\u0013\u00031\u0001<\u0003\u0011A\u0017m\u001d5\u0002%\u001d,GoQ1dQ\u0016$\u0017I\u001d;jM\u0006\u001cGo\u001d\u000b\u0005\u0003;\n\u0019\u0007\u0005\u0003=\u0003?Z\u0014bAA1\u000b\n\u00191+\u001a;\t\u000f\u0005\u0015$\u00031\u0001\u0002h\u00051\u0001.Y:iKN\u0004Ba_A\u0001w\u0005i1-Y2iK\u0006\u0013H/\u001b4bGR$2aOA7\u0011\u001d\tyg\u0005a\u0001\u0003S\tAA\u00197pE\u0006q1-Y2iK\u0006\u0013H/\u001b4bGR\u001cH\u0003BA4\u0003kBq!a\u001e\u0015\u0001\u0004\tI(A\u0003cY>\u00147\u000fE\u0003-\u0003W\tI#A\u000eva2|\u0017\rZ!mY\u000ec\u0017m]:GS2,\u0017I\u001d;jM\u0006\u001cGo\u001d\u000b\u0002_\u0006Y\u0011\r\u001a3DY\u0006\u001c8\u000fR5s)\ry\u00171\u0011\u0005\b\u0003\u000b3\u0002\u0019AAD\u0003\u0011\u0011\u0017m]3\u0011\t\u0005%\u00151S\u0007\u0003\u0003\u0017SA!!$\u0002\u0010\u0006!a-\u001b7f\u0015\r\t\tJY\u0001\u0004]&|\u0017\u0002BAK\u0003\u0017\u0013A\u0001U1uQR\u0019q.!'\t\u000f\u0005mu\u00031\u0001\u0002\u001e\u0006I\u0011M\u001d;jM\u0006\u001cGo\u001d\t\u0006w\u0006}\u0015qA\u0005\u0005\u0003C\u000b)A\u0001\u0005Ji\u0016\u0014\u0018M\u00197f\u0003A\tG\rZ!si&4\u0017m\u0019;t\u00136\u0004H\u000eF\u0002p\u0003OCq!a'\u0019\u0001\u0004\ti*A\nbI\u0012\u0014\u0015\r^2iK\u0012\f%\u000f^5gC\u000e$8\u000fF\u0003p\u0003[\u000by\u000b\u0003\u0004\u0002\u001cf\u0001\rA\u001f\u0005\b\u0003cK\u0002\u0019AAZ\u0003\u0019\u0019HO]3b[B1\u0011QWAa\u0003\u000bl!!a.\u000b\u0007)\u000bIL\u0003\u0003\u0002<\u0006u\u0016\u0001B4sa\u000eT!!a0\u0002\u0005%|\u0017\u0002BAb\u0003o\u0013ab\u0015;sK\u0006lwJY:feZ,'\u000f\u0005\u0003\u0002H\u0006=WBAAe\u0015\u0011\tY-!4\u0002\u000bA\u0014x\u000e^8\u000b\u0005\u0001\u001a\u0013\u0002BAi\u0003\u0013\u00141#\u00113e\u0003J$\u0018NZ1diN\u0014V-];fgR\fQB]3bI:+\u0007\u0010^\"ik:\\G\u0003BAl\u0003W\u0004B!!7\u0002h6\u0011\u00111\u001c\u0006\u0005\u0003;\fy.\u0001\u0005qe>$xNY;g\u0015\u0011\t\t/a9\u0002\r\u001d|wn\u001a7f\u0015\t\t)/A\u0002d_6LA!!;\u0002\\\nQ!)\u001f;f'R\u0014\u0018N\\4\t\u000f\u00055(\u00041\u0001\u0002p\u0006\u0011\u0011N\u001c\t\u0005\u0003c\f)0\u0004\u0002\u0002t*\u0019\u0011q\u00182\n\t\u0005]\u00181\u001f\u0002\f\u0013:\u0004X\u000f^*ue\u0016\fW.\u0001\nbI\u0012\u001c\u0005.\u001e8lK\u0012\f%\u000f^5gC\u000e$H#B8\u0002~\n\u0005\u0001bBA\u00007\u0001\u0007\u0011qA\u0001\tCJ$\u0018NZ1di\"9\u0011\u0011W\u000eA\u0002\u0005M\u0006")
public class ArtifactManager {
    private final SparkConnectClient.Configuration clientConfig;
    public final String org$apache$spark$sql$connect$client$ArtifactManager$$sessionId;
    private final CustomSparkConnectBlockingStub bstub;
    private final CustomSparkConnectStub stub;
    private final int CHUNK_SIZE;
    private final CopyOnWriteArrayList<ClassFinder> classFinders;
    private final SparkConnectStubState stubState;

    private int CHUNK_SIZE() {
        return this.CHUNK_SIZE;
    }

    public void registerClassFinder(ClassFinder finder) {
        this.classFinders.add(finder);
    }

    public void addArtifact(String path) {
        this.addArtifact(SparkFileUtils$.MODULE$.resolveURI(path));
    }

    private scala.collection.immutable.Seq<Artifact> parseArtifacts(URI uri) {
        String string = uri.getScheme();
        switch (string == null ? 0 : string.hashCode()) {
            case 104684: {
                if (!"ivy".equals(string)) break;
                return Artifact$.MODULE$.newIvyArtifacts(uri);
            }
            case 3143036: {
                if (!"file".equals(string)) break;
                Path path = Paths.get(uri);
                Artifact artifact = Artifact$.MODULE$.newArtifactFromExtension(((Object)path.getFileName()).toString(), path.getFileName(), (Artifact.LocalData)new Artifact.LocalFile(path));
                return new .colon.colon((Object)artifact, (List)Nil$.MODULE$);
            }
        }
        throw new UnsupportedOperationException("Unsupported scheme: " + string);
    }

    public void addArtifact(URI uri) {
        this.addArtifacts((Iterable<Artifact>)this.parseArtifacts(uri));
    }

    public void addArtifact(byte[] bytes, String target) {
        Artifact artifact;
        Path targetPath = Paths.get(target, new String[0]);
        Artifact artifact2 = artifact = Artifact$.MODULE$.newArtifactFromExtension(((Object)targetPath.getFileName()).toString(), targetPath, (Artifact.LocalData)new Artifact.InMemory(bytes));
        this.addArtifacts((Iterable<Artifact>)Nil$.MODULE$.$colon$colon((Object)artifact2));
    }

    public void addArtifact(String source, String target) {
        Artifact artifact;
        Path targetPath = Paths.get(target, new String[0]);
        Artifact artifact2 = artifact = Artifact$.MODULE$.newArtifactFromExtension(((Object)targetPath.getFileName()).toString(), targetPath, (Artifact.LocalData)new Artifact.LocalFile(Paths.get(source, new String[0])));
        this.addArtifacts((Iterable<Artifact>)Nil$.MODULE$.$colon$colon((Object)artifact2));
    }

    public void addArtifacts(scala.collection.immutable.Seq<URI> uris) {
        this.addArtifacts((Iterable<Artifact>)((Iterable)uris.flatMap((Function1 & Serializable)uri -> this.parseArtifacts((URI)uri))));
    }

    public boolean isCachedArtifact(String hash) {
        Map<String, ArtifactStatusesResponse.ArtifactStatus> statuses;
        String artifactName = Artifact$.MODULE$.CACHE_PREFIX() + "/" + hash;
        ArtifactStatusesRequest request = ArtifactStatusesRequest.newBuilder().setUserContext(this.clientConfig.userContext()).setClientType(this.clientConfig.userAgent()).setSessionId(this.org$apache$spark$sql$connect$client$ArtifactManager$$sessionId).addAllNames(Arrays.asList((Object[])new String[]{artifactName})).build();
        ArtifactStatusesResponse response = this.bstub.artifactStatus(request);
        if (SparkStringUtils$.MODULE$.isNotEmpty(response.getSessionId())) {
            String string = response.getSessionId();
            String string2 = this.org$apache$spark$sql$connect$client$ArtifactManager$$sessionId;
            if (string == null ? string2 != null : !string.equals(string2)) {
                throw new IllegalStateException("Session ID mismatch: " + this.org$apache$spark$sql$connect$client$ArtifactManager$$sessionId + " != " + response.getSessionId());
            }
        }
        if ((statuses = response.getStatusesMap()).containsKey(artifactName)) {
            return statuses.get(artifactName).getExists();
        }
        return false;
    }

    public scala.collection.immutable.Set<String> getCachedArtifacts(scala.collection.immutable.Seq<String> hashes) {
        if (hashes.isEmpty()) {
            return Predef$.MODULE$.Set().empty();
        }
        scala.collection.immutable.Seq artifactNames = (scala.collection.immutable.Seq)hashes.map((Function1 & Serializable)hash -> Artifact$.MODULE$.CACHE_PREFIX() + "/" + hash);
        ArtifactStatusesRequest request = ArtifactStatusesRequest.newBuilder().setUserContext(this.clientConfig.userContext()).setClientType(this.clientConfig.userAgent()).setSessionId(this.org$apache$spark$sql$connect$client$ArtifactManager$$sessionId).addAllNames(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)artifactNames).asJava()).build();
        ArtifactStatusesResponse response = this.bstub.artifactStatus(request);
        if (SparkStringUtils$.MODULE$.isNotEmpty(response.getSessionId())) {
            String string = response.getSessionId();
            String string2 = this.org$apache$spark$sql$connect$client$ArtifactManager$$sessionId;
            if (string == null ? string2 != null : !string.equals(string2)) {
                throw new IllegalStateException("Session ID mismatch: " + this.org$apache$spark$sql$connect$client$ArtifactManager$$sessionId + " != " + response.getSessionId());
            }
        }
        Map<String, ArtifactStatusesResponse.ArtifactStatus> statuses = response.getStatusesMap();
        return ((IterableOnceOps)hashes.filter((Function1 & Serializable)hash -> BoxesRunTime.boxToBoolean((boolean)ArtifactManager.$anonfun$getCachedArtifacts$2(statuses, hash)))).toSet();
    }

    public String cacheArtifact(byte[] blob) {
        String hash;
        block0: {
            hash = DigestUtils.sha256Hex((byte[])blob);
            if (this.isCachedArtifact(hash)) break block0;
            Artifact artifact = Artifact$.MODULE$.newCacheArtifact(hash, (Artifact.LocalData)new Artifact.InMemory(blob));
            this.addArtifacts((Iterable<Artifact>)Nil$.MODULE$.$colon$colon((Object)artifact));
        }
        return hash;
    }

    public scala.collection.immutable.Seq<String> cacheArtifacts(byte[][] blobs) {
        scala.collection.immutable.Seq hashes;
        block0: {
            hashes = ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])blobs), (Function1 & Serializable)x$1 -> DigestUtils.sha256Hex((byte[])x$1), ClassTag$.MODULE$.apply(String.class))));
            scala.collection.immutable.Seq uniqueHashes = (scala.collection.immutable.Seq)hashes.distinct();
            scala.collection.immutable.Set<String> cachedHashes = this.getCachedArtifacts((scala.collection.immutable.Seq<String>)uniqueHashes);
            Set seenHashes = (Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
            ListBuffer uniqueBlobsToUpload = (ListBuffer)ListBuffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
            ArrayOps$.MODULE$.withFilter$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zip$extension(Predef$.MODULE$.refArrayOps((Object[])blobs), (IterableOnce)hashes)), (Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)ArtifactManager.$anonfun$cacheArtifacts$2(check$ifrefutable$1))).foreach((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    byte[] blob = (byte[])tuple2._1();
                    String hash = (String)tuple2._2();
                    if (!cachedHashes.contains((Object)hash) && !seenHashes.contains((Object)hash)) {
                        uniqueBlobsToUpload.$plus$eq((Object)Artifact$.MODULE$.newCacheArtifact(hash, (Artifact.LocalData)new Artifact.InMemory(blob)));
                        return BoxesRunTime.boxToBoolean((boolean)seenHashes.add((Object)hash));
                    }
                    return BoxedUnit.UNIT;
                }
                throw new MatchError((Object)tuple2);
            });
            if (!uniqueBlobsToUpload.nonEmpty()) break block0;
            this.addArtifacts((Iterable<Artifact>)uniqueBlobsToUpload.toList());
        }
        return hashes;
    }

    public void uploadAllClassFileArtifacts() {
        this.addArtifacts((Iterable<Artifact>)((Iterable)CollectionConverters$.MODULE$.ListHasAsScala(this.classFinders).asScala().flatMap((Function1 & Serializable)x$2 -> x$2.findClasses())));
    }

    public void addClassDir(Path base) {
        if (!Files.isDirectory(base, new LinkOption[0])) {
            return;
        }
        Builder builder = package$.MODULE$.Seq().newBuilder();
        try (Stream<Path> stream = Files.walk(base, new FileVisitOption[0]);){
            stream.forEach(path -> {
                if (Files.isRegularFile(path, new LinkOption[0]) && ((Object)path).toString().endsWith(".class")) {
                    builder.$plus$eq((Object)Artifact$.MODULE$.newClassArtifact(base.relativize((Path)path), (Artifact.LocalData)new Artifact.LocalFile(path)));
                    return;
                }
            });
        }
        this.addArtifacts((Iterable<Artifact>)((Iterable)builder.result()));
    }

    public void addArtifacts(Iterable<Artifact> artifacts) {
        if (artifacts.isEmpty()) {
            return;
        }
        try {
            this.stubState.retryHandler().retry((JFunction0.mcV.sp & Serializable)() -> this.addArtifactsImpl(artifacts));
        }
        catch (StatusRuntimeException ex) {
            throw new SparkException(ex.toString(), ex.getCause());
        }
    }

    public void addArtifactsImpl(Iterable<Artifact> artifacts) {
        Promise promise = Promise$.MODULE$.apply();
        StreamObserver<AddArtifactsResponse> responseHandler = new StreamObserver<AddArtifactsResponse>(this, promise){
            private final Buffer<AddArtifactsResponse.ArtifactSummary> summaries;
            private final /* synthetic */ ArtifactManager $outer;
            private final Promise promise$1;

            private Buffer<AddArtifactsResponse.ArtifactSummary> summaries() {
                return this.summaries;
            }

            public void onNext(AddArtifactsResponse v) {
                if (SparkStringUtils$.MODULE$.isNotEmpty(v.getSessionId())) {
                    String string = v.getSessionId();
                    String string2 = this.$outer.org$apache$spark$sql$connect$client$ArtifactManager$$sessionId;
                    if (string == null ? string2 != null : !string.equals(string2)) {
                        throw new IllegalStateException("Session ID mismatch: " + this.$outer.org$apache$spark$sql$connect$client$ArtifactManager$$sessionId + " != " + v.getSessionId());
                    }
                }
                v.getArtifactsList().forEach(summary -> this.summaries().$plus$eq(summary));
            }

            public void onError(Throwable throwable) {
                this.promise$1.failure(throwable);
            }

            public void onCompleted() {
                this.promise$1.success((Object)this.summaries().toSeq());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.promise$1 = promise$1;
                this.summaries = (Buffer)Buffer$.MODULE$.empty();
            }
        };
        StreamObserver<AddArtifactsRequest> stream = this.stub.addArtifacts(responseHandler);
        Buffer currentBatch = (Buffer)Buffer$.MODULE$.empty();
        LongRef currentBatchSize = LongRef.create((long)0L);
        artifacts.iterator().foreach((Function1 & Serializable)artifact -> {
            ArtifactManager.$anonfun$addArtifactsImpl$1(this, currentBatch, stream, currentBatchSize, artifact);
            return BoxedUnit.UNIT;
        });
        if (currentBatch.nonEmpty()) {
            this.writeBatch$1(currentBatch, stream, currentBatchSize);
        }
        stream.onCompleted();
        SparkThreadUtils$.MODULE$.awaitResultNoSparkExceptionConversion((Awaitable)promise.future(), (Duration)Duration$.MODULE$.Inf());
    }

    private void addBatchedArtifacts(scala.collection.immutable.Seq<Artifact> artifacts, StreamObserver<AddArtifactsRequest> stream) {
        AddArtifactsRequest.Builder builder = AddArtifactsRequest.newBuilder().setUserContext(this.clientConfig.userContext()).setClientType(this.clientConfig.userAgent()).setSessionId(this.org$apache$spark$sql$connect$client$ArtifactManager$$sessionId);
        artifacts.foreach((Function1 & Serializable)artifact -> {
            AddArtifactsRequest.SingleChunkArtifact singleChunkArtifact;
            try (CheckedInputStream in = new CheckedInputStream(artifact.storage().stream(), new CRC32());){
                try {
                    AddArtifactsRequest.ArtifactChunk.Builder data = AddArtifactsRequest.ArtifactChunk.newBuilder().setData(ByteString.readFrom(in)).setCrc(in.getChecksum().getValue());
                    singleChunkArtifact = builder.getBatchBuilder().addArtifactsBuilder().setName(((Object)artifact.path()).toString()).setData(data).build();
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    Throwable throwable3 = throwable;
                    if (throwable3 != null && NonFatal$.MODULE$.apply(throwable2 = throwable3)) {
                        stream.onError(throwable2);
                        throw throwable2;
                    }
                    throw throwable;
                }
            }
            return singleChunkArtifact;
        });
        stream.onNext(builder.build());
    }

    private ByteString readNextChunk(InputStream in) {
        byte[] buf = new byte[this.CHUNK_SIZE()];
        int bytesRead = 0;
        int count = 0;
        while (count != -1 && bytesRead < this.CHUNK_SIZE()) {
            count = in.read(buf, bytesRead, this.CHUNK_SIZE() - bytesRead);
            if (count == -1) continue;
            bytesRead += count;
        }
        if (bytesRead == 0) {
            return ByteString.empty();
        }
        return ByteString.copyFrom(buf, 0, bytesRead);
    }

    private void addChunkedArtifact(Artifact artifact, StreamObserver<AddArtifactsRequest> stream) {
        AddArtifactsRequest.Builder builder = AddArtifactsRequest.newBuilder().setUserContext(this.clientConfig.userContext()).setClientType(this.clientConfig.userAgent()).setSessionId(this.org$apache$spark$sql$connect$client$ArtifactManager$$sessionId);
        try (CheckedInputStream in = new CheckedInputStream(artifact.storage().stream(), new CRC32());){
            try {
                AddArtifactsRequest.ArtifactChunk.Builder artifactChunkBuilder = AddArtifactsRequest.ArtifactChunk.newBuilder();
                ByteString dataChunk = this.readNextChunk(in);
                builder.getBeginChunkBuilder().setName(((Object)artifact.path()).toString()).setTotalBytes(artifact.size()).setNumChunks(this.getNumChunks$1(artifact.size())).setInitialChunk(artifactChunkBuilder.setData(dataChunk).setCrc(in.getChecksum().getValue()));
                stream.onNext(builder.build());
                in.getChecksum().reset();
                builder.clearBeginChunk();
                dataChunk = this.readNextChunk(in);
                while (!dataChunk.isEmpty()) {
                    artifactChunkBuilder.setData(dataChunk).setCrc(in.getChecksum().getValue());
                    builder.setChunk(artifactChunkBuilder.build());
                    stream.onNext(builder.build());
                    in.getChecksum().reset();
                    builder.clearChunk();
                    dataChunk = this.readNextChunk(in);
                }
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                Throwable throwable3 = throwable;
                if (throwable3 != null && NonFatal$.MODULE$.apply(throwable2 = throwable3)) {
                    stream.onError(throwable2);
                    throw throwable2;
                }
                throw throwable;
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$getCachedArtifacts$2(Map statuses$1, String hash) {
        String artifactName = Artifact$.MODULE$.CACHE_PREFIX() + "/" + hash;
        return statuses$1.containsKey(artifactName) && ((ArtifactStatusesResponse.ArtifactStatus)statuses$1.get(artifactName)).getExists();
    }

    public static final /* synthetic */ boolean $anonfun$cacheArtifacts$2(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        return tuple2 != null;
    }

    private static final void addToBatch$1(Artifact dep, long size, Buffer currentBatch$1, LongRef currentBatchSize$1) {
        currentBatch$1.$plus$eq((Object)dep);
        currentBatchSize$1.elem += size;
    }

    private final void writeBatch$1(Buffer currentBatch$1, StreamObserver stream$1, LongRef currentBatchSize$1) {
        this.addBatchedArtifacts((scala.collection.immutable.Seq<Artifact>)currentBatch$1.toSeq(), stream$1);
        currentBatch$1.clear();
        currentBatchSize$1.elem = 0L;
    }

    public static final /* synthetic */ void $anonfun$addArtifactsImpl$1(ArtifactManager $this, Buffer currentBatch$1, StreamObserver stream$1, LongRef currentBatchSize$1, Artifact artifact) {
        Artifact.LocalData data = artifact.storage();
        long size = data.size();
        if (size > (long)$this.CHUNK_SIZE()) {
            if (currentBatch$1.nonEmpty()) {
                $this.writeBatch$1(currentBatch$1, stream$1, currentBatchSize$1);
            }
            $this.addChunkedArtifact(artifact, stream$1);
            return;
        }
        if (currentBatchSize$1.elem + size > (long)$this.CHUNK_SIZE()) {
            $this.writeBatch$1(currentBatch$1, stream$1, currentBatchSize$1);
        }
        ArtifactManager.addToBatch$1(artifact, size, currentBatch$1, currentBatchSize$1);
    }

    private final long getNumChunks$1(long size) {
        return (size + (long)(this.CHUNK_SIZE() - 1)) / (long)this.CHUNK_SIZE();
    }

    public ArtifactManager(SparkConnectClient.Configuration clientConfig, String sessionId, CustomSparkConnectBlockingStub bstub, CustomSparkConnectStub stub) {
        this.clientConfig = clientConfig;
        this.org$apache$spark$sql$connect$client$ArtifactManager$$sessionId = sessionId;
        this.bstub = bstub;
        this.stub = stub;
        this.CHUNK_SIZE = 32768;
        this.classFinders = new CopyOnWriteArrayList();
        this.stubState = stub.stubState();
    }
}

