/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.aggregate;

import java.io.Serializable;
import org.apache.datasketches.common.ArrayOfItemsSerDe;
import org.apache.datasketches.frequencies.ItemsSketch;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.FunctionRegistry$;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.aggregate.ApproxTopK$;
import org.apache.spark.sql.catalyst.expressions.aggregate.ApproxTopKAggregateBuffer;
import org.apache.spark.sql.catalyst.expressions.aggregate.ApproxTopKAggregateBuffer$;
import org.apache.spark.sql.catalyst.expressions.aggregate.ImperativeAggregate;
import org.apache.spark.sql.catalyst.expressions.aggregate.TypedImperativeAggregate;
import org.apache.spark.sql.catalyst.trees.TernaryLike;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.AnyDataType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Tuple5;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(expr, k, maxItemsTracked) - Returns top k items with their frequency.\n      `k` An optional INTEGER literal greater than 0. If k is not specified, it defaults to 5.\n      `maxItemsTracked` An optional INTEGER literal greater than or equal to k and has upper limit of 1000000. If maxItemsTracked is not specified, it defaults to 10000.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(expr) FROM VALUES (0), (0), (1), (1), (2), (3), (4), (4) AS tab(expr);\n       [{\"item\":0,\"count\":2},{\"item\":4,\"count\":2},{\"item\":1,\"count\":2},{\"item\":2,\"count\":1},{\"item\":3,\"count\":1}]\n\n      > SELECT _FUNC_(expr, 2) FROM VALUES 'a', 'b', 'c', 'c', 'c', 'c', 'd', 'd' AS tab(expr);\n       [{\"item\":\"c\",\"count\":4},{\"item\":\"d\",\"count\":2}]\n\n      > SELECT _FUNC_(expr, 10, 100) FROM VALUES (0), (1), (1), (2), (2), (2) AS tab(expr);\n       [{\"item\":2,\"count\":3},{\"item\":1,\"count\":2},{\"item\":0,\"count\":1}]\n  ", group="agg_funcs", since="4.1.0")
@ScalaSignature(bytes="\u0006\u0005\r\u001df\u0001B)S\u0001\u0006D!\"a\u0006\u0001\u0005+\u0007I\u0011AA\r\u0011%\tY\u0002\u0001B\tB\u0003%\u0011\u0010\u0003\u0006\u0002\u001e\u0001\u0011)\u001a!C\u0001\u00033A\u0011\"a\b\u0001\u0005#\u0005\u000b\u0011B=\t\u0015\u0005\u0005\u0002A!f\u0001\n\u0003\tI\u0002C\u0005\u0002$\u0001\u0011\t\u0012)A\u0005s\"Q\u0011Q\u0005\u0001\u0003\u0016\u0004%\t!a\n\t\u0015\u0005=\u0002A!E!\u0002\u0013\tI\u0003\u0003\u0006\u00022\u0001\u0011)\u001a!C\u0001\u0003OA!\"a\r\u0001\u0005#\u0005\u000b\u0011BA\u0015\u0011\u001d\t)\u0004\u0001C\u0001\u0003oAq!!\u000e\u0001\t\u0003\t)\u0005C\u0004\u00026\u0001!\t!!\u0015\t\u000f\u0005U\u0002\u0001\"\u0001\u0002Z!9\u0011Q\u0007\u0001\u0005\u0002\u0005}\u0003bBA\u001b\u0001\u0011\u0005\u0011Q\r\u0005\u000b\u0003S\u0002\u0001R1A\u0005\n\u0005-\u0004BCA=\u0001!\u0015\r\u0011\"\u0003\u0002(!Q\u00111\u0010\u0001\t\u0006\u0004%I!a\n\t\u000f\u0005u\u0004\u0001\"\u0011\u0002\u001a!9\u0011q\u0010\u0001\u0005B\u0005e\u0001bBAA\u0001\u0011\u0005\u0013\u0011\u0004\u0005\b\u0003\u0007\u0003A\u0011IAC\u0011\u001d\t\u0019\n\u0001C!\u0003+Cq!a)\u0001\t\u0003\nY\u0007C\u0004\u0002&\u0002!\t%a*\t\u000f\u0005%\u0006\u0001\"\u0011\u0002,\"9\u0011Q\u0018\u0001\u0005B\u0005}\u0006bBAc\u0001\u0011\u0005\u0013q\u0019\u0005\b\u0003/\u0004A\u0011IAm\u0011\u001d\tI\u000f\u0001C!\u0003WDq!!=\u0001\t\u0003\n\u0019\u0010C\u0004\u0002\u0000\u0002!\tE!\u0001\t\u000f\t\u001d\u0001\u0001\"\u0015\u0003\n!9!q\u0003\u0001\u0005B\te\u0001b\u0002B\u0011\u0001\u0011\u0005#1\u0005\u0005\n\u0005k\u0001\u0011\u0011!C\u0001\u0005oA\u0011Ba\u0011\u0001#\u0003%\tA!\u0012\t\u0013\tm\u0003!%A\u0005\u0002\t\u0015\u0003\"\u0003B/\u0001E\u0005I\u0011\u0001B#\u0011%\u0011y\u0006AI\u0001\n\u0003\u0011\t\u0007C\u0005\u0003f\u0001\t\n\u0011\"\u0001\u0003b!I!q\r\u0001\u0002\u0002\u0013\u0005#\u0011\u000e\u0005\n\u0005s\u0002\u0011\u0011!C\u0001\u0003OA\u0011Ba\u001f\u0001\u0003\u0003%\tA! \t\u0013\t\r\u0005!!A\u0005B\t\u0015\u0005\"\u0003BJ\u0001\u0005\u0005I\u0011\u0001BK\u0011%\u0011I\nAA\u0001\n\u0003\u0012Y\nC\u0005\u0003 \u0002\t\t\u0011\"\u0011\u0003\"\u001e9!Q\u0019*\t\u0002\t\u001dgAB)S\u0011\u0003\u0011I\rC\u0004\u00026M\"\tAa7\t\u0013\tu7G1A\u0005\u0002\u0005\u001d\u0002\u0002\u0003Bpg\u0001\u0006I!!\u000b\t\u0013\t\u00058G1A\u0005\u0002\u0005\u001d\u0002\u0002\u0003Brg\u0001\u0006I!!\u000b\t\u0013\t\u00158G1A\u0005\u0002\u0005\u001d\u0002\u0002\u0003Btg\u0001\u0006I!!\u000b\t\u0013\t%8G1A\u0005\u0002\u0005\u001d\u0002\u0002\u0003Bvg\u0001\u0006I!!\u000b\t\u000f\t58\u0007\"\u0001\u0003p\"9!Q`\u001a\u0005\u0002\t}\bbBB\u0002g\u0011\u00051Q\u0001\u0005\b\u0007\u0007\u0019D\u0011AB\u0005\u0011\u001d\u0019ya\rC\u0001\u0007#Aqa!\u00064\t\u0003\u00199\u0002C\u0004\u0004\u001eM\"\taa\b\t\u000f\r\r2\u0007\"\u0001\u0004&!91qH\u001a\u0005\u0002\r\u0005\u0003bBB)g\u0011\u000511\u000b\u0005\b\u0007;\u001aD\u0011AB0\u0011\u001d\u0019\u0019g\rC\u0001\u0007KBqaa\u001b4\t\u0003\u0019i\u0007C\u0005\u0004tM\n\t\u0011\"!\u0004v!I1\u0011Q\u001a\u0012\u0002\u0013\u0005!\u0011\r\u0005\n\u0007\u0007\u001b\u0014\u0013!C\u0001\u0005CB\u0011b!\"4\u0003\u0003%\tia\"\t\u0013\re5'%A\u0005\u0002\t\u0005\u0004\"CBNgE\u0005I\u0011\u0001B1\u0011%\u0019ijMA\u0001\n\u0013\u0019yJ\u0001\u0006BaB\u0014x\u000e\u001f+pa.S!a\u0015+\u0002\u0013\u0005<wM]3hCR,'BA+W\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005]C\u0016\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005eS\u0016aA:rY*\u00111\fX\u0001\u0006gB\f'o\u001b\u0006\u0003;z\u000ba!\u00199bG\",'\"A0\u0002\u0007=\u0014xm\u0001\u0001\u0014\r\u0001\u0011wn\u001d?\u0000!\r\u0019GMZ\u0007\u0002%&\u0011QM\u0015\u0002\u0019)f\u0004X\rZ%na\u0016\u0014\u0018\r^5wK\u0006;wM]3hCR,\u0007cA2hS&\u0011\u0001N\u0015\u0002\u001a\u0003B\u0004(o\u001c=U_B\\\u0015iZ4sK\u001e\fG/\u001a\"vM\u001a,'\u000f\u0005\u0002k[6\t1NC\u0001m\u0003\u0015\u00198-\u00197b\u0013\tq7NA\u0002B]f\u0004\"\u0001]9\u000e\u0003QK!A\u001d+\u0003-%k\u0007\u000f\\5dSR\u001c\u0015m\u001d;J]B,H\u000fV=qKN\u00042\u0001^<z\u001b\u0005)(B\u0001<W\u0003\u0015!(/Z3t\u0013\tAXOA\u0006UKJt\u0017M]=MS.,\u0007C\u00019{\u0013\tYHK\u0001\u0006FqB\u0014Xm]:j_:\u0004\"A[?\n\u0005y\\'a\u0002)s_\u0012,8\r\u001e\t\u0005\u0003\u0003\t\tB\u0004\u0003\u0002\u0004\u00055a\u0002BA\u0003\u0003\u0017i!!a\u0002\u000b\u0007\u0005%\u0001-\u0001\u0004=e>|GOP\u0005\u0002Y&\u0019\u0011qB6\u0002\u000fA\f7m[1hK&!\u00111CA\u000b\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\r\tya[\u0001\u0005Kb\u0004(/F\u0001z\u0003\u0015)\u0007\u0010\u001d:!\u0003\u0005Y\u0017AA6!\u0003=i\u0017\r_%uK6\u001cHK]1dW\u0016$\u0017\u0001E7bq&#X-\\:Ue\u0006\u001c7.\u001a3!\u0003YiW\u000f^1cY\u0016\fum\u001a\"vM\u001a,'o\u00144gg\u0016$XCAA\u0015!\rQ\u00171F\u0005\u0004\u0003[Y'aA%oi\u00069R.\u001e;bE2,\u0017iZ4Ck\u001a4WM](gMN,G\u000fI\u0001\u0015S:\u0004X\u000f^!hO\n+hMZ3s\u001f\u001a47/\u001a;\u0002+%t\u0007/\u001e;BO\u001e\u0014UO\u001a4fe>3gm]3uA\u00051A(\u001b8jiz\"B\"!\u000f\u0002<\u0005u\u0012qHA!\u0003\u0007\u0002\"a\u0019\u0001\t\r\u0005]1\u00021\u0001z\u0011\u0019\tib\u0003a\u0001s\"1\u0011\u0011E\u0006A\u0002eD\u0011\"!\n\f!\u0003\u0005\r!!\u000b\t\u0013\u0005E2\u0002%AA\u0002\u0005%B\u0003CA\u001d\u0003\u000f\nY%a\u0014\t\r\u0005%C\u00021\u0001z\u0003\u0015\u0019\u0007.\u001b7e\u0011\u0019\ti\u0005\u0004a\u0001s\u0006!Ao\u001c9L\u0011\u0019\t\t\u0003\u0004a\u0001sRA\u0011\u0011HA*\u0003+\n9\u0006\u0003\u0004\u0002J5\u0001\r!\u001f\u0005\b\u0003\u001bj\u0001\u0019AA\u0015\u0011\u001d\t\t#\u0004a\u0001\u0003S!b!!\u000f\u0002\\\u0005u\u0003BBA%\u001d\u0001\u0007\u0011\u0010\u0003\u0004\u0002N9\u0001\r!\u001f\u000b\u0007\u0003s\t\t'a\u0019\t\r\u0005%s\u00021\u0001z\u0011\u001d\tie\u0004a\u0001\u0003S!B!!\u000f\u0002h!1\u0011\u0011\n\tA\u0002e\fA\"\u001b;f[\u0012\u000bG/\u0019+za\u0016,\"!!\u001c\u0011\t\u0005=\u0014QO\u0007\u0003\u0003cR1!a\u001dY\u0003\u0015!\u0018\u0010]3t\u0013\u0011\t9(!\u001d\u0003\u0011\u0011\u000bG/\u0019+za\u0016\fAa\u001b,bY\u0006\u0011R.\u0019=Ji\u0016l7\u000f\u0016:bG.,GMV1m\u0003\u00151\u0017N]:u\u0003\u0019\u0019XmY8oI\u0006)A\u000f[5sI\u0006Q\u0011N\u001c9viRK\b/Z:\u0016\u0005\u0005\u001d\u0005CBA\u0001\u0003\u0013\u000bi)\u0003\u0003\u0002\f\u0006U!aA*fcB!\u0011qNAH\u0013\u0011\t\t*!\u001d\u0003!\u0005\u00137\u000f\u001e:bGR$\u0015\r^1UsB,\u0017aE2iK\u000e\\\u0017J\u001c9vi\u0012\u000bG/\u0019+za\u0016\u001cHCAAL!\u0011\tI*a(\u000e\u0005\u0005m%bAAO-\u0006A\u0011M\\1msNL7/\u0003\u0003\u0002\"\u0006m%a\u0004+za\u0016\u001c\u0005.Z2l%\u0016\u001cX\u000f\u001c;\u0002\u0011\u0011\fG/\u0019+za\u0016\fqc\u0019:fCR,\u0017iZ4sK\u001e\fG/[8o\u0005V4g-\u001a:\u0015\u0003\u0019\fa!\u001e9eCR,G#\u00024\u0002.\u0006E\u0006BBAX7\u0001\u0007a-\u0001\u0004ck\u001a4WM\u001d\u0005\b\u0003g[\u0002\u0019AA[\u0003\u0015Ig\u000e];u!\u0011\t9,!/\u000e\u0003YK1!a/W\u0005-Ie\u000e^3s]\u0006d'k\\<\u0002\u000b5,'oZ3\u0015\u000b\u0019\f\t-a1\t\r\u0005=F\u00041\u0001g\u0011\u0019\t\u0019\f\ba\u0001M\u0006!QM^1m)\u0011\tI-!6\u0011\t\u0005-\u0017\u0011[\u0007\u0003\u0003\u001bT1!a4W\u0003\u0011)H/\u001b7\n\t\u0005M\u0017Q\u001a\u0002\u0011\u000f\u0016tWM]5d\u0003J\u0014\u0018-\u001f#bi\u0006Da!a,\u001e\u0001\u00041\u0017!C:fe&\fG.\u001b>f)\u0011\tY.a:\u0011\u000b)\fi.!9\n\u0007\u0005}7NA\u0003BeJ\f\u0017\u0010E\u0002k\u0003GL1!!:l\u0005\u0011\u0011\u0015\u0010^3\t\r\u0005=f\u00041\u0001g\u0003-!Wm]3sS\u0006d\u0017N_3\u0015\u0007\u0019\fi\u000fC\u0004\u0002p~\u0001\r!a7\u0002\u001bM$xN]1hK\u001a{'/\\1u\u0003u9\u0018\u000e\u001e5OK^lU\u000f^1cY\u0016\fum\u001a\"vM\u001a,'o\u00144gg\u0016$H\u0003BA{\u0003w\u00042aYA|\u0013\r\tIP\u0015\u0002\u0014\u00136\u0004XM]1uSZ,\u0017iZ4sK\u001e\fG/\u001a\u0005\b\u0003{\u0004\u0003\u0019AA\u0015\u0003eqWm^'vi\u0006\u0014G.Z!hO\n+hMZ3s\u001f\u001a47/\u001a;\u00027]LG\u000f\u001b(fo&s\u0007/\u001e;BO\u001e\u0014UO\u001a4fe>3gm]3u)\u0011\t)Pa\u0001\t\u000f\t\u0015\u0011\u00051\u0001\u0002*\u00059b.Z<J]B,H/Q4h\u0005V4g-\u001a:PM\u001a\u001cX\r^\u0001\u0018o&$\bNT3x\u0007\"LG\u000e\u001a:f]&sG/\u001a:oC2$r!\u001fB\u0006\u0005\u001f\u0011\u0019\u0002\u0003\u0004\u0003\u000e\t\u0002\r!_\u0001\b]\u0016<X\t\u001f9s\u0011\u0019\u0011\tB\ta\u0001s\u0006!a.Z<L\u0011\u0019\u0011)B\ta\u0001s\u0006\u0011b.Z<NCbLE/Z7t)J\f7m[3e\u0003!qW\u000f\u001c7bE2,WC\u0001B\u000e!\rQ'QD\u0005\u0004\u0005?Y'a\u0002\"p_2,\u0017M\\\u0001\u000baJ,G\u000f^=OC6,WC\u0001B\u0013!\u0011\u00119Ca\f\u000f\t\t%\"1\u0006\t\u0004\u0003\u000bY\u0017b\u0001B\u0017W\u00061\u0001K]3eK\u001aLAA!\r\u00034\t11\u000b\u001e:j]\u001eT1A!\fl\u0003\u0011\u0019w\u000e]=\u0015\u0019\u0005e\"\u0011\bB\u001e\u0005{\u0011yD!\u0011\t\u0011\u0005]Q\u0005%AA\u0002eD\u0001\"!\b&!\u0003\u0005\r!\u001f\u0005\t\u0003C)\u0003\u0013!a\u0001s\"I\u0011QE\u0013\u0011\u0002\u0003\u0007\u0011\u0011\u0006\u0005\n\u0003c)\u0003\u0013!a\u0001\u0003S\tabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0003H)\u001a\u0011P!\u0013,\u0005\t-\u0003\u0003\u0002B'\u0005/j!Aa\u0014\u000b\t\tE#1K\u0001\nk:\u001c\u0007.Z2lK\u0012T1A!\u0016l\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u00053\u0012yEA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%iU\u0011!1\r\u0016\u0005\u0003S\u0011I%\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001b\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\u0011Y\u0007\u0005\u0003\u0003n\t]TB\u0001B8\u0015\u0011\u0011\tHa\u001d\u0002\t1\fgn\u001a\u0006\u0003\u0005k\nAA[1wC&!!\u0011\u0007B8\u00031\u0001(o\u001c3vGR\f%/\u001b;z\u00039\u0001(o\u001c3vGR,E.Z7f]R$2!\u001bB@\u0011%\u0011\t)LA\u0001\u0002\u0004\tI#A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0005\u000f\u0003RA!#\u0003\u0010&l!Aa#\u000b\u0007\t55.\u0001\u0006d_2dWm\u0019;j_:LAA!%\u0003\f\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\u0011YBa&\t\u0011\t\u0005u&!AA\u0002%\f!\u0003\u001d:pIV\u001cG/\u00127f[\u0016tGOT1nKR!!1\u000eBO\u0011%\u0011\t\tMA\u0001\u0002\u0004\tI#\u0001\u0004fcV\fGn\u001d\u000b\u0005\u00057\u0011\u0019\u000b\u0003\u0005\u0003\u0002F\n\t\u00111\u0001jQM\u0001!q\u0015BW\u0005_\u0013\u0019L!.\u0003:\nm&q\u0018Ba!\r\u0001(\u0011V\u0005\u0004\u0005W#&!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u0005c\u000b!1\u0018\u0006!A\u0001\u0002sLR+O\u0007~CS\r\u001f9sY\u0001ZG\u0006I7bq&#X-\\:Ue\u0006\u001c7.\u001a3*A5\u0002#+\u001a;ve:\u001c\b\u0005^8qA-\u0004\u0013\u000e^3ng\u0002:\u0018\u000e\u001e5!i\",\u0017N\u001d\u0011ge\u0016\fX/\u001a8ds:R\u0001\u0005\t\u0011!A\u0001\u00027\u000e\u0019\u0011B]\u0002z\u0007\u000f^5p]\u0006d\u0007%\u0013(U\u000b\u001e+%\u000b\t7ji\u0016\u0014\u0018\r\u001c\u0011he\u0016\fG/\u001a:!i\"\fg\u000e\t\u0019/A%3\u0007e\u001b\u0011jg\u0002rw\u000e\u001e\u0011ta\u0016\u001c\u0017NZ5fI2\u0002\u0013\u000e\u001e\u0011eK\u001a\fW\u000f\u001c;tAQ|\u0007%\u000e\u0018\u000bA\u0001\u0002\u0003\u0005\t\u0011a[\u0006D\u0018\n^3ngR\u0013\u0018mY6fI\u0002\u0004\u0013I\u001c\u0011paRLwN\\1mA%sE+R$F%\u0002b\u0017\u000e^3sC2\u0004sM]3bi\u0016\u0014\b\u0005\u001e5b]\u0002z'\u000fI3rk\u0006d\u0007\u0005^8!W\u0002\ng\u000e\u001a\u0011iCN\u0004S\u000f\u001d9fe\u0002b\u0017.\\5uA=4\u0007%\r\u00191aA\u0002\u0004G\f\u0011JM\u0002j\u0017\r_%uK6\u001cHK]1dW\u0016$\u0007%[:!]>$\be\u001d9fG&4\u0017.\u001a3-A%$\b\u0005Z3gCVdGo\u001d\u0011u_\u0002\n\u0004\u0007\r\u00191])\u0001\u0003%\u0001\u0005fq\u0006l\u0007\u000f\\3tC\t\u00119,\u0001C\u001e\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"*\u0007\u0010\u001d:*A\u0019\u0013v*\u0014\u0011W\u00032+Vi\u0015\u0011)a%b\u0003\u0005\u000b\u0019*Y\u0001B\u0013'\u000b\u0017!QEJC\u0006\t\u00153S1\u0002\u0003fM\u0015-A!\"\u0014\u0006\f\u0011)i%\u0002\u0013i\u0015\u0011uC\nDS\r\u001f9sSmR\u0001\u0005\t\u0011!A\u0001\u00023l\u001f\u0012ji\u0016l'E\u000f\u0019-E\r|WO\u001c;#uIjHf\u001f\u0012ji\u0016l'E\u000f\u001b-E\r|WO\u001c;#uIjHf\u001f\u0012ji\u0016l'EO\u0019-E\r|WO\u001c;#uIjHf\u001f\u0012ji\u0016l'E\u000f\u001a-E\r|WO\u001c;#uEjHf\u001f\u0012ji\u0016l'EO\u001a-E\r|WO\u001c;#uEjXL\u0003\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)Kb\u0004(\u000f\f\u00113S\u00012%kT'!-\u0006cU+R*!O\u0005<C\u0006I\u0014cO1\u0002seY\u0014-A\u001d\u001aw\u0005\f\u0011(G\u001eb\u0003eJ2(Y\u0001:Cm\n\u0017!O\u0011<\u0003%Q*!i\u0006\u0014\u0007&\u001a=qe&Z$\u0002\t\u0011!A\u0001\u0002\u0003eW>#SR,WN\t\u001e#G\nb#eY8v]R\u0014#\bN?-w\nJG/Z7#u\t\"'\u0005\f\u0012d_VtGO\t\u001e3{vS!\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK3yaJd\u0003%\r\u0019-AE\u0002\u0004'\u000b\u0011G%>k\u0005EV!M+\u0016\u001b\u0006\u0005\u000b\u0019*Y\u0001B\u0013'\u000b\u0017!QEJC\u0006\t\u00153S1\u0002\u0003FM\u0015-A!\u0012\u0014\u0006I!TAQ\f'\rK3yaJL3H\u0003\u0011!A\u0001\u0002\u0003\u0005I.|E%$X-\u001c\u0012;e1\u00123m\\;oi\nR4' \u0017|E%$X-\u001c\u0012;c1\u00123m\\;oi\nR$' \u0017|E%$X-\u001c\u0012;a1\u00123m\\;oi\nR\u0014'`/\u000bA\u0001\nQa\u001a:pkB\f#A!0\u0002\u0013\u0005<wm\u00184v]\u000e\u001c\u0018!B:j]\u000e,\u0017E\u0001Bb\u0003\u0015!d&\r\u00181\u0003)\t\u0005\u000f\u001d:pqR{\u0007o\u0013\t\u0003GN\u001aRa\rBf\u0005#\u00042A\u001bBg\u0013\r\u0011ym\u001b\u0002\u0007\u0003:L(+\u001a4\u0011\t\tM'\u0011\\\u0007\u0003\u0005+TAAa6\u0003t\u0005\u0011\u0011n\\\u0005\u0005\u0003'\u0011)\u000e\u0006\u0002\u0003H\u0006IA)\u0012$B+2#vlS\u0001\u000b\t\u00163\u0015)\u0016'U?.\u0003\u0013!\u0007#F\r\u0006+F\nV0N\u0003b{\u0016\nV#N'~#&+Q\"L\u000b\u0012\u000b!\u0004R#G\u0003VcEkX'B1~KE+R'T?R\u0013\u0016iQ&F\t\u0002\nq#T!Y?&#V)T*`)J\u000b5iS#E?2KU*\u0013+\u000215\u000b\u0005lX%U\u000b6\u001bv\f\u0016*B\u0007.+Ei\u0018'J\u001b&#\u0006%\u0001\fW\u001f&#u,T!Y?&#V)T*`)J\u000b5iS#E\u0003]1v*\u0013#`\u001b\u0006Cv,\u0013+F\u001bN{FKU!D\u0017\u0016#\u0005%\u0001\fdQ\u0016\u001c7.\u0012=qe\u0016\u001c8/[8o\u001d>$h*\u001e7m)\u0019\u0011\tPa>\u0003zB\u0019!Na=\n\u0007\tU8N\u0001\u0003V]&$\bBBA\f{\u0001\u0007\u0011\u0010C\u0004\u0003|v\u0002\rA!\n\u0002\u0011\u0015D\bO\u001d(b[\u0016\faa\u00195fG.\\E\u0003\u0002By\u0007\u0003Aq!!\b?\u0001\u0004\tI#\u0001\u000bdQ\u0016\u001c7.T1y\u0013R,Wn\u001d+sC\u000e\\W\r\u001a\u000b\u0005\u0005c\u001c9\u0001C\u0004\u0002\"}\u0002\r!!\u000b\u0015\r\tE81BB\u0007\u0011\u001d\t\t\u0003\u0011a\u0001\u0003SAq!!\bA\u0001\u0004\tI#A\thKR\u0014Vm];mi\u0012\u000bG/\u0019+za\u0016$B!!\u001c\u0004\u0014!9\u0011\u0011N!A\u0002\u00055\u0014aE5t\t\u0006$\u0018\rV=qKN+\b\u000f]8si\u0016$G\u0003\u0002B\u000e\u00073Aqaa\u0007C\u0001\u0004\ti'\u0001\u0005ji\u0016lG+\u001f9f\u00035\u0019\u0017\r\\'bq6\u000b\u0007oU5{KR!\u0011\u0011FB\u0011\u0011\u001d\t\tc\u0011a\u0001\u0003S\t\u0011c\u0019:fCR,\u0017\n^3ngN[W\r^2i)\u0019\u00199ca\u000e\u0004<A)1\u0011FB\u001aS6\u001111\u0006\u0006\u0005\u0007[\u0019y#A\u0006ge\u0016\fX/\u001a8dS\u0016\u001c(bAB\u00199\u0006aA-\u0019;bg.,Go\u00195fg&!1QGB\u0016\u0005-IE/Z7t'.,Go\u00195\t\r\reB\t1\u0001z\u00039IG/Z7FqB\u0014Xm]:j_:Dqa!\u0010E\u0001\u0004\tI#\u0001\u0006nCbl\u0015\r]*ju\u0016\fabZ3o'.,Go\u00195TKJ$U\r\u0006\u0003\u0004D\r=\u0003#BB#\u0007\u0017JWBAB$\u0015\u0011\u0019Iea\f\u0002\r\r|W.\\8o\u0013\u0011\u0019iea\u0012\u0003#\u0005\u0013(/Y=PM&#X-\\:TKJ$U\rC\u0004\u0002$\u0016\u0003\r!!\u001c\u0002-\u001d,GoU6fi\u000eD7\u000b^1uK\u0012\u000bG/\u0019+za\u0016$Ba!\u0016\u0004\\A!\u0011qNB,\u0013\u0011\u0019I&!\u001d\u0003\u0015M#(/^2u)f\u0004X\rC\u0004\u0002j\u0019\u0003\r!!\u001c\u0002\u001b\u0011\fG/\u0019+za\u0016$v\u000e\u0012#M)\u0011\u0011)c!\u0019\t\u000f\u0005\rv\t1\u0001\u0002n\u0005iA\t\u0012'U_\u0012\u000bG/\u0019+za\u0016$B!!\u001c\u0004h!91\u0011\u000e%A\u0002\t\u0015\u0012a\u00013eY\u000612\r[3dWN#\u0018\r^3GS\u0016dG-\u00118e)f\u0004X\r\u0006\u0003\u0002\u0018\u000e=\u0004BBB9\u0013\u0002\u0007\u00110A\u0003ti\u0006$X-A\u0003baBd\u0017\u0010\u0006\u0007\u0002:\r]4\u0011PB>\u0007{\u001ay\b\u0003\u0004\u0002\u0018)\u0003\r!\u001f\u0005\u0007\u0003;Q\u0005\u0019A=\t\r\u0005\u0005\"\n1\u0001z\u0011%\t)C\u0013I\u0001\u0002\u0004\tI\u0003C\u0005\u00022)\u0003\n\u00111\u0001\u0002*\u0005y\u0011\r\u001d9ms\u0012\"WMZ1vYR$C'A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00136\u0003\u001d)h.\u00199qYf$Ba!#\u0004\u0016B)!na#\u0004\u0010&\u00191QR6\u0003\r=\u0003H/[8o!)Q7\u0011S=zs\u0006%\u0012\u0011F\u0005\u0004\u0007'['A\u0002+va2,W\u0007C\u0005\u0004\u00186\u000b\t\u00111\u0001\u0002:\u0005\u0019\u0001\u0010\n\u0019\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00135\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%k\u0005aqO]5uKJ+\u0007\u000f\\1dKR\u00111\u0011\u0015\t\u0005\u0005[\u001a\u0019+\u0003\u0003\u0004&\n=$AB(cU\u0016\u001cG\u000f")
public class ApproxTopK
extends TypedImperativeAggregate<ApproxTopKAggregateBuffer<Object>>
implements ImplicitCastInputTypes,
TernaryLike<Expression>,
Serializable {
    private DataType itemDataType;
    private int kVal;
    private int maxItemsTrackedVal;
    private final Expression expr;
    private final Expression k;
    private final Expression maxItemsTracked;
    private final int mutableAggBufferOffset;
    private final int inputAggBufferOffset;
    private transient Seq<Expression> children;
    private volatile transient boolean bitmap$trans$0;
    private volatile byte bitmap$0;

    public static int $lessinit$greater$default$5() {
        return ApproxTopK$.MODULE$.$lessinit$greater$default$5();
    }

    public static int $lessinit$greater$default$4() {
        return ApproxTopK$.MODULE$.$lessinit$greater$default$4();
    }

    public static Option<Tuple5<Expression, Expression, Expression, Object, Object>> unapply(ApproxTopK x$0) {
        return ApproxTopK$.MODULE$.unapply(x$0);
    }

    public static int apply$default$5() {
        return ApproxTopK$.MODULE$.apply$default$5();
    }

    public static int apply$default$4() {
        return ApproxTopK$.MODULE$.apply$default$4();
    }

    public static TypeCheckResult checkStateFieldAndType(Expression state) {
        return ApproxTopK$.MODULE$.checkStateFieldAndType(state);
    }

    public static DataType DDLToDataType(String ddl) {
        return ApproxTopK$.MODULE$.DDLToDataType(ddl);
    }

    public static String dataTypeToDDL(DataType dataType) {
        return ApproxTopK$.MODULE$.dataTypeToDDL(dataType);
    }

    public static StructType getSketchStateDataType(DataType itemDataType) {
        return ApproxTopK$.MODULE$.getSketchStateDataType(itemDataType);
    }

    public static ArrayOfItemsSerDe<Object> genSketchSerDe(DataType dataType) {
        return ApproxTopK$.MODULE$.genSketchSerDe(dataType);
    }

    public static ItemsSketch<Object> createItemsSketch(Expression itemExpression, int maxMapSize) {
        return ApproxTopK$.MODULE$.createItemsSketch(itemExpression, maxMapSize);
    }

    public static int calMaxMapSize(int maxItemsTracked) {
        return ApproxTopK$.MODULE$.calMaxMapSize(maxItemsTracked);
    }

    public static boolean isDataTypeSupported(DataType itemType) {
        return ApproxTopK$.MODULE$.isDataTypeSupported(itemType);
    }

    public static DataType getResultDataType(DataType itemDataType) {
        return ApproxTopK$.MODULE$.getResultDataType(itemDataType);
    }

    public static void checkMaxItemsTracked(int maxItemsTracked, int k) {
        ApproxTopK$.MODULE$.checkMaxItemsTracked(maxItemsTracked, k);
    }

    public static void checkMaxItemsTracked(int maxItemsTracked) {
        ApproxTopK$.MODULE$.checkMaxItemsTracked(maxItemsTracked);
    }

    public static void checkK(int k) {
        ApproxTopK$.MODULE$.checkK(k);
    }

    public static void checkExpressionNotNull(Expression expr, String exprName) {
        ApproxTopK$.MODULE$.checkExpressionNotNull(expr, exprName);
    }

    public static int VOID_MAX_ITEMS_TRACKED() {
        return ApproxTopK$.MODULE$.VOID_MAX_ITEMS_TRACKED();
    }

    public static int MAX_ITEMS_TRACKED_LIMIT() {
        return ApproxTopK$.MODULE$.MAX_ITEMS_TRACKED_LIMIT();
    }

    public static int DEFAULT_MAX_ITEMS_TRACKED() {
        return ApproxTopK$.MODULE$.DEFAULT_MAX_ITEMS_TRACKED();
    }

    public static int DEFAULT_K() {
        return ApproxTopK$.MODULE$.DEFAULT_K();
    }

    @Override
    public final TreeNode mapChildren(Function1 f) {
        return TernaryLike.mapChildren$(this, f);
    }

    @Override
    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return TernaryLike.withNewChildrenInternal$(this, newChildren);
    }

    private Seq<Expression> children$lzycompute() {
        ApproxTopK approxTopK = this;
        synchronized (approxTopK) {
            if (!this.bitmap$trans$0) {
                this.children = TernaryLike.children$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.children;
    }

    @Override
    public final Seq<Expression> children() {
        if (!this.bitmap$trans$0) {
            return this.children$lzycompute();
        }
        return this.children;
    }

    public Expression expr() {
        return this.expr;
    }

    public Expression k() {
        return this.k;
    }

    public Expression maxItemsTracked() {
        return this.maxItemsTracked;
    }

    @Override
    public int mutableAggBufferOffset() {
        return this.mutableAggBufferOffset;
    }

    @Override
    public int inputAggBufferOffset() {
        return this.inputAggBufferOffset;
    }

    private DataType itemDataType$lzycompute() {
        ApproxTopK approxTopK = this;
        synchronized (approxTopK) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.itemDataType = this.expr().dataType();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.itemDataType;
    }

    private DataType itemDataType() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.itemDataType$lzycompute();
        }
        return this.itemDataType;
    }

    /*
     * WARNING - void declaration
     */
    private int kVal$lzycompute() {
        ApproxTopK approxTopK = this;
        synchronized (approxTopK) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                void var2_2;
                ApproxTopK$.MODULE$.checkExpressionNotNull(this.k(), "k");
                int kVal = BoxesRunTime.unboxToInt((Object)this.k().eval(this.k().eval$default$1()));
                ApproxTopK$.MODULE$.checkK(kVal);
                this.kVal = var2_2;
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.kVal;
    }

    private int kVal() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.kVal$lzycompute();
        }
        return this.kVal;
    }

    /*
     * WARNING - void declaration
     */
    private int maxItemsTrackedVal$lzycompute() {
        ApproxTopK approxTopK = this;
        synchronized (approxTopK) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                void var2_2;
                ApproxTopK$.MODULE$.checkExpressionNotNull(this.maxItemsTracked(), "maxItemsTracked");
                int maxItemsTrackedVal = BoxesRunTime.unboxToInt((Object)this.maxItemsTracked().eval(this.maxItemsTracked().eval$default$1()));
                ApproxTopK$.MODULE$.checkMaxItemsTracked(maxItemsTrackedVal, this.kVal());
                this.maxItemsTrackedVal = var2_2;
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.maxItemsTrackedVal;
    }

    private int maxItemsTrackedVal() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.maxItemsTrackedVal$lzycompute();
        }
        return this.maxItemsTrackedVal;
    }

    @Override
    public Expression first() {
        return this.expr();
    }

    @Override
    public Expression second() {
        return this.k();
    }

    @Override
    public Expression third() {
        return this.maxItemsTracked();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)AnyDataType$.MODULE$, (List)new .colon.colon((Object)IntegerType$.MODULE$, (List)new .colon.colon((Object)IntegerType$.MODULE$, (List)Nil$.MODULE$)));
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        TypeCheckResult defaultCheck = ExpectsInputTypes.checkInputDataTypes$(this);
        if (defaultCheck.isFailure()) {
            return defaultCheck;
        }
        if (!ApproxTopK$.MODULE$.isDataTypeSupported(this.itemDataType())) {
            return new TypeCheckResult.TypeCheckFailure(this.itemDataType().typeName() + " columns are not supported");
        }
        if (!this.k().foldable()) {
            return new TypeCheckResult.TypeCheckFailure("K must be a constant literal");
        }
        if (!this.maxItemsTracked().foldable()) {
            return new TypeCheckResult.TypeCheckFailure("Number of items tracked must be a constant literal");
        }
        return TypeCheckResult$TypeCheckSuccess$.MODULE$;
    }

    @Override
    public DataType dataType() {
        return ApproxTopK$.MODULE$.getResultDataType(this.itemDataType());
    }

    @Override
    public ApproxTopKAggregateBuffer<Object> createAggregationBuffer() {
        int maxMapSize = ApproxTopK$.MODULE$.calMaxMapSize(this.maxItemsTrackedVal());
        ItemsSketch<Object> sketch = ApproxTopK$.MODULE$.createItemsSketch(this.expr(), maxMapSize);
        return new ApproxTopKAggregateBuffer<Object>(sketch, 0L);
    }

    @Override
    public ApproxTopKAggregateBuffer<Object> update(ApproxTopKAggregateBuffer<Object> buffer, InternalRow input) {
        return buffer.update(this.expr(), input);
    }

    @Override
    public ApproxTopKAggregateBuffer<Object> merge(ApproxTopKAggregateBuffer<Object> buffer, ApproxTopKAggregateBuffer<Object> input) {
        return buffer.merge(input);
    }

    public GenericArrayData eval(ApproxTopKAggregateBuffer<Object> buffer) {
        return buffer.eval(this.kVal(), this.itemDataType());
    }

    @Override
    public byte[] serialize(ApproxTopKAggregateBuffer<Object> buffer) {
        return buffer.serialize(ApproxTopK$.MODULE$.genSketchSerDe(this.itemDataType()));
    }

    @Override
    public ApproxTopKAggregateBuffer<Object> deserialize(byte[] storageFormat) {
        return ApproxTopKAggregateBuffer$.MODULE$.deserialize(storageFormat, ApproxTopK$.MODULE$.genSketchSerDe(this.itemDataType()));
    }

    @Override
    public ImperativeAggregate withNewMutableAggBufferOffset(int newMutableAggBufferOffset) {
        int x$1 = newMutableAggBufferOffset;
        Expression x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        Expression x$4 = this.copy$default$3();
        int x$5 = this.copy$default$5();
        return this.copy(x$2, x$3, x$4, x$1, x$5);
    }

    @Override
    public ImperativeAggregate withNewInputAggBufferOffset(int newInputAggBufferOffset) {
        int x$1 = newInputAggBufferOffset;
        Expression x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        Expression x$4 = this.copy$default$3();
        int x$5 = this.copy$default$4();
        return this.copy(x$2, x$3, x$4, x$5, x$1);
    }

    @Override
    public Expression withNewChildrenInternal(Expression newExpr, Expression newK, Expression newMaxItemsTracked) {
        return this.copy(newExpr, newK, newMaxItemsTracked, this.copy$default$4(), this.copy$default$5());
    }

    @Override
    public boolean nullable() {
        return false;
    }

    @Override
    public String prettyName() {
        return (String)this.getTagValue(FunctionRegistry$.MODULE$.FUNC_ALIAS()).getOrElse((Function0 & Serializable)() -> "approx_top_k");
    }

    public ApproxTopK copy(Expression expr, Expression k, Expression maxItemsTracked, int mutableAggBufferOffset, int inputAggBufferOffset) {
        return new ApproxTopK(expr, k, maxItemsTracked, mutableAggBufferOffset, inputAggBufferOffset);
    }

    public Expression copy$default$1() {
        return this.expr();
    }

    public Expression copy$default$2() {
        return this.k();
    }

    public Expression copy$default$3() {
        return this.maxItemsTracked();
    }

    public int copy$default$4() {
        return this.mutableAggBufferOffset();
    }

    public int copy$default$5() {
        return this.inputAggBufferOffset();
    }

    @Override
    public String productPrefix() {
        return "ApproxTopK";
    }

    public int productArity() {
        return 5;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.expr();
            }
            case 1: {
                return this.k();
            }
            case 2: {
                return this.maxItemsTracked();
            }
            case 3: {
                return BoxesRunTime.boxToInteger((int)this.mutableAggBufferOffset());
            }
            case 4: {
                return BoxesRunTime.boxToInteger((int)this.inputAggBufferOffset());
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ApproxTopK;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "expr";
            }
            case 1: {
                return "k";
            }
            case 2: {
                return "maxItemsTracked";
            }
            case 3: {
                return "mutableAggBufferOffset";
            }
            case 4: {
                return "inputAggBufferOffset";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ApproxTopK)) return false;
        boolean bl = true;
        if (!bl) return false;
        ApproxTopK approxTopK = (ApproxTopK)x$1;
        if (this.mutableAggBufferOffset() != approxTopK.mutableAggBufferOffset()) return false;
        if (this.inputAggBufferOffset() != approxTopK.inputAggBufferOffset()) return false;
        Expression expression = this.expr();
        Expression expression2 = approxTopK.expr();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.k();
        Expression expression4 = approxTopK.k();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.maxItemsTracked();
        Expression expression6 = approxTopK.maxItemsTracked();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!approxTopK.canEqual(this)) return false;
        return true;
    }

    public ApproxTopK(Expression expr, Expression k, Expression maxItemsTracked, int mutableAggBufferOffset, int inputAggBufferOffset) {
        this.expr = expr;
        this.k = k;
        this.maxItemsTracked = maxItemsTracked;
        this.mutableAggBufferOffset = mutableAggBufferOffset;
        this.inputAggBufferOffset = inputAggBufferOffset;
        ExpectsInputTypes.$init$(this);
        TernaryLike.$init$(this);
    }

    public ApproxTopK(Expression child, Expression topK, Expression maxItemsTracked) {
        this(child, topK, maxItemsTracked, 0, 0);
    }

    public ApproxTopK(Expression child, int topK, int maxItemsTracked) {
        this(child, Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)topK)), Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)maxItemsTracked)), 0, 0);
    }

    public ApproxTopK(Expression child, Expression topK) {
        this(child, topK, Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)ApproxTopK$.MODULE$.DEFAULT_MAX_ITEMS_TRACKED())), 0, 0);
    }

    public ApproxTopK(Expression child, int topK) {
        this(child, Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)topK)), Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)ApproxTopK$.MODULE$.DEFAULT_MAX_ITEMS_TRACKED())), 0, 0);
    }

    public ApproxTopK(Expression child) {
        this(child, Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)ApproxTopK$.MODULE$.DEFAULT_K())), Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)ApproxTopK$.MODULE$.DEFAULT_MAX_ITEMS_TRACKED())), 0, 0);
    }
}

