/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.unsafe.types;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.KryoSerializable;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.ibm.icu.lang.UCharacter;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.apache.spark.sql.catalyst.util.CollationFactory;
import org.apache.spark.unsafe.Platform;
import org.apache.spark.unsafe.UTF8StringBuilder;
import org.apache.spark.unsafe.array.ByteArrayMethods;
import org.apache.spark.unsafe.hash.Murmur3_x86_32;
import org.apache.spark.unsafe.types.ByteArray;
import org.apache.spark.util.SparkEnvUtils$;

public final class UTF8String
implements Comparable<UTF8String>,
Externalizable,
KryoSerializable,
Cloneable {
    @Nonnull
    private Object base;
    private long offset;
    private int numBytes;
    private volatile int numChars = -1;
    private volatile UTF8StringValidity isValid = UTF8StringValidity.UNKNOWN;
    private volatile int numBytesValid = -1;
    private volatile IsFullAscii isFullAscii = IsFullAscii.UNKNOWN;
    private static byte[] bytesOfCodePointInUTF8 = new byte[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final UTF8String COMMA_UTF8 = UTF8String.fromString(",");
    public static final UTF8String EMPTY_UTF8 = UTF8String.fromString("");
    public static final UTF8String ZERO_UTF8 = UTF8String.fromString("0");
    public static final UTF8String SPACE_UTF8 = UTF8String.fromString(" ");
    private static final byte[] UNICODE_REPLACEMENT_CHARACTER = new byte[]{-17, -65, -67};
    private static final byte[] US_ENGLISH_MAPPING = new byte[]{48, 49, 50, 51, 48, 49, 50, 55, 48, 50, 50, 52, 53, 53, 48, 49, 50, 54, 50, 51, 48, 49, 55, 50, 48, 50};

    public Object getBaseObject() {
        return this.base;
    }

    public long getBaseOffset() {
        return this.offset;
    }

    public static UTF8String fromBytes(byte[] bytes) {
        if (bytes != null) {
            return new UTF8String(bytes, Platform.BYTE_ARRAY_OFFSET, bytes.length);
        }
        return null;
    }

    public static UTF8String fromBytes(byte[] bytes, int offset, int numBytes) {
        if (bytes != null) {
            return new UTF8String(bytes, Platform.BYTE_ARRAY_OFFSET + offset, numBytes);
        }
        return null;
    }

    public static UTF8String fromAddress(Object base, long offset, int numBytes) {
        return new UTF8String(base, offset, numBytes);
    }

    public static UTF8String fromString(String str) {
        return str == null ? null : UTF8String.fromBytes(str.getBytes(StandardCharsets.UTF_8));
    }

    public static UTF8String blankString(int length) {
        byte[] spaces = new byte[length];
        Arrays.fill(spaces, (byte)32);
        return UTF8String.fromBytes(spaces);
    }

    public static boolean isWhitespaceOrISOControl(int codePoint) {
        return Character.isWhitespace(codePoint) || Character.isISOControl(codePoint);
    }

    private UTF8String(Object base, long offset, int numBytes) {
        this.base = base;
        this.offset = offset;
        this.numBytes = numBytes;
    }

    public UTF8String() {
        this(null, 0L, 0);
    }

    public void writeToMemory(Object target, long targetOffset) {
        Platform.copyMemory(this.base, this.offset, target, targetOffset, this.numBytes);
    }

    public void writeTo(ByteBuffer buffer) {
        assert (buffer.hasArray());
        byte[] target = buffer.array();
        int offset = buffer.arrayOffset();
        int pos = buffer.position();
        this.writeToMemory(target, Platform.BYTE_ARRAY_OFFSET + offset + pos);
        buffer.position(pos + this.numBytes);
    }

    @Nonnull
    public ByteBuffer getByteBuffer() {
        Object object = this.base;
        if (object instanceof byte[]) {
            byte[] bytes = (byte[])object;
            if (this.offset >= (long)Platform.BYTE_ARRAY_OFFSET) {
                long arrayOffset = this.offset - (long)Platform.BYTE_ARRAY_OFFSET;
                if ((long)bytes.length < arrayOffset + (long)this.numBytes) {
                    throw new ArrayIndexOutOfBoundsException();
                }
                return ByteBuffer.wrap(bytes, (int)arrayOffset, this.numBytes);
            }
        }
        return ByteBuffer.wrap(this.getBytes());
    }

    public void writeTo(OutputStream out) throws IOException {
        ByteBuffer bb = this.getByteBuffer();
        assert (bb.hasArray());
        out.write(bb.array(), bb.arrayOffset() + bb.position(), bb.remaining());
    }

    public static int numBytesForFirstByte(byte b) {
        int offset = b & 0xFF;
        byte numBytes = bytesOfCodePointInUTF8[offset];
        return numBytes == 0 ? (byte)1 : numBytes;
    }

    public int numBytes() {
        return this.numBytes;
    }

    public int numChars() {
        if (this.numChars == -1) {
            this.numChars = this.getNumChars();
        }
        return this.numChars;
    }

    private int getNumChars() {
        int len = 0;
        for (int i = 0; i < this.numBytes; i += UTF8String.numBytesForFirstByte(this.getByte(i))) {
            ++len;
        }
        return len;
    }

    public long getPrefix() {
        return ByteArray.getPrefix(this.base, this.offset, this.numBytes);
    }

    public byte[] getBytes() {
        byte[] bytes;
        Object object;
        if (this.offset == (long)Platform.BYTE_ARRAY_OFFSET && (object = this.base) instanceof byte[] && (bytes = (byte[])object).length == this.numBytes) {
            return bytes;
        }
        byte[] bytes2 = new byte[this.numBytes];
        Platform.copyMemory(this.base, this.offset, bytes2, Platform.BYTE_ARRAY_OFFSET, this.numBytes);
        return bytes2;
    }

    private static boolean isValidContinuationByte(byte b) {
        return b >= -128 && b <= -65;
    }

    private static boolean isValidSecondByte(byte b, byte firstByte) {
        return switch (firstByte) {
            case -32 -> {
                if (b >= -96 && b <= -65) {
                    yield true;
                }
                yield false;
            }
            case -19 -> {
                if (b >= -128 && b <= -97) {
                    yield true;
                }
                yield false;
            }
            case -16 -> {
                if (b >= -112 && b <= -65) {
                    yield true;
                }
                yield false;
            }
            case -12 -> {
                if (b >= -128 && b <= -113) {
                    yield true;
                }
                yield false;
            }
            default -> UTF8String.isValidContinuationByte(b);
        };
    }

    private static void insertReplacementCharacter(byte[] bytes, int byteIndex) {
        for (byte b : UNICODE_REPLACEMENT_CHARACTER) {
            bytes[byteIndex++] = b;
        }
    }

    public UTF8String makeValid() {
        if (this.isValid()) {
            return this;
        }
        return UTF8String.fromBytes(this.makeValidBytes());
    }

    private byte[] makeValidBytes() {
        assert (this.numBytesValid > 0);
        byte[] bytes = new byte[this.numBytesValid];
        int byteIndex = 0;
        int byteIndexValid = 0;
        while (byteIndex < this.numBytes) {
            byte nextByte;
            int continuationBytes;
            byte firstByte = this.getByte(byteIndex);
            byte expectedLen = bytesOfCodePointInUTF8[firstByte & 0xFF];
            int codePointLen = Math.min(expectedLen, this.numBytes - byteIndex);
            if (codePointLen == 0) {
                UTF8String.insertReplacementCharacter(bytes, byteIndexValid);
                byteIndexValid += UNICODE_REPLACEMENT_CHARACTER.length;
                ++byteIndex;
                continue;
            }
            if (codePointLen == 1) {
                if (firstByte >= 0) {
                    bytes[byteIndexValid++] = firstByte;
                } else {
                    UTF8String.insertReplacementCharacter(bytes, byteIndexValid);
                    byteIndexValid += UNICODE_REPLACEMENT_CHARACTER.length;
                }
                ++byteIndex;
                continue;
            }
            byte secondByte = this.getByte(byteIndex + 1);
            if (!UTF8String.isValidSecondByte(secondByte, firstByte)) {
                UTF8String.insertReplacementCharacter(bytes, byteIndexValid);
                byteIndexValid += UNICODE_REPLACEMENT_CHARACTER.length;
                ++byteIndex;
                continue;
            }
            for (continuationBytes = 2; continuationBytes < codePointLen && UTF8String.isValidContinuationByte(nextByte = this.getByte(byteIndex + continuationBytes)); ++continuationBytes) {
            }
            if (continuationBytes < expectedLen) {
                UTF8String.insertReplacementCharacter(bytes, byteIndexValid);
                byteIndexValid += UNICODE_REPLACEMENT_CHARACTER.length;
                byteIndex += continuationBytes;
                continue;
            }
            for (int i = 0; i < codePointLen; ++i) {
                bytes[byteIndexValid++] = this.getByte(byteIndex + i);
            }
            byteIndex += codePointLen;
        }
        return bytes;
    }

    public boolean isValid() {
        if (this.isValid == UTF8StringValidity.UNKNOWN) {
            this.isValid = this.getIsValid();
        }
        return this.isValid == UTF8StringValidity.IS_VALID;
    }

    private UTF8StringValidity getIsValid() {
        boolean isValid = true;
        int byteIndex = 0;
        int byteCount = 0;
        while (byteIndex < this.numBytes) {
            byte nextByte;
            int continuationBytes;
            byte firstByte = this.getByte(byteIndex);
            byte expectedLen = bytesOfCodePointInUTF8[firstByte & 0xFF];
            int codePointLen = Math.min(expectedLen, this.numBytes - byteIndex);
            if (codePointLen == 0) {
                byteCount += UNICODE_REPLACEMENT_CHARACTER.length;
                isValid = false;
                ++byteIndex;
                continue;
            }
            if (codePointLen == 1) {
                if (firstByte >= 0) {
                    ++byteCount;
                } else {
                    byteCount += UNICODE_REPLACEMENT_CHARACTER.length;
                    isValid = false;
                }
                ++byteIndex;
                continue;
            }
            byte secondByte = this.getByte(byteIndex + 1);
            if (!UTF8String.isValidSecondByte(secondByte, firstByte)) {
                byteCount += UNICODE_REPLACEMENT_CHARACTER.length;
                isValid = false;
                ++byteIndex;
                continue;
            }
            for (continuationBytes = 2; continuationBytes < codePointLen && UTF8String.isValidContinuationByte(nextByte = this.getByte(byteIndex + continuationBytes)); ++continuationBytes) {
            }
            if (continuationBytes < expectedLen) {
                byteCount += UNICODE_REPLACEMENT_CHARACTER.length;
                isValid = false;
                byteIndex += continuationBytes;
                continue;
            }
            for (int i = 0; i < codePointLen; ++i) {
                ++byteCount;
            }
            byteIndex += codePointLen;
        }
        this.setNumBytesValid(byteCount);
        return isValid ? UTF8StringValidity.IS_VALID : UTF8StringValidity.NOT_VALID;
    }

    private void setNumBytesValid(int byteCount) {
        if (byteCount < 0) {
            throw new IllegalStateException("Error in UTF-8 byte count");
        }
        this.numBytesValid = byteCount;
    }

    public Iterator<Integer> codePointIterator() {
        return this.codePointIterator(CodePointIteratorType.CODE_POINT_ITERATOR_ASSUME_VALID);
    }

    public Iterator<Integer> codePointIterator(CodePointIteratorType iteratorMode) {
        if (iteratorMode == CodePointIteratorType.CODE_POINT_ITERATOR_MAKE_VALID) {
            return this.makeValid().codePointIterator();
        }
        return new CodePointIterator();
    }

    public Iterator<Integer> reverseCodePointIterator() {
        return this.reverseCodePointIterator(CodePointIteratorType.CODE_POINT_ITERATOR_ASSUME_VALID);
    }

    public Iterator<Integer> reverseCodePointIterator(CodePointIteratorType iteratorMode) {
        if (iteratorMode == CodePointIteratorType.CODE_POINT_ITERATOR_MAKE_VALID) {
            return this.makeValid().reverseCodePointIterator();
        }
        return new ReverseCodePointIterator();
    }

    public UTF8String substring(int start, int until) {
        int c;
        if (until <= start || start >= this.numBytes) {
            return EMPTY_UTF8;
        }
        int i = 0;
        for (c = 0; i < this.numBytes && c < start; i += UTF8String.numBytesForFirstByte(this.getByte(i)), ++c) {
        }
        int j = i;
        if (until == Integer.MAX_VALUE) {
            i = this.numBytes;
        } else {
            while (i < this.numBytes && c < until) {
                i += UTF8String.numBytesForFirstByte(this.getByte(i));
                ++c;
            }
        }
        if (i > j) {
            byte[] bytes = new byte[i - j];
            Platform.copyMemory(this.base, this.offset + (long)j, bytes, Platform.BYTE_ARRAY_OFFSET, i - j);
            return UTF8String.fromBytes(bytes);
        }
        return EMPTY_UTF8;
    }

    public UTF8String substringSQL(int pos, int length) {
        int start;
        int n = pos > 0 ? pos - 1 : (start = pos < 0 ? this.numChars() + pos : 0);
        int end = (long)start + (long)length > Integer.MAX_VALUE ? Integer.MAX_VALUE : ((long)start + (long)length < Integer.MIN_VALUE ? Integer.MIN_VALUE : start + length);
        return this.substring(start, end);
    }

    public boolean contains(UTF8String substring) {
        if (substring.numBytes == 0) {
            return true;
        }
        byte first = substring.getByte(0);
        for (int i = 0; i <= this.numBytes - substring.numBytes; ++i) {
            if (this.getByte(i) != first || !this.matchAt(substring, i)) continue;
            return true;
        }
        return false;
    }

    public byte getByte(int byteIndex) {
        return Platform.getByte(this.base, this.offset + (long)byteIndex);
    }

    public int getChar(int charIndex) {
        if (charIndex < 0 || charIndex >= this.numChars()) {
            throw new IndexOutOfBoundsException();
        }
        int byteCount = 0;
        for (int charCount = 0; charCount < charIndex; ++charCount) {
            byteCount += UTF8String.numBytesForFirstByte(this.getByte(byteCount));
        }
        return this.codePointFrom(byteCount);
    }

    public int codePointFrom(int byteIndex) {
        if (byteIndex < 0 || byteIndex >= this.numBytes) {
            throw new IndexOutOfBoundsException();
        }
        byte b = this.getByte(byteIndex);
        int numBytes = UTF8String.numBytesForFirstByte(b);
        return switch (numBytes) {
            case 1 -> b & 0x7F;
            case 2 -> (b & 0x1F) << 6 | this.getByte(byteIndex + 1) & 0x3F;
            case 3 -> (b & 0xF) << 12 | (this.getByte(byteIndex + 1) & 0x3F) << 6 | this.getByte(byteIndex + 2) & 0x3F;
            case 4 -> (b & 7) << 18 | (this.getByte(byteIndex + 1) & 0x3F) << 12 | (this.getByte(byteIndex + 2) & 0x3F) << 6 | this.getByte(byteIndex + 3) & 0x3F;
            default -> throw new IllegalStateException("Error in UTF-8 code point");
        };
    }

    public boolean matchAt(UTF8String s, int pos) {
        if (s.numBytes + pos > this.numBytes || pos < 0) {
            return false;
        }
        return ByteArrayMethods.arrayEquals(this.base, this.offset + (long)pos, s.base, s.offset, s.numBytes);
    }

    public boolean startsWith(UTF8String prefix) {
        return this.matchAt(prefix, 0);
    }

    public boolean endsWith(UTF8String suffix) {
        return this.matchAt(suffix, this.numBytes - suffix.numBytes);
    }

    private UTF8String convertAscii(Function<Character, Character> charConverter) {
        byte[] bytes = new byte[this.numBytes];
        for (int i = 0; i < this.numBytes; ++i) {
            bytes[i] = (byte)charConverter.apply(Character.valueOf((char)this.getByte(i))).charValue();
        }
        return UTF8String.fromBytes(bytes);
    }

    public UTF8String toUpperCase() {
        if (this.numBytes == 0) {
            return EMPTY_UTF8;
        }
        return this.isFullAscii() ? this.toUpperCaseAscii() : this.toUpperCaseSlow();
    }

    public UTF8String toUpperCaseAscii() {
        return this.convertAscii(Character::toUpperCase);
    }

    private UTF8String toUpperCaseSlow() {
        return UTF8String.fromString(this.toString().toUpperCase());
    }

    public UTF8String toLowerCase() {
        if (this.numBytes == 0) {
            return EMPTY_UTF8;
        }
        return this.isFullAscii() ? this.toLowerCaseAscii() : this.toLowerCaseSlow();
    }

    public boolean isFullAscii() {
        if (this.isFullAscii == IsFullAscii.UNKNOWN) {
            this.isFullAscii = this.getIsFullAscii();
        }
        return this.isFullAscii == IsFullAscii.FULL_ASCII;
    }

    private IsFullAscii getIsFullAscii() {
        for (int i = 0; i < this.numBytes; ++i) {
            if (this.getByte(i) >= 0) continue;
            return IsFullAscii.NOT_ASCII;
        }
        return IsFullAscii.FULL_ASCII;
    }

    private UTF8String toLowerCaseSlow() {
        return UTF8String.fromString(this.toString().toLowerCase());
    }

    public UTF8String toLowerCaseAscii() {
        return this.convertAscii(Character::toLowerCase);
    }

    public UTF8String toTitleCase() {
        if (this.numBytes == 0) {
            return EMPTY_UTF8;
        }
        return this.isFullAscii() ? this.toTitleCaseAscii() : this.toTitleCaseSlow();
    }

    public UTF8String toTitleCaseICU() {
        if (this.numBytes == 0) {
            return EMPTY_UTF8;
        }
        return this.isFullAscii() ? this.toTitleCaseAscii() : this.toTitleCaseSlowICU();
    }

    private UTF8String toTitleCaseAscii() {
        byte[] bytes = new byte[this.numBytes];
        int prev = 32;
        for (int i = 0; i < this.numBytes; ++i) {
            byte curr = this.getByte(i);
            bytes[i] = prev == 32 ? (byte)Character.toTitleCase(curr) : curr;
            prev = curr;
        }
        return UTF8String.fromBytes(bytes);
    }

    private UTF8String toTitleCaseSlow() {
        StringBuilder sb = new StringBuilder();
        String s = this.toString();
        sb.append(s);
        sb.setCharAt(0, Character.toTitleCase(sb.charAt(0)));
        for (int i = 1; i < s.length(); ++i) {
            if (sb.charAt(i - 1) != ' ') continue;
            sb.setCharAt(i, Character.toTitleCase(sb.charAt(i)));
        }
        return UTF8String.fromString(sb.toString());
    }

    private UTF8String toTitleCaseSlowICU() {
        StringBuilder sb = new StringBuilder();
        String s = this.toString();
        sb.append(s);
        sb.setCharAt(0, (char)UCharacter.toTitleCase((int)sb.charAt(0)));
        for (int i = 1; i < s.length(); ++i) {
            if (sb.charAt(i - 1) != ' ') continue;
            sb.setCharAt(i, (char)UCharacter.toTitleCase((int)sb.charAt(i)));
        }
        return UTF8String.fromString(sb.toString());
    }

    public int findInSet(UTF8String match) {
        if (match.contains(COMMA_UTF8)) {
            return 0;
        }
        int n = 1;
        int lastComma = -1;
        for (int i = 0; i < this.numBytes; ++i) {
            if (this.getByte(i) != 44) continue;
            if (i - (lastComma + 1) == match.numBytes && ByteArrayMethods.arrayEquals(this.base, this.offset + (long)(lastComma + 1), match.base, match.offset, match.numBytes)) {
                return n;
            }
            lastComma = i;
            ++n;
        }
        if (this.numBytes - (lastComma + 1) == match.numBytes && ByteArrayMethods.arrayEquals(this.base, this.offset + (long)(lastComma + 1), match.base, match.offset, match.numBytes)) {
            return n;
        }
        return 0;
    }

    public UTF8String copyUTF8String(int start, int end) {
        int len = end - start + 1;
        byte[] newBytes = new byte[len];
        Platform.copyMemory(this.base, this.offset + (long)start, newBytes, Platform.BYTE_ARRAY_OFFSET, len);
        return UTF8String.fromBytes(newBytes);
    }

    public UTF8String trim() {
        int e;
        int s;
        for (s = 0; s < this.numBytes && this.getByte(s) == 32; ++s) {
        }
        if (s == this.numBytes) {
            return EMPTY_UTF8;
        }
        for (e = this.numBytes - 1; e > s && this.getByte(e) == 32; --e) {
        }
        if (s == 0 && e == this.numBytes - 1) {
            return this;
        }
        return this.copyUTF8String(s, e);
    }

    public UTF8String trimAll() {
        int e;
        int s;
        for (s = 0; s < this.numBytes && UTF8String.isWhitespaceOrISOControl(this.getByte(s)); ++s) {
        }
        if (s == this.numBytes) {
            return EMPTY_UTF8;
        }
        for (e = this.numBytes - 1; e > s && UTF8String.isWhitespaceOrISOControl(this.getByte(e)); --e) {
        }
        if (s == 0 && e == this.numBytes - 1) {
            return this;
        }
        return this.copyUTF8String(s, e);
    }

    public UTF8String trim(UTF8String trimString) {
        if (trimString != null) {
            return this.trimLeft(trimString).trimRight(trimString);
        }
        return null;
    }

    public UTF8String trimLeft() {
        int s;
        for (s = 0; s < this.numBytes && this.getByte(s) == 32; ++s) {
        }
        if (s == 0) {
            return this;
        }
        if (s == this.numBytes) {
            return EMPTY_UTF8;
        }
        return this.copyUTF8String(s, this.numBytes - 1);
    }

    public UTF8String trimLeft(UTF8String trimString) {
        int searchIdx;
        int searchCharBytes;
        if (trimString == null) {
            return null;
        }
        int trimIdx = 0;
        for (searchIdx = 0; searchIdx < this.numBytes; searchIdx += searchCharBytes) {
            UTF8String searchChar = this.copyUTF8String(searchIdx, searchIdx + UTF8String.numBytesForFirstByte(this.getByte(searchIdx)) - 1);
            searchCharBytes = searchChar.numBytes;
            if (trimString.find(searchChar, 0) < 0) break;
            trimIdx += searchCharBytes;
        }
        if (searchIdx == 0) {
            return this;
        }
        if (trimIdx >= this.numBytes) {
            return EMPTY_UTF8;
        }
        return this.copyUTF8String(trimIdx, this.numBytes - 1);
    }

    public UTF8String trimRight() {
        int e;
        for (e = this.numBytes - 1; e >= 0 && this.getByte(e) == 32; --e) {
        }
        if (e == this.numBytes - 1) {
            return this;
        }
        if (e < 0) {
            return EMPTY_UTF8;
        }
        return this.copyUTF8String(0, e);
    }

    public UTF8String trimTrailingSpaces(int numSpaces) {
        int endIdx;
        assert (numSpaces > 0);
        int trimTo = this.numBytes - numSpaces;
        for (endIdx = this.numBytes - 1; endIdx >= trimTo && this.getByte(endIdx) == 32; --endIdx) {
        }
        return this.copyUTF8String(0, endIdx);
    }

    public UTF8String trimRight(UTF8String trimString) {
        UTF8String searchChar;
        if (trimString == null) {
            return null;
        }
        int charIdx = 0;
        int numChars = 0;
        int[] stringCharLen = new int[this.numBytes];
        int[] stringCharPos = new int[this.numBytes];
        while (charIdx < this.numBytes) {
            stringCharPos[numChars] = charIdx;
            stringCharLen[numChars] = UTF8String.numBytesForFirstByte(this.getByte(charIdx));
            charIdx += stringCharLen[numChars];
            ++numChars;
        }
        int trimEnd = this.numBytes - 1;
        while (numChars > 0 && trimString.find(searchChar = this.copyUTF8String(stringCharPos[numChars - 1], stringCharPos[numChars - 1] + stringCharLen[numChars - 1] - 1), 0) >= 0) {
            trimEnd -= stringCharLen[numChars - 1];
            --numChars;
        }
        if (trimEnd == this.numBytes - 1) {
            return this;
        }
        if (trimEnd < 0) {
            return EMPTY_UTF8;
        }
        return this.copyUTF8String(0, trimEnd);
    }

    public UTF8String reverse() {
        int len;
        byte[] result = new byte[this.numBytes];
        for (int i = 0; i < this.numBytes; i += len) {
            len = UTF8String.numBytesForFirstByte(this.getByte(i));
            Platform.copyMemory(this.base, this.offset + (long)i, result, Platform.BYTE_ARRAY_OFFSET + result.length - i - len, len);
        }
        return UTF8String.fromBytes(result);
    }

    public UTF8String repeat(int times) {
        int toCopy;
        if (times <= 0 || this.numBytes == 0) {
            return EMPTY_UTF8;
        }
        if (times == 1) {
            return this;
        }
        if (this.numBytes == 1) {
            byte[] newBytes = new byte[times];
            byte b = this.getByte(0);
            Arrays.fill(newBytes, b);
            return UTF8String.fromBytes(newBytes);
        }
        byte[] newBytes = new byte[Math.multiplyExact(this.numBytes, times)];
        Platform.copyMemory(this.base, this.offset, newBytes, Platform.BYTE_ARRAY_OFFSET, this.numBytes);
        for (int copied = 1; copied < times; copied += toCopy) {
            toCopy = Math.min(copied, times - copied);
            System.arraycopy(newBytes, 0, newBytes, copied * this.numBytes, this.numBytes * toCopy);
        }
        return UTF8String.fromBytes(newBytes);
    }

    public int indexOfEmpty(int start) {
        return 0;
    }

    public int indexOf(UTF8String v, int start) {
        int c;
        if (v.numBytes() == 0) {
            return this.indexOfEmpty(start);
        }
        int i = 0;
        for (c = 0; i < this.numBytes && c < start; i += UTF8String.numBytesForFirstByte(this.getByte(i)), ++c) {
        }
        do {
            if (i + v.numBytes > this.numBytes) {
                return -1;
            }
            if (ByteArrayMethods.arrayEquals(this.base, this.offset + (long)i, v.base, v.offset, v.numBytes)) {
                return c;
            }
            i += UTF8String.numBytesForFirstByte(this.getByte(i));
            ++c;
        } while (i < this.numBytes);
        return -1;
    }

    public int charPosToByte(int charPos) {
        if (charPos < 0) {
            return -1;
        }
        int i = 0;
        for (int c = 0; i < this.numBytes && c < charPos; i += UTF8String.numBytesForFirstByte(this.getByte(i)), ++c) {
        }
        return i;
    }

    public int bytePosToChar(int bytePos) {
        int i = 0;
        int c = 0;
        while (i < this.numBytes && i < bytePos) {
            i += UTF8String.numBytesForFirstByte(this.getByte(i));
            ++c;
        }
        return c;
    }

    public int find(UTF8String str, int start) {
        assert (str.numBytes > 0);
        while (start <= this.numBytes - str.numBytes) {
            if (ByteArrayMethods.arrayEquals(this.base, this.offset + (long)start, str.base, str.offset, str.numBytes)) {
                return start;
            }
            ++start;
        }
        return -1;
    }

    public int rfind(UTF8String str, int start) {
        assert (str.numBytes > 0);
        while (start >= 0) {
            if (ByteArrayMethods.arrayEquals(this.base, this.offset + (long)start, str.base, str.offset, str.numBytes)) {
                return start;
            }
            --start;
        }
        return -1;
    }

    public UTF8String subStringIndex(UTF8String delim, int count) {
        if (delim.numBytes == 0 || count == 0) {
            return EMPTY_UTF8;
        }
        if (count > 0) {
            int idx = -1;
            while (count > 0) {
                if ((idx = this.find(delim, idx + 1)) >= 0) {
                    --count;
                    continue;
                }
                return this;
            }
            if (idx == 0) {
                return EMPTY_UTF8;
            }
            byte[] bytes = new byte[idx];
            Platform.copyMemory(this.base, this.offset, bytes, Platform.BYTE_ARRAY_OFFSET, idx);
            return UTF8String.fromBytes(bytes);
        }
        int idx = this.numBytes - delim.numBytes + 1;
        for (count = -count; count > 0; --count) {
            if ((idx = this.rfind(delim, idx - 1)) >= 0) {
                continue;
            }
            return this;
        }
        if (idx + delim.numBytes == this.numBytes) {
            return EMPTY_UTF8;
        }
        int size = this.numBytes - delim.numBytes - idx;
        byte[] bytes = new byte[size];
        Platform.copyMemory(this.base, this.offset + (long)idx + (long)delim.numBytes, bytes, Platform.BYTE_ARRAY_OFFSET, size);
        return UTF8String.fromBytes(bytes);
    }

    public UTF8String rpad(int len, UTF8String pad) {
        int spaces = len - this.numChars();
        if (spaces <= 0 || pad.numBytes() == 0) {
            return this.substring(0, len);
        }
        int padChars = pad.numChars();
        int count = spaces / padChars;
        UTF8String remain = pad.substring(0, spaces - padChars * count);
        int resultSize = Math.toIntExact((long)this.numBytes + (long)pad.numBytes * (long)count + (long)remain.numBytes);
        byte[] data = new byte[resultSize];
        Platform.copyMemory(this.base, this.offset, data, Platform.BYTE_ARRAY_OFFSET, this.numBytes);
        int offset = this.numBytes;
        int idx = 0;
        while (idx < count) {
            Platform.copyMemory(pad.base, pad.offset, data, Platform.BYTE_ARRAY_OFFSET + offset, pad.numBytes);
            ++idx;
            offset += pad.numBytes;
        }
        Platform.copyMemory(remain.base, remain.offset, data, Platform.BYTE_ARRAY_OFFSET + offset, remain.numBytes);
        return UTF8String.fromBytes(data);
    }

    public UTF8String lpad(int len, UTF8String pad) {
        int spaces = len - this.numChars();
        if (spaces <= 0 || pad.numBytes() == 0) {
            return this.substring(0, len);
        }
        int padChars = pad.numChars();
        int count = spaces / padChars;
        UTF8String remain = pad.substring(0, spaces - padChars * count);
        int resultSize = Math.toIntExact((long)this.numBytes + (long)pad.numBytes * (long)count + (long)remain.numBytes);
        byte[] data = new byte[resultSize];
        int offset = 0;
        int idx = 0;
        while (idx < count) {
            Platform.copyMemory(pad.base, pad.offset, data, Platform.BYTE_ARRAY_OFFSET + offset, pad.numBytes);
            ++idx;
            offset += pad.numBytes;
        }
        Platform.copyMemory(remain.base, remain.offset, data, Platform.BYTE_ARRAY_OFFSET + offset, remain.numBytes);
        Platform.copyMemory(this.base, this.offset, data, Platform.BYTE_ARRAY_OFFSET + (offset += remain.numBytes), this.numBytes());
        return UTF8String.fromBytes(data);
    }

    public static UTF8String concat(UTF8String ... inputs) {
        long totalLength = 0L;
        for (UTF8String input : inputs) {
            if (input == null) {
                return null;
            }
            totalLength += (long)input.numBytes;
        }
        byte[] result = new byte[Math.toIntExact(totalLength)];
        int offset = 0;
        for (UTF8String input : inputs) {
            int len = input.numBytes;
            Platform.copyMemory(input.base, input.offset, result, Platform.BYTE_ARRAY_OFFSET + offset, len);
            offset += len;
        }
        return UTF8String.fromBytes(result);
    }

    public static UTF8String concatWs(UTF8String separator, UTF8String ... inputs) {
        if (separator == null) {
            return null;
        }
        long numInputBytes = 0L;
        int numInputs = 0;
        for (UTF8String input : inputs) {
            if (input == null) continue;
            numInputBytes += (long)input.numBytes;
            ++numInputs;
        }
        if (numInputs == 0) {
            return EMPTY_UTF8;
        }
        int resultSize = Math.toIntExact(numInputBytes + (long)(numInputs - 1) * (long)separator.numBytes);
        byte[] result = new byte[resultSize];
        int offset = 0;
        int j = 0;
        for (int i = 0; i < inputs.length; ++i) {
            if (inputs[i] == null) continue;
            int len = inputs[i].numBytes;
            Platform.copyMemory(inputs[i].base, inputs[i].offset, result, Platform.BYTE_ARRAY_OFFSET + offset, len);
            offset += len;
            if (++j >= numInputs) continue;
            Platform.copyMemory(separator.base, separator.offset, result, Platform.BYTE_ARRAY_OFFSET + offset, separator.numBytes);
            offset += separator.numBytes;
        }
        return UTF8String.fromBytes(result);
    }

    public UTF8String[] split(UTF8String pattern, int limit) {
        if (this.numBytes() != 0 && pattern.numBytes() == 0) {
            int newLimit = limit > this.numChars() || limit <= 0 ? this.numChars() : limit;
            byte[] input = this.getBytes();
            int byteIndex = 0;
            UTF8String[] result = new UTF8String[newLimit];
            for (int charIndex = 0; charIndex < newLimit - 1; ++charIndex) {
                int currCharNumBytes = UTF8String.numBytesForFirstByte(input[byteIndex]);
                result[charIndex] = UTF8String.fromBytes(input, byteIndex, currCharNumBytes);
                byteIndex += currCharNumBytes;
            }
            result[newLimit - 1] = UTF8String.fromBytes(input, byteIndex, this.numBytes() - byteIndex);
            return result;
        }
        return this.split(pattern.toString(), limit);
    }

    public UTF8String[] splitLegacyTruncate(UTF8String pattern, int limit) {
        if (this.numBytes() != 0 && pattern.numBytes() == 0) {
            int newLimit = limit > this.numChars() || limit <= 0 ? this.numChars() : limit;
            byte[] input = this.getBytes();
            int byteIndex = 0;
            int charIndex = 0;
            UTF8String[] result = new UTF8String[newLimit];
            while (charIndex < newLimit) {
                int currCharNumBytes = UTF8String.numBytesForFirstByte(input[byteIndex]);
                result[charIndex++] = UTF8String.fromBytes(input, byteIndex, currCharNumBytes);
                byteIndex += currCharNumBytes;
            }
            return result;
        }
        return this.split(pattern.toString(), limit);
    }

    public UTF8String[] splitSQL(UTF8String delimiter, int limit) {
        if (delimiter.numBytes() == 0) {
            return new UTF8String[]{this};
        }
        return this.split(Pattern.quote(delimiter.toString()), limit);
    }

    private UTF8String[] split(String delimiter, int limit) {
        if (limit == 0) {
            limit = -1;
        }
        String[] splits = this.toString().split(delimiter, limit);
        UTF8String[] res = new UTF8String[splits.length];
        for (int i = 0; i < res.length; ++i) {
            res[i] = UTF8String.fromString(splits[i]);
        }
        return res;
    }

    public UTF8String replace(UTF8String search, UTF8String replace) {
        if (this.numBytes == 0 || search.numBytes == 0) {
            return this;
        }
        int start = 0;
        int end = this.find(search, start);
        if (end == -1) {
            return this;
        }
        int increase = Math.max(0, replace.numBytes - search.numBytes) * 16;
        UTF8StringBuilder buf = new UTF8StringBuilder(this.numBytes + increase);
        while (end != -1) {
            buf.appendBytes(this.base, this.offset + (long)start, end - start);
            buf.append(replace);
            start = end + search.numBytes;
            end = this.find(search, start);
        }
        buf.appendBytes(this.base, this.offset + (long)start, this.numBytes - start);
        return buf.build();
    }

    public UTF8String translate(Map<String, String> dict) {
        String srcStr = this.toString();
        StringBuilder sb = new StringBuilder();
        int charCount = 0;
        for (int k = 0; k < srcStr.length(); k += charCount) {
            int codePoint = srcStr.codePointAt(k);
            charCount = Character.charCount(codePoint);
            String subStr = srcStr.substring(k, k + charCount);
            String translated = dict.get(subStr);
            if (null == translated) {
                sb.append(subStr);
                continue;
            }
            if ("\u0000".equals(translated)) continue;
            sb.append(translated);
        }
        return UTF8String.fromString(sb.toString());
    }

    public boolean toLong(LongWrapper toLongResult) {
        return this.toLong(toLongResult, true);
    }

    private boolean toLong(LongWrapper toLongResult, boolean allowDecimal) {
        boolean negative;
        int end;
        int offset;
        for (offset = 0; offset < this.numBytes && UTF8String.isWhitespaceOrISOControl(this.getByte(offset)); ++offset) {
        }
        if (offset == this.numBytes) {
            return false;
        }
        for (end = this.numBytes - 1; end > offset && UTF8String.isWhitespaceOrISOControl(this.getByte(end)); --end) {
        }
        byte b = this.getByte(offset);
        boolean bl = negative = b == 45;
        if (negative || b == 43) {
            if (end - offset == 0) {
                return false;
            }
            ++offset;
        }
        int separator = 46;
        int radix = 10;
        long stopValue = -922337203685477580L;
        long result = 0L;
        while (offset <= end) {
            b = this.getByte(offset);
            ++offset;
            if (b == 46 && allowDecimal) break;
            if (b < 48 || b > 57) {
                return false;
            }
            int digit = b - 48;
            if (result < -922337203685477580L) {
                return false;
            }
            if ((result = result * 10L - (long)digit) <= 0L) continue;
            return false;
        }
        while (offset <= end) {
            byte currentByte = this.getByte(offset);
            if (currentByte < 48 || currentByte > 57) {
                return false;
            }
            ++offset;
        }
        if (!negative && (result = -result) < 0L) {
            return false;
        }
        toLongResult.value = result;
        return true;
    }

    public boolean toInt(IntWrapper intWrapper) {
        return this.toInt(intWrapper, true);
    }

    private boolean toInt(IntWrapper intWrapper, boolean allowDecimal) {
        boolean negative;
        int end;
        int offset;
        for (offset = 0; offset < this.numBytes && UTF8String.isWhitespaceOrISOControl(this.getByte(offset)); ++offset) {
        }
        if (offset == this.numBytes) {
            return false;
        }
        for (end = this.numBytes - 1; end > offset && UTF8String.isWhitespaceOrISOControl(this.getByte(end)); --end) {
        }
        byte b = this.getByte(offset);
        boolean bl = negative = b == 45;
        if (negative || b == 43) {
            if (end - offset == 0) {
                return false;
            }
            ++offset;
        }
        int separator = 46;
        int radix = 10;
        int stopValue = -214748364;
        int result = 0;
        while (offset <= end) {
            b = this.getByte(offset);
            ++offset;
            if (b == 46 && allowDecimal) break;
            if (b < 48 || b > 57) {
                return false;
            }
            int digit = b - 48;
            if (result < -214748364) {
                return false;
            }
            if ((result = result * 10 - digit) <= 0) continue;
            return false;
        }
        while (offset <= end) {
            byte currentByte = this.getByte(offset);
            if (currentByte < 48 || currentByte > 57) {
                return false;
            }
            ++offset;
        }
        if (!negative && (result = -result) < 0) {
            return false;
        }
        intWrapper.value = result;
        return true;
    }

    public boolean toShort(IntWrapper intWrapper) {
        if (this.toInt(intWrapper)) {
            int intValue = intWrapper.value;
            short result = (short)intValue;
            return result == intValue;
        }
        return false;
    }

    public boolean toByte(IntWrapper intWrapper) {
        if (this.toInt(intWrapper)) {
            int intValue = intWrapper.value;
            byte result = (byte)intValue;
            return result == intValue;
        }
        return false;
    }

    public long toLongExact() {
        LongWrapper result = new LongWrapper();
        if (this.toLong(result, false)) {
            return result.value;
        }
        throw new NumberFormatException("invalid input syntax for type numeric: '" + String.valueOf(this) + "'");
    }

    public int toIntExact() {
        IntWrapper result = new IntWrapper();
        if (this.toInt(result, false)) {
            return result.value;
        }
        throw new NumberFormatException("invalid input syntax for type numeric: '" + String.valueOf(this) + "'");
    }

    public short toShortExact() {
        int value = this.toIntExact();
        short result = (short)value;
        if (result == value) {
            return result;
        }
        throw new NumberFormatException("invalid input syntax for type numeric: '" + String.valueOf(this) + "'");
    }

    public byte toByteExact() {
        int value = this.toIntExact();
        byte result = (byte)value;
        if (result == value) {
            return result;
        }
        throw new NumberFormatException("invalid input syntax for type numeric: '" + String.valueOf(this) + "'");
    }

    public String toString() {
        return new String(this.getBytes(), StandardCharsets.UTF_8);
    }

    public String toValidString() {
        if (this.isValid()) {
            return this.toString();
        }
        return new String(this.makeValidBytes(), StandardCharsets.UTF_8);
    }

    public UTF8String clone() {
        return UTF8String.fromBytes(this.getBytes());
    }

    public UTF8String copy() {
        byte[] bytes = new byte[this.numBytes];
        Platform.copyMemory(this.base, this.offset, bytes, Platform.BYTE_ARRAY_OFFSET, this.numBytes);
        return UTF8String.fromBytes(bytes);
    }

    @Override
    public int compareTo(@Nonnull UTF8String other) {
        if (SparkEnvUtils$.MODULE$.isTesting()) {
            throw new UnsupportedOperationException("compareTo should not be used in spark code base. Use binaryCompare or semanticCompare.");
        }
        return this.binaryCompare(other);
    }

    public int binaryCompare(UTF8String other) {
        return ByteArray.compareBinary(this.base, this.offset, this.numBytes, other.base, other.offset, other.numBytes);
    }

    public int semanticCompare(UTF8String other, int collationId) {
        return CollationFactory.fetchCollation((int)collationId).comparator.compare(this, other);
    }

    public boolean equals(Object other) {
        if (other instanceof UTF8String) {
            UTF8String o = (UTF8String)other;
            return this.binaryEquals(o);
        }
        return false;
    }

    public boolean binaryEquals(UTF8String other) {
        if (this.numBytes != other.numBytes) {
            return false;
        }
        return ByteArrayMethods.arrayEquals(this.base, this.offset, other.base, other.offset, this.numBytes);
    }

    public boolean semanticEquals(UTF8String other, int collationId) {
        return CollationFactory.fetchCollation((int)collationId).equalsFunction.apply(this, other);
    }

    public int levenshteinDistance(UTF8String other) {
        int i;
        UTF8String t;
        UTF8String s;
        int n = this.numChars();
        int m = other.numChars();
        if (n == 0) {
            return m;
        }
        if (m == 0) {
            return n;
        }
        if (n <= m) {
            s = this;
            t = other;
        } else {
            s = other;
            t = this;
            int swap = n;
            n = m;
            m = swap;
        }
        int[] p = new int[n + 1];
        int[] d = new int[n + 1];
        for (i = 0; i <= n; ++i) {
            p[i] = i;
        }
        int j_bytes = 0;
        for (int j = 0; j < m; ++j) {
            int num_bytes_j = UTF8String.numBytesForFirstByte(t.getByte(j_bytes));
            d[0] = j + 1;
            int i_bytes = 0;
            for (i = 0; i < n; ++i) {
                int cost = s.getByte(i_bytes) != t.getByte(j_bytes) || num_bytes_j != UTF8String.numBytesForFirstByte(s.getByte(i_bytes)) ? 1 : (ByteArrayMethods.arrayEquals(t.base, t.offset + (long)j_bytes, s.base, s.offset + (long)i_bytes, num_bytes_j) ? 0 : 1);
                d[i + 1] = Math.min(Math.min(d[i] + 1, p[i + 1] + 1), p[i] + cost);
                i_bytes += UTF8String.numBytesForFirstByte(s.getByte(i_bytes));
            }
            int[] swap = p;
            p = d;
            d = swap;
            j_bytes += num_bytes_j;
        }
        return p[n];
    }

    public int levenshteinDistance(UTF8String other, int threshold) {
        int i;
        UTF8String t;
        UTF8String s;
        int n = this.numChars();
        int m = other.numChars();
        if (n == 0) {
            return m <= threshold ? m : -1;
        }
        if (m == 0) {
            return n <= threshold ? n : -1;
        }
        if (n <= m) {
            s = this;
            t = other;
        } else {
            s = other;
            t = this;
            int swap = n;
            n = m;
            m = swap;
        }
        if (m - n > threshold) {
            return -1;
        }
        int[] p = new int[n + 1];
        int[] d = new int[n + 1];
        int boundary = Math.min(n, threshold) + 1;
        for (i = 0; i < boundary; ++i) {
            p[i] = i;
        }
        Arrays.fill(p, boundary, p.length, Integer.MAX_VALUE);
        Arrays.fill(d, Integer.MAX_VALUE);
        int j_bytes = 0;
        for (int j = 0; j < m; ++j) {
            int max;
            int num_bytes_j = UTF8String.numBytesForFirstByte(t.getByte(j_bytes));
            d[0] = j + 1;
            int min = Math.max(1, j + 1 - threshold);
            int n2 = max = j + 1 > Integer.MAX_VALUE - threshold ? n : Math.min(n, j + 1 + threshold);
            if (min > 1) {
                d[min - 1] = Integer.MAX_VALUE;
            }
            int lowerBound = Integer.MAX_VALUE;
            int i_bytes = 0;
            for (i = 0; i <= max; ++i) {
                int num_bytes_i;
                if (i < min - 1) {
                    num_bytes_i = UTF8String.numBytesForFirstByte(s.getByte(i_bytes));
                } else if (i == min - 1) {
                    num_bytes_i = 0;
                } else {
                    d[i] = ByteArrayMethods.arrayEquals(t.base, t.offset + (long)j_bytes, s.base, s.offset + (long)i_bytes, num_bytes_j) ? p[i - 1] : 1 + Math.min(Math.min(d[i - 1], p[i]), p[i - 1]);
                    lowerBound = Math.min(lowerBound, d[i]);
                    num_bytes_i = UTF8String.numBytesForFirstByte(s.getByte(i_bytes));
                }
                i_bytes += num_bytes_i;
            }
            if (lowerBound > threshold) {
                return -1;
            }
            int[] swap = p;
            p = d;
            d = swap;
            j_bytes += num_bytes_j;
        }
        if (p[n] <= threshold) {
            return p[n];
        }
        return -1;
    }

    public int hashCode() {
        return Murmur3_x86_32.hashUnsafeBytes(this.base, this.offset, this.numBytes, 42);
    }

    public UTF8String soundex() {
        if (this.numBytes == 0) {
            return EMPTY_UTF8;
        }
        byte b = this.getByte(0);
        if (97 <= b && b <= 122) {
            b = (byte)(b - 32);
        } else if (b < 65 || 90 < b) {
            return this;
        }
        byte[] sx = new byte[]{48, 48, 48, 48};
        sx[0] = b;
        int sxi = 1;
        int idx = b - 65;
        int lastCode = US_ENGLISH_MAPPING[idx];
        for (int i = 1; i < this.numBytes; ++i) {
            b = this.getByte(i);
            if (97 <= b && b <= 122) {
                b = (byte)(b - 32);
            } else if (b < 65 || 90 < b) {
                lastCode = 48;
                continue;
            }
            idx = b - 65;
            int code = US_ENGLISH_MAPPING[idx];
            if (code == 55) continue;
            if (code != 48 && code != lastCode) {
                sx[sxi++] = code;
                if (sxi > 3) break;
            }
            lastCode = code;
        }
        return UTF8String.fromBytes(sx);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        byte[] bytes = this.getBytes();
        out.writeInt(bytes.length);
        out.write(bytes);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.offset = Platform.BYTE_ARRAY_OFFSET;
        this.numBytes = in.readInt();
        this.base = new byte[this.numBytes];
        in.readFully((byte[])this.base);
    }

    public void write(Kryo kryo, Output out) {
        byte[] bytes = this.getBytes();
        out.writeInt(bytes.length);
        out.write(bytes);
    }

    public void read(Kryo kryo, Input in) {
        this.offset = Platform.BYTE_ARRAY_OFFSET;
        this.numBytes = in.readInt();
        this.base = new byte[this.numBytes];
        in.read((byte[])this.base);
    }

    public static UTF8String toBinaryString(long val) {
        int zeros = Long.numberOfLeadingZeros(val);
        if (zeros == 64) {
            return ZERO_UTF8;
        }
        int length = 64 - zeros;
        byte[] bytes = new byte[length];
        do {
            bytes[--length] = (byte)((val & 1L) == 1L ? 49 : 48);
            val >>>= 1;
        } while (length > 0);
        return UTF8String.fromBytes(bytes);
    }

    private static enum UTF8StringValidity {
        UNKNOWN,
        IS_VALID,
        NOT_VALID;

    }

    private static enum IsFullAscii {
        UNKNOWN,
        FULL_ASCII,
        NOT_ASCII;

    }

    public static enum CodePointIteratorType {
        CODE_POINT_ITERATOR_ASSUME_VALID,
        CODE_POINT_ITERATOR_MAKE_VALID;

    }

    private class CodePointIterator
    implements Iterator<Integer> {
        private int byteIndex = 0;

        private CodePointIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.byteIndex < UTF8String.this.numBytes;
        }

        @Override
        public Integer next() {
            if (!this.hasNext()) {
                throw new IndexOutOfBoundsException();
            }
            int codePoint = UTF8String.this.codePointFrom(this.byteIndex);
            this.byteIndex += UTF8String.numBytesForFirstByte(UTF8String.this.getByte(this.byteIndex));
            return codePoint;
        }
    }

    private class ReverseCodePointIterator
    implements Iterator<Integer> {
        private int byteIndex;

        private ReverseCodePointIterator() {
            this.byteIndex = UTF8String.this.numBytes - 1;
        }

        @Override
        public boolean hasNext() {
            return this.byteIndex >= 0;
        }

        @Override
        public Integer next() {
            if (!this.hasNext()) {
                throw new IndexOutOfBoundsException();
            }
            while (this.byteIndex > 0 && this.isContinuationByte(UTF8String.this.getByte(this.byteIndex))) {
                --this.byteIndex;
            }
            return UTF8String.this.codePointFrom(this.byteIndex--);
        }

        private boolean isContinuationByte(byte b) {
            return (b & 0xC0) == 128;
        }
    }

    public static class LongWrapper
    implements Serializable {
        public transient long value = 0L;
    }

    public static class IntWrapper
    implements Serializable {
        public transient int value = 0;
    }
}

