/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedExpressions;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFDayOfMonthDate;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFDayOfMonthString;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFDayOfMonthTimestamp;
import org.apache.hadoop.hive.ql.udf.generic.NDV;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.hadoop.hive.serde2.io.HiveIntervalDayTimeWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;

@Description(name="day,dayofmonth", value="_FUNC_(param) - Returns the day of the month of date/timestamp, or day component of interval", extended="param can be one of:\n1. A string in the format of 'yyyy-MM-dd HH:mm:ss' or 'yyyy-MM-dd'.\n2. A date value\n3. A timestamp value\n4. A day-time interval valueExample:\n   > SELECT _FUNC_('2009-07-30') FROM src LIMIT 1;\n  30")
@VectorizedExpressions(value={VectorUDFDayOfMonthDate.class, VectorUDFDayOfMonthString.class, VectorUDFDayOfMonthTimestamp.class})
@NDV(maxNdv=31L)
public class UDFDayOfMonth
extends UDF {
    private final SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
    private final Calendar calendar = Calendar.getInstance();
    private final IntWritable result = new IntWritable();

    public IntWritable evaluate(Text dateString) {
        if (dateString == null) {
            return null;
        }
        try {
            Date date = this.formatter.parse(dateString.toString());
            this.calendar.setTime(date);
            this.result.set(this.calendar.get(5));
            return this.result;
        }
        catch (ParseException e) {
            return null;
        }
    }

    public IntWritable evaluate(DateWritable d) {
        if (d == null) {
            return null;
        }
        this.calendar.setTime(d.get(false));
        this.result.set(this.calendar.get(5));
        return this.result;
    }

    public IntWritable evaluate(TimestampWritable t) {
        if (t == null) {
            return null;
        }
        this.calendar.setTime(t.getTimestamp());
        this.result.set(this.calendar.get(5));
        return this.result;
    }

    public IntWritable evaluate(HiveIntervalDayTimeWritable i) {
        if (i == null) {
            return null;
        }
        this.result.set(i.getHiveIntervalDayTime().getDays());
        return this.result;
    }
}

