/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BitLength$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.internal.types.StringTypeWithCollation$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.TypeCollection$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Product;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(expr) - Returns the bit length of string data or number of bits of binary data.", examples="\n    Examples:\n      > SELECT _FUNC_('Spark SQL');\n       72\n      > SELECT _FUNC_(x'537061726b2053514c');\n       72\n  ", since="2.3.0", group="string_funcs")
@ScalaSignature(bytes="\u0006\u0005\u0005Ug\u0001\u0002\u000f\u001e\u0001*B\u0001\u0002\u0012\u0001\u0003\u0016\u0004%\t!\u0012\u0005\t\u0013\u0002\u0011\t\u0012)A\u0005\r\")!\n\u0001C\u0001\u0017\")a\n\u0001C!\u001f\")1\u000b\u0001C!)\")1\f\u0001C!9\")1\r\u0001C!\u001f\")A\r\u0001C)K\")1\u000e\u0001C!Y\")!\u0010\u0001C!w\"9\u0011\u0011\u0002\u0001\u0005R\u0005-\u0001\"CA\t\u0001\u0005\u0005I\u0011AA\n\u0011%\t9\u0002AI\u0001\n\u0003\tI\u0002C\u0005\u00020\u0001\t\t\u0011\"\u0011\u00022!I\u0011\u0011\t\u0001\u0002\u0002\u0013\u0005\u00111\t\u0005\n\u0003\u0017\u0002\u0011\u0011!C\u0001\u0003\u001bB\u0011\"a\u0015\u0001\u0003\u0003%\t%!\u0016\t\u0013\u0005\r\u0004!!A\u0005\u0002\u0005\u0015\u0004\"CA5\u0001\u0005\u0005I\u0011IA6\u0011%\ty\u0007AA\u0001\n\u0003\n\thB\u0005\u0002\u0016v\t\t\u0011#\u0001\u0002\u0018\u001aAA$HA\u0001\u0012\u0003\tI\n\u0003\u0004K-\u0011\u0005\u0011\u0011\u0017\u0005\n\u0003g3\u0012\u0011!C#\u0003kC\u0011\"a.\u0017\u0003\u0003%\t)!/\t\u0013\u0005uf#!A\u0005\u0002\u0006}\u0006\"CAf-\u0005\u0005I\u0011BAg\u0005%\u0011\u0015\u000e\u001e'f]\u001e$\bN\u0003\u0002\u001f?\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\t\u0001\u0013%\u0001\u0005dCR\fG._:u\u0015\t\u00113%A\u0002tc2T!\u0001J\u0013\u0002\u000bM\u0004\u0018M]6\u000b\u0005\u0019:\u0013AB1qC\u000eDWMC\u0001)\u0003\ry'oZ\u0002\u0001'\u0015\u00011f\f\u001a9!\taS&D\u0001\u001e\u0013\tqSDA\bV]\u0006\u0014\u00180\u0012=qe\u0016\u001c8/[8o!\ta\u0003'\u0003\u00022;\t1\u0012*\u001c9mS\u000eLGoQ1ti&s\u0007/\u001e;UsB,7\u000f\u0005\u00024m5\tAGC\u00016\u0003\u0015\u00198-\u00197b\u0013\t9DGA\u0004Qe>$Wo\u0019;\u0011\u0005e\neB\u0001\u001e@\u001d\tYd(D\u0001=\u0015\ti\u0014&\u0001\u0004=e>|GOP\u0005\u0002k%\u0011\u0001\tN\u0001\ba\u0006\u001c7.Y4f\u0013\t\u00115I\u0001\u0007TKJL\u0017\r\\5{C\ndWM\u0003\u0002Ai\u0005)1\r[5mIV\ta\t\u0005\u0002-\u000f&\u0011\u0001*\b\u0002\u000b\u000bb\u0004(/Z:tS>t\u0017AB2iS2$\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0003\u00196\u0003\"\u0001\f\u0001\t\u000b\u0011\u001b\u0001\u0019\u0001$\u0002\u001d9,H\u000e\\%oi>dWM]1oiV\t\u0001\u000b\u0005\u00024#&\u0011!\u000b\u000e\u0002\b\u0005>|G.Z1o\u0003!!\u0017\r^1UsB,W#A+\u0011\u0005YKV\"A,\u000b\u0005a\u000b\u0013!\u0002;za\u0016\u001c\u0018B\u0001.X\u0005!!\u0015\r^1UsB,\u0017AC5oaV$H+\u001f9fgV\tQ\fE\u0002:=\u0002L!aX\"\u0003\u0007M+\u0017\u000f\u0005\u0002WC&\u0011!m\u0016\u0002\u0011\u0003\n\u001cHO]1di\u0012\u000bG/\u0019+za\u0016\f!dY8oi\u0016DH/\u00138eKB,g\u000eZ3oi\u001a{G\u000eZ1cY\u0016\fAB\\;mYN\u000bg-Z#wC2$\"AZ5\u0011\u0005M:\u0017B\u000155\u0005\r\te.\u001f\u0005\u0006U\"\u0001\rAZ\u0001\u0006m\u0006dW/Z\u0001\nI><UM\\\"pI\u0016$2!\\:y!\tq\u0017/D\u0001p\u0015\t\u0001X$A\u0004d_\u0012,w-\u001a8\n\u0005I|'\u0001C#yaJ\u001cu\u000eZ3\t\u000bQL\u0001\u0019A;\u0002\u0007\r$\b\u0010\u0005\u0002om&\u0011qo\u001c\u0002\u000f\u0007>$WmZ3o\u0007>tG/\u001a=u\u0011\u0015I\u0018\u00021\u0001n\u0003\t)g/\u0001\u0006qe\u0016$H/\u001f(b[\u0016,\u0012\u0001 \t\u0004{\u0006\raB\u0001@\u0000!\tYD'C\u0002\u0002\u0002Q\na\u0001\u0015:fI\u00164\u0017\u0002BA\u0003\u0003\u000f\u0011aa\u0015;sS:<'bAA\u0001i\u0005!r/\u001b;i\u001d\u0016<8\t[5mI&sG/\u001a:oC2$2\u0001TA\u0007\u0011\u0019\tya\u0003a\u0001\r\u0006Aa.Z<DQ&dG-\u0001\u0003d_BLHc\u0001'\u0002\u0016!9A\t\u0004I\u0001\u0002\u00041\u0015AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u00037Q3ARA\u000fW\t\ty\u0002\u0005\u0003\u0002\"\u0005-RBAA\u0012\u0015\u0011\t)#a\n\u0002\u0013Ut7\r[3dW\u0016$'bAA\u0015i\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u00055\u00121\u0005\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u00024A!\u0011QGA \u001b\t\t9D\u0003\u0003\u0002:\u0005m\u0012\u0001\u00027b]\u001eT!!!\u0010\u0002\t)\fg/Y\u0005\u0005\u0003\u000b\t9$\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002FA\u00191'a\u0012\n\u0007\u0005%CGA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000fF\u0002g\u0003\u001fB\u0011\"!\u0015\u0011\u0003\u0003\u0005\r!!\u0012\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\t9\u0006E\u0003\u0002Z\u0005}c-\u0004\u0002\u0002\\)\u0019\u0011Q\f\u001b\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002b\u0005m#\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$2\u0001UA4\u0011!\t\tFEA\u0001\u0002\u00041\u0017A\u00059s_\u0012,8\r^#mK6,g\u000e\u001e(b[\u0016$B!a\r\u0002n!I\u0011\u0011K\n\u0002\u0002\u0003\u0007\u0011QI\u0001\u0007KF,\u0018\r\\:\u0015\u0007A\u000b\u0019\b\u0003\u0005\u0002RQ\t\t\u00111\u0001gQM\u0001\u0011qOA?\u0003\u007f\n\u0019)!\"\u0002\n\u0006-\u0015qRAI!\ra\u0013\u0011P\u0005\u0004\u0003wj\"!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u0003\u0003\u000bak\u0018$V\u001d\u000e{\u0006&\u001a=qe&\u0002S\u0006\t*fiV\u0014hn\u001d\u0011uQ\u0016\u0004#-\u001b;!Y\u0016tw\r\u001e5!_\u001a\u00043\u000f\u001e:j]\u001e\u0004C-\u0019;bA=\u0014\bE\\;nE\u0016\u0014\be\u001c4!E&$8\u000fI8gA\tLg.\u0019:zA\u0011\fG/\u0019\u0018\u0002\u0011\u0015D\u0018-\u001c9mKN\f#!a\"\u0002o*\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~Cse\u00159be.\u00043+\u0015'(SmR\u0001\u0005\t\u0011!A\u0001\u0002sG\r\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)q\u001e*4g\u000e\u00197c]\u0012dG\u0019\u001a1kM*\u0014\u0007N2(SmR\u0001\u0005\t\u0011!A\u0001\u0002sG\r\u0006!A\u0005)1/\u001b8dK\u0006\u0012\u0011QR\u0001\u0006e9\u001ad\u0006M\u0001\u0006OJ|W\u000f]\u0011\u0003\u0003'\u000bAb\u001d;sS:<wLZ;oGN\f\u0011BQ5u\u0019\u0016tw\r\u001e5\u0011\u0005122#\u0002\f\u0002\u001c\u0006\u001d\u0006CBAO\u0003G3E*\u0004\u0002\u0002 *\u0019\u0011\u0011\u0015\u001b\u0002\u000fI,h\u000e^5nK&!\u0011QUAP\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|g.\r\t\u0005\u0003S\u000by+\u0004\u0002\u0002,*!\u0011QVA\u001e\u0003\tIw.C\u0002C\u0003W#\"!a&\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!a\r\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u00071\u000bY\fC\u0003E3\u0001\u0007a)A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\u0005\u0005\u0017q\u0019\t\u0005g\u0005\rg)C\u0002\u0002FR\u0012aa\u00149uS>t\u0007\u0002CAe5\u0005\u0005\t\u0019\u0001'\u0002\u0007a$\u0003'\u0001\u0007xe&$XMU3qY\u0006\u001cW\r\u0006\u0002\u0002PB!\u0011QGAi\u0013\u0011\t\u0019.a\u000e\u0003\r=\u0013'.Z2u\u0001")
public class BitLength
extends UnaryExpression
implements ImplicitCastInputTypes,
Serializable {
    private final Expression child;

    public static Option<Expression> unapply(BitLength x$0) {
        return BitLength$.MODULE$.unapply(x$0);
    }

    public static <A> Function1<Expression, A> andThen(Function1<BitLength, A> g) {
        return BitLength$.MODULE$.andThen(g);
    }

    public static <A$> Function1<A$, BitLength> compose(Function1<A$, Expression> g) {
        return BitLength$.MODULE$.compose(g);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public boolean nullIntolerant() {
        return true;
    }

    @Override
    public DataType dataType() {
        return IntegerType$.MODULE$;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)TypeCollection$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{StringTypeWithCollation$.MODULE$.apply(true, StringTypeWithCollation$.MODULE$.apply$default$2(), StringTypeWithCollation$.MODULE$.apply$default$3()), BinaryType$.MODULE$})), (List)Nil$.MODULE$);
    }

    @Override
    public boolean contextIndependentFoldable() {
        return this.child().contextIndependentFoldable();
    }

    @Override
    public Object nullSafeEval(Object value) {
        DataType dataType = this.child().dataType();
        if (dataType instanceof StringType) {
            return BoxesRunTime.boxToInteger((int)(((UTF8String)value).numBytes() * 8));
        }
        if (BinaryType$.MODULE$.equals(dataType)) {
            return BoxesRunTime.boxToInteger((int)(((byte[])value).length * 8));
        }
        throw new MatchError((Object)dataType);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        DataType dataType = this.child().dataType();
        if (dataType instanceof StringType) {
            return this.defineCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable)c -> "(" + c + ").numBytes() * 8");
        }
        if (BinaryType$.MODULE$.equals(dataType)) {
            return this.defineCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable)c -> "(" + c + ").length * 8");
        }
        throw new MatchError((Object)dataType);
    }

    @Override
    public String prettyName() {
        return "bit_length";
    }

    @Override
    public BitLength withNewChildInternal(Expression newChild) {
        return this.copy(newChild);
    }

    public BitLength copy(Expression child) {
        return new BitLength(child);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    @Override
    public String productPrefix() {
        return "BitLength";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.child();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof BitLength;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "child";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof BitLength)) return false;
        boolean bl = true;
        if (!bl) return false;
        BitLength bitLength = (BitLength)x$1;
        Expression expression = this.child();
        Expression expression2 = bitLength.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!bitLength.canEqual(this)) return false;
        return true;
    }

    public BitLength(Expression child) {
        this.child = child;
        ExpectsInputTypes.$init$(this);
    }
}

