/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.spark.SparkIllegalArgumentException;
import org.sparkproject.guava.annotations.VisibleForTesting;

public class ExpressionInfo {
    private String className;
    private String usage;
    private String name;
    private String extended;
    private String db;
    private String arguments;
    private String examples;
    private String note;
    private String group;
    private String since;
    private String deprecated;
    private String source;
    private static final Set<String> validGroups = new HashSet<String>(Arrays.asList("agg_funcs", "array_funcs", "binary_funcs", "bitwise_funcs", "collection_funcs", "predicate_funcs", "conditional_funcs", "conversion_funcs", "csv_funcs", "datetime_funcs", "generator_funcs", "hash_funcs", "json_funcs", "lambda_funcs", "map_funcs", "math_funcs", "misc_funcs", "string_funcs", "struct_funcs", "window_funcs", "xml_funcs", "table_funcs", "url_funcs", "variant_funcs", "st_funcs"));
    private static final Set<String> validSources = new HashSet<String>(Arrays.asList("built-in", "hive", "python_udf", "scala_udf", "sql_udf", "java_udf", "python_udtf", "internal"));

    public String getClassName() {
        return this.className;
    }

    public String getUsage() {
        return this.replaceFunctionName(this.usage);
    }

    public String getName() {
        return this.name;
    }

    public String getExtended() {
        return this.replaceFunctionName(this.extended);
    }

    public String getSince() {
        return this.since;
    }

    public String getArguments() {
        return this.arguments;
    }

    @VisibleForTesting
    public String getOriginalExamples() {
        return this.examples;
    }

    public String getExamples() {
        return this.replaceFunctionName(this.examples);
    }

    public String getNote() {
        return this.note;
    }

    public String getDeprecated() {
        return this.deprecated;
    }

    public String getGroup() {
        return this.group;
    }

    public String getDb() {
        return this.db;
    }

    public String getSource() {
        return this.source;
    }

    public ExpressionInfo(String className, String db, String name, String usage, String arguments, String examples, String note, String group, String since, String deprecated, String source) {
        assert (name != null);
        assert (arguments != null);
        assert (examples != null);
        assert (examples.isEmpty() || examples.contains("    Examples:"));
        assert (note != null);
        assert (group != null);
        assert (since != null);
        assert (deprecated != null);
        assert (source != null);
        this.className = className;
        this.db = db;
        this.name = name;
        this.usage = usage;
        this.arguments = arguments;
        this.examples = examples;
        this.note = note;
        this.group = group;
        this.since = since;
        this.deprecated = deprecated;
        this.source = source;
        this.extended = arguments + examples;
        if (this.extended.isEmpty()) {
            this.extended = "\n    No example/argument for _FUNC_.\n";
        }
        if (!note.isEmpty()) {
            if (!note.contains("    ") || !note.endsWith("  ")) {
                throw new SparkIllegalArgumentException("_LEGACY_ERROR_TEMP_3201", Map.of("exprName", this.name, "note", note));
            }
            this.extended = this.extended + "\n    Note:\n      " + note.trim() + "\n";
        }
        if (!group.isEmpty() && !validGroups.contains(group)) {
            throw new SparkIllegalArgumentException("_LEGACY_ERROR_TEMP_3202", Map.of("exprName", this.name, "validGroups", String.valueOf(validGroups.stream().sorted().toList()), "group", group));
        }
        if (!source.isEmpty() && !validSources.contains(source)) {
            throw new SparkIllegalArgumentException("_LEGACY_ERROR_TEMP_3203", Map.of("exprName", this.name, "validSources", String.valueOf(validSources.stream().sorted().toList()), "source", source));
        }
        if (!since.isEmpty()) {
            if (Integer.parseInt(since.split("\\.")[0]) < 0) {
                throw new SparkIllegalArgumentException("_LEGACY_ERROR_TEMP_3204", Map.of("exprName", this.name, "since", since));
            }
            this.extended = this.extended + "\n    Since: " + since + "\n";
        }
        if (!deprecated.isEmpty()) {
            if (!deprecated.contains("    ") || !deprecated.endsWith("  ")) {
                throw new SparkIllegalArgumentException("_LEGACY_ERROR_TEMP_3205", Map.of("exprName", this.name, "deprecated", deprecated));
            }
            this.extended = this.extended + "\n    Deprecated:\n      " + deprecated.trim() + "\n";
        }
    }

    public ExpressionInfo(String className, String name) {
        this(className, null, name, null, "", "", "", "", "", "", "");
    }

    public ExpressionInfo(String className, String db, String name) {
        this(className, db, name, null, "", "", "", "", "", "", "");
    }

    @Deprecated(since="3.0.0")
    public ExpressionInfo(String className, String db, String name, String usage, String extended) {
        this(className, db, name, usage, extended, "", "", "", "", "", "");
    }

    private String replaceFunctionName(String usage) {
        if (usage == null) {
            return "N/A.";
        }
        return usage.replaceAll("_FUNC_", this.name);
    }
}

