/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client.program.rest;

import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.RestOptions;
import org.apache.flink.runtime.rest.RestClientConfiguration;
import org.apache.flink.util.ConfigurationException;
import org.apache.flink.util.Preconditions;

public final class RestClusterClientConfiguration {
    private final RestClientConfiguration restClientConfiguration;
    private final long awaitLeaderTimeout;
    private final int retryMaxAttempts;
    private final long retryDelay;

    private RestClusterClientConfiguration(RestClientConfiguration endpointConfiguration, long awaitLeaderTimeout, int retryMaxAttempts, long retryDelay) {
        Preconditions.checkArgument((awaitLeaderTimeout >= 0L ? 1 : 0) != 0, (Object)"awaitLeaderTimeout must be equal to or greater than 0");
        Preconditions.checkArgument((retryMaxAttempts >= 0 ? 1 : 0) != 0, (Object)"retryMaxAttempts must be equal to or greater than 0");
        Preconditions.checkArgument((retryDelay >= 0L ? 1 : 0) != 0, (Object)"retryDelay must be equal to or greater than 0");
        this.restClientConfiguration = (RestClientConfiguration)Preconditions.checkNotNull((Object)endpointConfiguration);
        this.awaitLeaderTimeout = awaitLeaderTimeout;
        this.retryMaxAttempts = retryMaxAttempts;
        this.retryDelay = retryDelay;
    }

    public RestClientConfiguration getRestClientConfiguration() {
        return this.restClientConfiguration;
    }

    public long getAwaitLeaderTimeout() {
        return this.awaitLeaderTimeout;
    }

    public int getRetryMaxAttempts() {
        return this.retryMaxAttempts;
    }

    public long getRetryDelay() {
        return this.retryDelay;
    }

    public static RestClusterClientConfiguration fromConfiguration(Configuration config) throws ConfigurationException {
        RestClientConfiguration restClientConfiguration = RestClientConfiguration.fromConfiguration((Configuration)config);
        long awaitLeaderTimeout = config.getLong(RestOptions.AWAIT_LEADER_TIMEOUT);
        int retryMaxAttempts = config.getInteger(RestOptions.RETRY_MAX_ATTEMPTS);
        long retryDelay = config.getLong(RestOptions.RETRY_DELAY);
        return new RestClusterClientConfiguration(restClientConfiguration, awaitLeaderTimeout, retryMaxAttempts, retryDelay);
    }
}

