/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.query;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.query.ProcedureCallHandler;
import net.sf.jasperreports.engine.query.ProcedureCallHandlerFactory;
import net.sf.jasperreports.engine.util.JRClassLoader;

public class OracleProcedureCallHandlerFactory
implements ProcedureCallHandlerFactory {
    private static final String ORACLE_PROCEDURE_CALL_HANDLER_CLASS = "com.jaspersoft.jasperreports.plsql.OracleProcedureCallHandler";

    @Override
    public ProcedureCallHandler createProcedureCallHandler() throws JRException {
        ProcedureCallHandler procedureCallHandler = null;
        try {
            Class<?> procedureCallHandlerClass = JRClassLoader.loadClassForName(ORACLE_PROCEDURE_CALL_HANDLER_CLASS);
            Constructor<?> constructor = procedureCallHandlerClass.getConstructor(new Class[0]);
            procedureCallHandler = (ProcedureCallHandler)constructor.newInstance(new Object[0]);
        }
        catch (InvocationTargetException e) {
            throw new JRException(e.getTargetException());
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException e) {
            throw new JRException(e);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return procedureCallHandler;
    }
}

