/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.servlet.setup;

import jakarta.servlet.ServletContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.format.support.FormattingConversionService;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.lang.Nullable;
import org.springframework.mock.web.MockServletContext;
import org.springframework.test.web.servlet.setup.AbstractMockMvcBuilder;
import org.springframework.test.web.servlet.setup.StaticViewResolver;
import org.springframework.test.web.servlet.setup.StubWebApplicationContext;
import org.springframework.util.Assert;
import org.springframework.web.accept.ContentNegotiationManager;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationObjectSupport;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.ViewResolver;
import org.springframework.web.servlet.config.annotation.AsyncSupportConfigurer;
import org.springframework.web.servlet.config.annotation.InterceptorRegistration;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurationSupport;
import org.springframework.web.servlet.function.RouterFunction;
import org.springframework.web.servlet.function.support.HandlerFunctionAdapter;
import org.springframework.web.servlet.function.support.RouterFunctionMapping;
import org.springframework.web.servlet.handler.MappedInterceptor;
import org.springframework.web.servlet.resource.ResourceUrlProvider;
import org.springframework.web.servlet.view.InternalResourceViewResolver;
import org.springframework.web.util.pattern.PathPatternParser;

public class RouterFunctionMockMvcBuilder
extends AbstractMockMvcBuilder<RouterFunctionMockMvcBuilder> {
    private final RouterFunction<?> routerFunction;
    private List<HttpMessageConverter<?>> messageConverters = new ArrayList();
    private final List<MappedInterceptor> mappedInterceptors = new ArrayList<MappedInterceptor>();
    @Nullable
    private List<HandlerExceptionResolver> handlerExceptionResolvers;
    @Nullable
    private Long asyncRequestTimeout;
    @Nullable
    private List<ViewResolver> viewResolvers;
    @Nullable
    private PathPatternParser patternParser;
    private Supplier<RouterFunctionMapping> handlerMappingFactory = RouterFunctionMapping::new;

    protected RouterFunctionMockMvcBuilder(RouterFunction<?> ... routerFunctions) {
        Assert.notEmpty((Object[])routerFunctions, (String)"RouterFunctions must not be empty");
        this.routerFunction = Arrays.stream(routerFunctions).reduce(RouterFunction::andOther).orElseThrow();
    }

    public RouterFunctionMockMvcBuilder setMessageConverters(HttpMessageConverter<?> ... messageConverters) {
        this.messageConverters = Arrays.asList(messageConverters);
        return this;
    }

    public RouterFunctionMockMvcBuilder addInterceptors(HandlerInterceptor ... interceptors) {
        this.addMappedInterceptors(null, interceptors);
        return this;
    }

    public RouterFunctionMockMvcBuilder addMappedInterceptors(@Nullable String[] pathPatterns, HandlerInterceptor ... interceptors) {
        for (HandlerInterceptor interceptor : interceptors) {
            this.mappedInterceptors.add(new MappedInterceptor(pathPatterns, null, interceptor));
        }
        return this;
    }

    public RouterFunctionMockMvcBuilder setHandlerExceptionResolvers(List<HandlerExceptionResolver> exceptionResolvers) {
        this.handlerExceptionResolvers = exceptionResolvers;
        return this;
    }

    public RouterFunctionMockMvcBuilder setHandlerExceptionResolvers(HandlerExceptionResolver ... exceptionResolvers) {
        this.handlerExceptionResolvers = Arrays.asList(exceptionResolvers);
        return this;
    }

    public RouterFunctionMockMvcBuilder setCustomHandlerMapping(Supplier<RouterFunctionMapping> factory) {
        this.handlerMappingFactory = factory;
        return this;
    }

    public RouterFunctionMockMvcBuilder setViewResolvers(ViewResolver ... resolvers) {
        this.viewResolvers = Arrays.asList(resolvers);
        return this;
    }

    public RouterFunctionMockMvcBuilder setSingleView(View view) {
        this.viewResolvers = Collections.singletonList(new StaticViewResolver(view));
        return this;
    }

    public RouterFunctionMockMvcBuilder setAsyncRequestTimeout(long timeout) {
        this.asyncRequestTimeout = timeout;
        return this;
    }

    public RouterFunctionMockMvcBuilder setPatternParser(@Nullable PathPatternParser parser) {
        this.patternParser = parser;
        return this;
    }

    @Override
    protected WebApplicationContext initWebAppContext() {
        MockServletContext servletContext = new MockServletContext();
        StubWebApplicationContext wac = new StubWebApplicationContext(servletContext);
        this.registerRouterFunction(wac);
        servletContext.setAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE, wac);
        return wac;
    }

    private void registerRouterFunction(StubWebApplicationContext wac) {
        HandlerFunctionConfiguration config = new HandlerFunctionConfiguration();
        config.setApplicationContext((ApplicationContext)wac);
        ServletContext sc = wac.getServletContext();
        wac.addBean("routerFunction", this.routerFunction);
        FormattingConversionService mvcConversionService = config.mvcConversionService();
        wac.addBean("mvcConversionService", mvcConversionService);
        ResourceUrlProvider resourceUrlProvider = config.mvcResourceUrlProvider();
        wac.addBean("mvcResourceUrlProvider", resourceUrlProvider);
        ContentNegotiationManager mvcContentNegotiationManager = config.mvcContentNegotiationManager();
        wac.addBean("mvcContentNegotiationManager", mvcContentNegotiationManager);
        RouterFunctionMapping hm = config.getHandlerMapping(mvcConversionService, resourceUrlProvider);
        if (sc != null) {
            hm.setServletContext(sc);
        }
        hm.setApplicationContext((ApplicationContext)wac);
        hm.afterPropertiesSet();
        wac.addBean("routerFunctionMapping", hm);
        HandlerFunctionAdapter ha = config.handlerFunctionAdapter();
        wac.addBean("handlerFunctionAdapter", ha);
        wac.addBean("handlerExceptionResolver", config.handlerExceptionResolver(mvcContentNegotiationManager));
        wac.addBeans(this.initViewResolvers(wac));
    }

    private List<ViewResolver> initViewResolvers(WebApplicationContext wac) {
        this.viewResolvers = this.viewResolvers != null ? this.viewResolvers : Collections.singletonList(new InternalResourceViewResolver());
        for (ViewResolver viewResolver : this.viewResolvers) {
            if (!(viewResolver instanceof WebApplicationObjectSupport)) continue;
            WebApplicationObjectSupport support = (WebApplicationObjectSupport)viewResolver;
            support.setApplicationContext((ApplicationContext)wac);
        }
        return this.viewResolvers;
    }

    private class HandlerFunctionConfiguration
    extends WebMvcConfigurationSupport {
        private HandlerFunctionConfiguration() {
        }

        public RouterFunctionMapping getHandlerMapping(FormattingConversionService mvcConversionService, ResourceUrlProvider mvcResourceUrlProvider) {
            RouterFunctionMapping handlerMapping = RouterFunctionMockMvcBuilder.this.handlerMappingFactory.get();
            handlerMapping.setOrder(0);
            handlerMapping.setInterceptors(this.getInterceptors(mvcConversionService, mvcResourceUrlProvider));
            handlerMapping.setMessageConverters(this.getMessageConverters());
            if (RouterFunctionMockMvcBuilder.this.patternParser != null) {
                handlerMapping.setPatternParser(RouterFunctionMockMvcBuilder.this.patternParser);
            }
            return handlerMapping;
        }

        protected void configureMessageConverters(List<HttpMessageConverter<?>> converters) {
            converters.addAll(RouterFunctionMockMvcBuilder.this.messageConverters);
        }

        protected void addInterceptors(InterceptorRegistry registry) {
            for (MappedInterceptor interceptor : RouterFunctionMockMvcBuilder.this.mappedInterceptors) {
                InterceptorRegistration registration = registry.addInterceptor(interceptor.getInterceptor());
                if (interceptor.getIncludePathPatterns() == null) continue;
                registration.addPathPatterns(interceptor.getIncludePathPatterns());
            }
        }

        public void configureAsyncSupport(AsyncSupportConfigurer configurer) {
            if (RouterFunctionMockMvcBuilder.this.asyncRequestTimeout != null) {
                configurer.setDefaultTimeout(RouterFunctionMockMvcBuilder.this.asyncRequestTimeout.longValue());
            }
        }

        protected void configureHandlerExceptionResolvers(List<HandlerExceptionResolver> exceptionResolvers) {
            if (RouterFunctionMockMvcBuilder.this.handlerExceptionResolvers == null) {
                return;
            }
            for (HandlerExceptionResolver resolver : RouterFunctionMockMvcBuilder.this.handlerExceptionResolvers) {
                if (resolver instanceof ApplicationContextAware) {
                    ApplicationContextAware applicationContextAware = (ApplicationContextAware)resolver;
                    ApplicationContext applicationContext = this.getApplicationContext();
                    if (applicationContext != null) {
                        applicationContextAware.setApplicationContext(applicationContext);
                    }
                }
                if (resolver instanceof InitializingBean) {
                    InitializingBean initializingBean = (InitializingBean)resolver;
                    try {
                        initializingBean.afterPropertiesSet();
                    }
                    catch (Exception ex) {
                        throw new IllegalStateException("Failure from afterPropertiesSet", ex);
                    }
                }
                exceptionResolvers.add(resolver);
            }
        }
    }
}

