/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.transport.netty;

import io.netty.channel.Channel;
import io.netty.channel.EventLoopGroup;
import org.ldaptive.Connection;
import org.ldaptive.ConnectionConfig;
import org.ldaptive.transport.Transport;
import org.ldaptive.transport.netty.NettyConnection;
import org.ldaptive.transport.netty.NettyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DefaultNettyTransport
implements Transport {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String threadPoolName;
    private final int numIoThreads;
    private final int numMessageThreads;

    DefaultNettyTransport() {
        this(0);
    }

    DefaultNettyTransport(int ioThreads) {
        this(null, ioThreads, -1);
    }

    DefaultNettyTransport(int ioThreads, int messageThreads) {
        this(null, ioThreads, messageThreads);
    }

    DefaultNettyTransport(String name, int ioThreads, int messageThreads) {
        this.threadPoolName = name == null ? "default-netty-transport" : name;
        this.numIoThreads = ioThreads;
        this.numMessageThreads = messageThreads;
    }

    protected Class<? extends Channel> getSocketChannelType() {
        return NettyUtils.getDefaultSocketChannelType();
    }

    protected EventLoopGroup createEventLoopGroup(String name, int numThreads) {
        return NettyUtils.createDefaultEventLoopGroup(name, numThreads);
    }

    @Override
    public Connection create(ConnectionConfig cc) {
        if (this.numMessageThreads != -1) {
            return new NettyConnection(cc, this.getSocketChannelType(), this.createEventLoopGroup(this.threadPoolName + "-io", this.numIoThreads), this.createEventLoopGroup(this.threadPoolName + "-messages", this.numMessageThreads), true);
        }
        return new NettyConnection(cc, this.getSocketChannelType(), this.createEventLoopGroup(this.threadPoolName + "-io", this.numIoThreads), null, true);
    }

    @Override
    public void close() {
    }

    @Override
    public void shutdown() {
    }

    public String toString() {
        return "[" + this.getClass().getName() + "@" + this.hashCode() + "::threadPoolName" + this.threadPoolName + ", numIoThreads=" + this.numIoThreads + ", numMessageThreads=" + this.numMessageThreads + "]";
    }
}

