/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudwatch.model.CloudWatchResponse;
import software.amazon.awssdk.services.cloudwatch.model.InsightRuleContributor;
import software.amazon.awssdk.services.cloudwatch.model.InsightRuleContributorKeyLabelsCopier;
import software.amazon.awssdk.services.cloudwatch.model.InsightRuleContributorsCopier;
import software.amazon.awssdk.services.cloudwatch.model.InsightRuleMetricDatapoint;
import software.amazon.awssdk.services.cloudwatch.model.InsightRuleMetricDatapointsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetInsightRuleReportResponse
extends CloudWatchResponse
implements ToCopyableBuilder<Builder, GetInsightRuleReportResponse> {
    private static final SdkField<List<String>> KEY_LABELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("KeyLabels").getter(GetInsightRuleReportResponse.getter(GetInsightRuleReportResponse::keyLabels)).setter(GetInsightRuleReportResponse.setter(Builder::keyLabels)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyLabels").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> AGGREGATION_STATISTIC_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AggregationStatistic").getter(GetInsightRuleReportResponse.getter(GetInsightRuleReportResponse::aggregationStatistic)).setter(GetInsightRuleReportResponse.setter(Builder::aggregationStatistic)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AggregationStatistic").build()}).build();
    private static final SdkField<Double> AGGREGATE_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("AggregateValue").getter(GetInsightRuleReportResponse.getter(GetInsightRuleReportResponse::aggregateValue)).setter(GetInsightRuleReportResponse.setter(Builder::aggregateValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AggregateValue").build()}).build();
    private static final SdkField<Long> APPROXIMATE_UNIQUE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("ApproximateUniqueCount").getter(GetInsightRuleReportResponse.getter(GetInsightRuleReportResponse::approximateUniqueCount)).setter(GetInsightRuleReportResponse.setter(Builder::approximateUniqueCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApproximateUniqueCount").build()}).build();
    private static final SdkField<List<InsightRuleContributor>> CONTRIBUTORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Contributors").getter(GetInsightRuleReportResponse.getter(GetInsightRuleReportResponse::contributors)).setter(GetInsightRuleReportResponse.setter(Builder::contributors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Contributors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InsightRuleContributor::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<InsightRuleMetricDatapoint>> METRIC_DATAPOINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MetricDatapoints").getter(GetInsightRuleReportResponse.getter(GetInsightRuleReportResponse::metricDatapoints)).setter(GetInsightRuleReportResponse.setter(Builder::metricDatapoints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricDatapoints").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InsightRuleMetricDatapoint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_LABELS_FIELD, AGGREGATION_STATISTIC_FIELD, AGGREGATE_VALUE_FIELD, APPROXIMATE_UNIQUE_COUNT_FIELD, CONTRIBUTORS_FIELD, METRIC_DATAPOINTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetInsightRuleReportResponse.memberNameToFieldInitializer();
    private final List<String> keyLabels;
    private final String aggregationStatistic;
    private final Double aggregateValue;
    private final Long approximateUniqueCount;
    private final List<InsightRuleContributor> contributors;
    private final List<InsightRuleMetricDatapoint> metricDatapoints;

    private GetInsightRuleReportResponse(BuilderImpl builder) {
        super(builder);
        this.keyLabels = builder.keyLabels;
        this.aggregationStatistic = builder.aggregationStatistic;
        this.aggregateValue = builder.aggregateValue;
        this.approximateUniqueCount = builder.approximateUniqueCount;
        this.contributors = builder.contributors;
        this.metricDatapoints = builder.metricDatapoints;
    }

    public final boolean hasKeyLabels() {
        return this.keyLabels != null && !(this.keyLabels instanceof SdkAutoConstructList);
    }

    public final List<String> keyLabels() {
        return this.keyLabels;
    }

    public final String aggregationStatistic() {
        return this.aggregationStatistic;
    }

    public final Double aggregateValue() {
        return this.aggregateValue;
    }

    public final Long approximateUniqueCount() {
        return this.approximateUniqueCount;
    }

    public final boolean hasContributors() {
        return this.contributors != null && !(this.contributors instanceof SdkAutoConstructList);
    }

    public final List<InsightRuleContributor> contributors() {
        return this.contributors;
    }

    public final boolean hasMetricDatapoints() {
        return this.metricDatapoints != null && !(this.metricDatapoints instanceof SdkAutoConstructList);
    }

    public final List<InsightRuleMetricDatapoint> metricDatapoints() {
        return this.metricDatapoints;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasKeyLabels() ? this.keyLabels() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.aggregationStatistic());
        hashCode = 31 * hashCode + Objects.hashCode(this.aggregateValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.approximateUniqueCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasContributors() ? this.contributors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetricDatapoints() ? this.metricDatapoints() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetInsightRuleReportResponse)) {
            return false;
        }
        GetInsightRuleReportResponse other = (GetInsightRuleReportResponse)((Object)obj);
        return this.hasKeyLabels() == other.hasKeyLabels() && Objects.equals(this.keyLabels(), other.keyLabels()) && Objects.equals(this.aggregationStatistic(), other.aggregationStatistic()) && Objects.equals(this.aggregateValue(), other.aggregateValue()) && Objects.equals(this.approximateUniqueCount(), other.approximateUniqueCount()) && this.hasContributors() == other.hasContributors() && Objects.equals(this.contributors(), other.contributors()) && this.hasMetricDatapoints() == other.hasMetricDatapoints() && Objects.equals(this.metricDatapoints(), other.metricDatapoints());
    }

    public final String toString() {
        return ToString.builder((String)"GetInsightRuleReportResponse").add("KeyLabels", this.hasKeyLabels() ? this.keyLabels() : null).add("AggregationStatistic", (Object)this.aggregationStatistic()).add("AggregateValue", (Object)this.aggregateValue()).add("ApproximateUniqueCount", (Object)this.approximateUniqueCount()).add("Contributors", this.hasContributors() ? this.contributors() : null).add("MetricDatapoints", this.hasMetricDatapoints() ? this.metricDatapoints() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KeyLabels": {
                return Optional.ofNullable(clazz.cast(this.keyLabels()));
            }
            case "AggregationStatistic": {
                return Optional.ofNullable(clazz.cast(this.aggregationStatistic()));
            }
            case "AggregateValue": {
                return Optional.ofNullable(clazz.cast(this.aggregateValue()));
            }
            case "ApproximateUniqueCount": {
                return Optional.ofNullable(clazz.cast(this.approximateUniqueCount()));
            }
            case "Contributors": {
                return Optional.ofNullable(clazz.cast(this.contributors()));
            }
            case "MetricDatapoints": {
                return Optional.ofNullable(clazz.cast(this.metricDatapoints()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("KeyLabels", KEY_LABELS_FIELD);
        map.put("AggregationStatistic", AGGREGATION_STATISTIC_FIELD);
        map.put("AggregateValue", AGGREGATE_VALUE_FIELD);
        map.put("ApproximateUniqueCount", APPROXIMATE_UNIQUE_COUNT_FIELD);
        map.put("Contributors", CONTRIBUTORS_FIELD);
        map.put("MetricDatapoints", METRIC_DATAPOINTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetInsightRuleReportResponse, T> g) {
        return obj -> g.apply((GetInsightRuleReportResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudWatchResponse.BuilderImpl
    implements Builder {
        private List<String> keyLabels = DefaultSdkAutoConstructList.getInstance();
        private String aggregationStatistic;
        private Double aggregateValue;
        private Long approximateUniqueCount;
        private List<InsightRuleContributor> contributors = DefaultSdkAutoConstructList.getInstance();
        private List<InsightRuleMetricDatapoint> metricDatapoints = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetInsightRuleReportResponse model) {
            super(model);
            this.keyLabels(model.keyLabels);
            this.aggregationStatistic(model.aggregationStatistic);
            this.aggregateValue(model.aggregateValue);
            this.approximateUniqueCount(model.approximateUniqueCount);
            this.contributors(model.contributors);
            this.metricDatapoints(model.metricDatapoints);
        }

        public final Collection<String> getKeyLabels() {
            if (this.keyLabels instanceof SdkAutoConstructList) {
                return null;
            }
            return this.keyLabels;
        }

        public final void setKeyLabels(Collection<String> keyLabels) {
            this.keyLabels = InsightRuleContributorKeyLabelsCopier.copy(keyLabels);
        }

        @Override
        public final Builder keyLabels(Collection<String> keyLabels) {
            this.keyLabels = InsightRuleContributorKeyLabelsCopier.copy(keyLabels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keyLabels(String ... keyLabels) {
            this.keyLabels(Arrays.asList(keyLabels));
            return this;
        }

        public final String getAggregationStatistic() {
            return this.aggregationStatistic;
        }

        public final void setAggregationStatistic(String aggregationStatistic) {
            this.aggregationStatistic = aggregationStatistic;
        }

        @Override
        public final Builder aggregationStatistic(String aggregationStatistic) {
            this.aggregationStatistic = aggregationStatistic;
            return this;
        }

        public final Double getAggregateValue() {
            return this.aggregateValue;
        }

        public final void setAggregateValue(Double aggregateValue) {
            this.aggregateValue = aggregateValue;
        }

        @Override
        public final Builder aggregateValue(Double aggregateValue) {
            this.aggregateValue = aggregateValue;
            return this;
        }

        public final Long getApproximateUniqueCount() {
            return this.approximateUniqueCount;
        }

        public final void setApproximateUniqueCount(Long approximateUniqueCount) {
            this.approximateUniqueCount = approximateUniqueCount;
        }

        @Override
        public final Builder approximateUniqueCount(Long approximateUniqueCount) {
            this.approximateUniqueCount = approximateUniqueCount;
            return this;
        }

        public final List<InsightRuleContributor.Builder> getContributors() {
            List<InsightRuleContributor.Builder> result = InsightRuleContributorsCopier.copyToBuilder(this.contributors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setContributors(Collection<InsightRuleContributor.BuilderImpl> contributors) {
            this.contributors = InsightRuleContributorsCopier.copyFromBuilder(contributors);
        }

        @Override
        public final Builder contributors(Collection<InsightRuleContributor> contributors) {
            this.contributors = InsightRuleContributorsCopier.copy(contributors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contributors(InsightRuleContributor ... contributors) {
            this.contributors(Arrays.asList(contributors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contributors(Consumer<InsightRuleContributor.Builder> ... contributors) {
            this.contributors(Stream.of(contributors).map(c -> (InsightRuleContributor)((InsightRuleContributor.Builder)InsightRuleContributor.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<InsightRuleMetricDatapoint.Builder> getMetricDatapoints() {
            List<InsightRuleMetricDatapoint.Builder> result = InsightRuleMetricDatapointsCopier.copyToBuilder(this.metricDatapoints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMetricDatapoints(Collection<InsightRuleMetricDatapoint.BuilderImpl> metricDatapoints) {
            this.metricDatapoints = InsightRuleMetricDatapointsCopier.copyFromBuilder(metricDatapoints);
        }

        @Override
        public final Builder metricDatapoints(Collection<InsightRuleMetricDatapoint> metricDatapoints) {
            this.metricDatapoints = InsightRuleMetricDatapointsCopier.copy(metricDatapoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricDatapoints(InsightRuleMetricDatapoint ... metricDatapoints) {
            this.metricDatapoints(Arrays.asList(metricDatapoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricDatapoints(Consumer<InsightRuleMetricDatapoint.Builder> ... metricDatapoints) {
            this.metricDatapoints(Stream.of(metricDatapoints).map(c -> (InsightRuleMetricDatapoint)((InsightRuleMetricDatapoint.Builder)InsightRuleMetricDatapoint.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetInsightRuleReportResponse build() {
            return new GetInsightRuleReportResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CloudWatchResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetInsightRuleReportResponse> {
        public Builder keyLabels(Collection<String> var1);

        public Builder keyLabels(String ... var1);

        public Builder aggregationStatistic(String var1);

        public Builder aggregateValue(Double var1);

        public Builder approximateUniqueCount(Long var1);

        public Builder contributors(Collection<InsightRuleContributor> var1);

        public Builder contributors(InsightRuleContributor ... var1);

        public Builder contributors(Consumer<InsightRuleContributor.Builder> ... var1);

        public Builder metricDatapoints(Collection<InsightRuleMetricDatapoint> var1);

        public Builder metricDatapoints(InsightRuleMetricDatapoint ... var1);

        public Builder metricDatapoints(Consumer<InsightRuleMetricDatapoint.Builder> ... var1);
    }
}

