/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic;

import java.io.InputStream;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import org.apache.syncope.common.lib.to.EntityTO;
import org.apache.syncope.core.logic.AbstractTransactionalLogic;
import org.apache.syncope.core.logic.SAML2SP4UIProperties;
import org.pac4j.saml.config.SAML2Configuration;
import org.pac4j.saml.metadata.keystore.BaseSAML2KeystoreGenerator;
import org.pac4j.saml.metadata.keystore.SAML2KeystoreGenerator;
import org.springframework.core.io.FileUrlResource;
import org.springframework.core.io.support.ResourcePatternResolver;

abstract class AbstractSAML2SP4UILogic
extends AbstractTransactionalLogic<EntityTO> {
    protected final SAML2SP4UIProperties props;
    protected final ResourcePatternResolver resourceResolver;

    protected AbstractSAML2SP4UILogic(SAML2SP4UIProperties props, ResourcePatternResolver resourceResolver) {
        this.props = props;
        this.resourceResolver = resourceResolver;
    }

    protected SAML2Configuration newSAML2Configuration() {
        final SAML2Configuration cfg = new SAML2Configuration(this.resourceResolver.getResource(this.props.getKeystore()), this.props.getKeystoreAlias(), this.props.getKeystoreType(), this.props.getKeystoreStorepass(), this.props.getKeystoreKeypass(), null);
        if (cfg.getKeystoreResource() instanceof FileUrlResource) {
            cfg.setKeystoreGenerator((SAML2KeystoreGenerator)new BaseSAML2KeystoreGenerator(this, cfg){

                protected void store(KeyStore ks, X509Certificate certificate, PrivateKey privateKey) {
                }

                public InputStream retrieve() throws Exception {
                    return cfg.getKeystoreResource().getInputStream();
                }
            });
        }
        cfg.setWantsAssertionsSigned(true);
        cfg.setAuthnRequestSigned(true);
        cfg.setSpLogoutRequestSigned(true);
        cfg.setMaximumAuthenticationLifetime(this.props.getMaximumAuthenticationLifetime());
        cfg.setAcceptedSkew(this.props.getAcceptedSkew());
        return cfg;
    }
}

