/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication.principal;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.DiscriminatorColumn;
import jakarta.persistence.DiscriminatorType;
import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import jakarta.persistence.Inheritance;
import jakarta.persistence.Table;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.core5.net.URIBuilder;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.jpa.MultivaluedMapToJsonAttributeConverter;
import org.apereo.cas.validation.ValidationResponseType;

@Entity
@Inheritance
@DiscriminatorColumn(name="service_type", length=50, discriminatorType=DiscriminatorType.STRING, columnDefinition="VARCHAR(50) DEFAULT 'simple'")
@Table(name="WebApplicationServices")
public abstract class AbstractWebApplicationService
implements WebApplicationService {
    private static final long serialVersionUID = 610105280927740076L;
    @Id
    @JsonProperty
    @Column
    private String id;
    @JsonProperty
    @Column(nullable=false)
    private String originalUrl;
    @Column
    private String artifactId;
    @JsonProperty
    @Column
    private String principal;
    @JsonProperty
    @Column
    private String source;
    @JsonProperty
    @Column
    private String tenant;
    @Column
    private boolean loggedOutAlready;
    @Column
    private ValidationResponseType format = ValidationResponseType.XML;
    @Column(columnDefinition="json")
    @Convert(converter=MultivaluedMapToJsonAttributeConverter.class)
    private Map<String, Object> attributes = new HashMap<String, Object>(0);

    protected AbstractWebApplicationService(String id, String originalUrl, String artifactId) {
        this.id = id;
        this.originalUrl = originalUrl;
        this.artifactId = artifactId;
    }

    @JsonIgnore
    @CanIgnoreReturnValue
    public WebApplicationService setFragment(String fragment) {
        if (StringUtils.isNotBlank((CharSequence)fragment)) {
            this.id = AbstractWebApplicationService.collectFragmentFor(this.id, fragment);
            this.originalUrl = AbstractWebApplicationService.collectFragmentFor(this.originalUrl, fragment);
        }
        return this;
    }

    @JsonIgnore
    public String getFragment() {
        return (String)FunctionUtils.doAndHandle(() -> new URIBuilder(this.id).getFragment());
    }

    private static String collectFragmentFor(String id, String fragment) {
        return (String)FunctionUtils.doUnchecked(() -> new URIBuilder(id).setFragment(fragment).build().toURL().toExternalForm());
    }

    @Generated
    public String toString() {
        return "AbstractWebApplicationService(id=" + this.id + ", originalUrl=" + this.originalUrl + ", artifactId=" + this.artifactId + ", principal=" + this.principal + ", source=" + this.source + ", tenant=" + this.tenant + ", loggedOutAlready=" + this.loggedOutAlready + ", format=" + String.valueOf(this.format) + ", attributes=" + String.valueOf(this.attributes) + ")";
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getOriginalUrl() {
        return this.originalUrl;
    }

    @Generated
    public String getArtifactId() {
        return this.artifactId;
    }

    @Generated
    public String getPrincipal() {
        return this.principal;
    }

    @Generated
    public String getSource() {
        return this.source;
    }

    @Generated
    public String getTenant() {
        return this.tenant;
    }

    @Generated
    public boolean isLoggedOutAlready() {
        return this.loggedOutAlready;
    }

    @Generated
    public ValidationResponseType getFormat() {
        return this.format;
    }

    @Generated
    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    @JsonProperty
    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @JsonProperty
    @Generated
    public void setOriginalUrl(String originalUrl) {
        this.originalUrl = originalUrl;
    }

    @Generated
    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    @JsonProperty
    @Generated
    public void setPrincipal(String principal) {
        this.principal = principal;
    }

    @JsonProperty
    @Generated
    public void setSource(String source) {
        this.source = source;
    }

    @JsonProperty
    @Generated
    public void setTenant(String tenant) {
        this.tenant = tenant;
    }

    @Generated
    public void setLoggedOutAlready(boolean loggedOutAlready) {
        this.loggedOutAlready = loggedOutAlready;
    }

    @Generated
    public void setFormat(ValidationResponseType format) {
        this.format = format;
    }

    @Generated
    public void setAttributes(Map<String, Object> attributes) {
        this.attributes = attributes;
    }

    @Generated
    protected AbstractWebApplicationService() {
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractWebApplicationService)) {
            return false;
        }
        AbstractWebApplicationService other = (AbstractWebApplicationService)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.loggedOutAlready != other.loggedOutAlready) {
            return false;
        }
        String this$id = this.id;
        String other$id = other.id;
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$originalUrl = this.originalUrl;
        String other$originalUrl = other.originalUrl;
        if (this$originalUrl == null ? other$originalUrl != null : !this$originalUrl.equals(other$originalUrl)) {
            return false;
        }
        String this$artifactId = this.artifactId;
        String other$artifactId = other.artifactId;
        if (this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId)) {
            return false;
        }
        String this$principal = this.principal;
        String other$principal = other.principal;
        if (this$principal == null ? other$principal != null : !this$principal.equals(other$principal)) {
            return false;
        }
        String this$source = this.source;
        String other$source = other.source;
        if (this$source == null ? other$source != null : !this$source.equals(other$source)) {
            return false;
        }
        String this$tenant = this.tenant;
        String other$tenant = other.tenant;
        if (this$tenant == null ? other$tenant != null : !this$tenant.equals(other$tenant)) {
            return false;
        }
        ValidationResponseType this$format = this.format;
        ValidationResponseType other$format = other.format;
        if (this$format == null ? other$format != null : !this$format.equals(other$format)) {
            return false;
        }
        Map<String, Object> this$attributes = this.attributes;
        Map<String, Object> other$attributes = other.attributes;
        return !(this$attributes == null ? other$attributes != null : !((Object)this$attributes).equals(other$attributes));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AbstractWebApplicationService;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.loggedOutAlready ? 79 : 97);
        String $id = this.id;
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $originalUrl = this.originalUrl;
        result = result * 59 + ($originalUrl == null ? 43 : $originalUrl.hashCode());
        String $artifactId = this.artifactId;
        result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
        String $principal = this.principal;
        result = result * 59 + ($principal == null ? 43 : $principal.hashCode());
        String $source = this.source;
        result = result * 59 + ($source == null ? 43 : $source.hashCode());
        String $tenant = this.tenant;
        result = result * 59 + ($tenant == null ? 43 : $tenant.hashCode());
        ValidationResponseType $format = this.format;
        result = result * 59 + ($format == null ? 43 : $format.hashCode());
        Map<String, Object> $attributes = this.attributes;
        result = result * 59 + ($attributes == null ? 43 : ((Object)$attributes).hashCode());
        return result;
    }
}

