/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.checkpoints;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.util.Collections;
import kafka.server.checkpoints.LazyOffsetCheckpoints;
import kafka.server.checkpoints.OffsetCheckpointFile;
import kafka.server.checkpoints.OffsetCheckpointFile$;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.server.common.CheckpointFile;
import org.apache.kafka.storage.internals.checkpoint.CheckpointFileWithFailureHandler;
import org.apache.kafka.storage.internals.checkpoint.LeaderEpochCheckpointFile;
import org.apache.kafka.storage.internals.log.EpochEntry;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import scala.Function0;
import scala.None$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u00013A!\u0003\u0006\u0001#!)a\u0004\u0001C\u0001?!)!\u0005\u0001C\u0001G!)A\u0007\u0001C\u0001G!)a\u0007\u0001C\u0001G!)\u0001\b\u0001C\u0001G!)!\b\u0001C\u0001G!)A\b\u0001C\u0001G!)a\b\u0001C\u0001G\tQsJ\u001a4tKR\u001c\u0005.Z2la>Lg\u000e\u001e$jY\u0016<\u0016\u000e\u001e5GC&dWO]3IC:$G.\u001a:UKN$(BA\u0006\r\u0003-\u0019\u0007.Z2la>Lg\u000e^:\u000b\u00055q\u0011AB:feZ,'OC\u0001\u0010\u0003\u0015Y\u0017MZ6b\u0007\u0001\u00192\u0001\u0001\n\u0019!\t\u0019b#D\u0001\u0015\u0015\u0005)\u0012!B:dC2\f\u0017BA\f\u0015\u0005\u0019\te.\u001f*fMB\u0011\u0011\u0004H\u0007\u00025)\u00111DD\u0001\u0006kRLGn]\u0005\u0003;i\u0011q\u0001T8hO&tw-\u0001\u0004=S:LGO\u0010\u000b\u0002AA\u0011\u0011\u0005A\u0007\u0002\u0015\u000513\u000f[8vY\u0012\u0004VM]:jgR\fe\u000eZ(wKJ<(/\u001b;f\u0003:$'+\u001a7pC\u00124\u0015\u000e\\3\u0015\u0003\u0011\u0002\"aE\u0013\n\u0005\u0019\"\"\u0001B+oSRD#A\u0001\u0015\u0011\u0005%\u0012T\"\u0001\u0016\u000b\u0005-b\u0013aA1qS*\u0011QFL\u0001\bUV\u0004\u0018\u000e^3s\u0015\ty\u0003'A\u0003kk:LGOC\u00012\u0003\ry'oZ\u0005\u0003g)\u0012A\u0001V3ti\u0006I2\u000f[8vY\u0012D\u0015M\u001c3mK6+H\u000e^5qY\u0016d\u0015N\\3tQ\t\u0019\u0001&\u0001\u0011tQ>,H\u000e\u001a*fiV\u0014h.R7qifl\u0015\r\u001d$pe\u0016k\u0007\u000f^=GS2,\u0007F\u0001\u0003)\u0003\r\u001a\bn\\;mIRC'o\\<JMZ+'o]5p]&\u001bhj\u001c;SK\u000e|wM\\5tK\u0012D#!\u0002\u0015\u00021Q,7\u000f\u001e'buf|eMZ:fi\u000eCWmY6q_&tG\u000f\u000b\u0002\u0007Q\u0005IC/Z:u\u0019\u0006T\u0018p\u00144gg\u0016$8\t[3dWB|\u0017N\u001c;GS2,\u0017J\u001c<bY&$Gj\\4ESJD#a\u0002\u0015\u0002eQ,7\u000f^,sSR,\u0017J\u001a#je\u0016C\u0018n\u001d;t'\"|W\u000f\u001c3O_R$\u0006N]8x/\",g\u000eR5s\u001d>$X\t_5tiND#\u0001\u0003\u0015")
public class OffsetCheckpointFileWithFailureHandlerTest
implements Logging {
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$((Logging)this, (String)msg);
    }

    public void trace(Function0<String> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$((Logging)this, msg, e);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$((Logging)this, msg, e);
    }

    public void info(Function0<String> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$((Logging)this, msg, e);
    }

    public void warn(Function0<String> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$((Logging)this, msg, e);
    }

    public void error(Function0<String> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$((Logging)this, msg, e);
    }

    public void fatal(Function0<String> msg) {
        Logging.fatal$((Logging)this, msg);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$((Logging)this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Test
    public void shouldPersistAndOverwriteAndReloadFile() {
        OffsetCheckpointFile checkpoint = new OffsetCheckpointFile(TestUtils.tempFile((String)"kafka", (String)".tmp"), null);
        Map offsets = (Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 1)), (Object)BoxesRunTime.boxToLong((long)5L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("bar", 2)), (Object)BoxesRunTime.boxToLong((long)10L))}));
        checkpoint.write(offsets);
        Assertions.assertEquals((Object)offsets, (Object)checkpoint.read());
        Map offsets2 = (Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 2)), (Object)BoxesRunTime.boxToLong((long)15L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("bar", 3)), (Object)BoxesRunTime.boxToLong((long)20L))}));
        checkpoint.write(offsets2);
        Assertions.assertEquals((Object)offsets2, (Object)checkpoint.read());
    }

    @Test
    public void shouldHandleMultipleLines() {
        OffsetCheckpointFile checkpoint = new OffsetCheckpointFile(TestUtils.tempFile((String)"kafka", (String)".tmp"), null);
        Map offsets = (Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 1)), (Object)BoxesRunTime.boxToLong((long)5L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("bar", 6)), (Object)BoxesRunTime.boxToLong((long)10L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 2)), (Object)BoxesRunTime.boxToLong((long)5L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("bar", 7)), (Object)BoxesRunTime.boxToLong((long)10L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 3)), (Object)BoxesRunTime.boxToLong((long)5L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("bar", 8)), (Object)BoxesRunTime.boxToLong((long)10L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 4)), (Object)BoxesRunTime.boxToLong((long)5L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("bar", 9)), (Object)BoxesRunTime.boxToLong((long)10L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 5)), (Object)BoxesRunTime.boxToLong((long)5L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("bar", 10)), (Object)BoxesRunTime.boxToLong((long)10L))}));
        checkpoint.write(offsets);
        Assertions.assertEquals((Object)offsets, (Object)checkpoint.read());
    }

    @Test
    public void shouldReturnEmptyMapForEmptyFile() {
        OffsetCheckpointFile checkpoint = new OffsetCheckpointFile(TestUtils.tempFile((String)"kafka", (String)".tmp"), null);
        Assertions.assertEquals((Object)Map$.MODULE$.apply((Seq)Nil$.MODULE$), (Object)checkpoint.read());
        checkpoint.write((Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$));
        Assertions.assertEquals((Object)Map$.MODULE$.apply((Seq)Nil$.MODULE$), (Object)checkpoint.read());
    }

    @Test
    public void shouldThrowIfVersionIsNotRecognised() {
        File file = TestUtils.tempFile((String)"kafka", (String)".tmp");
        LogDirFailureChannel logDirFailureChannel = new LogDirFailureChannel(10);
        CheckpointFileWithFailureHandler checkpointFile = new CheckpointFileWithFailureHandler(file, OffsetCheckpointFile$.MODULE$.CurrentVersion() + 1, (CheckpointFile.EntryFormatter)OffsetCheckpointFile.Formatter$.MODULE$, logDirFailureChannel, file.getParent());
        checkpointFile.write(Collections.singletonList(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 5)), (Object)BoxesRunTime.boxToLong((long)10L))));
        Assertions.assertThrows(KafkaStorageException.class, () -> new OffsetCheckpointFile(checkpointFile$1.file, logDirFailureChannel).read());
    }

    @Test
    public void testLazyOffsetCheckpoint() {
        String logDir = "/tmp/kafka-logs";
        OffsetCheckpointFile mockCheckpointFile = (OffsetCheckpointFile)Mockito.mock(OffsetCheckpointFile.class);
        LazyOffsetCheckpoints lazyCheckpoints = new LazyOffsetCheckpoints((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)logDir), (Object)mockCheckpointFile)})));
        ((OffsetCheckpointFile)Mockito.verify((Object)mockCheckpointFile, (VerificationMode)Mockito.never())).read();
        TopicPartition partition0 = new TopicPartition("foo", 0);
        TopicPartition partition1 = new TopicPartition("foo", 1);
        TopicPartition partition2 = new TopicPartition("foo", 2);
        Mockito.when((Object)mockCheckpointFile.read()).thenReturn(Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition0), (Object)BoxesRunTime.boxToLong((long)1000L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition1), (Object)BoxesRunTime.boxToLong((long)2000L))})));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)1000L)), (Object)lazyCheckpoints.fetch(logDir, partition0));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)2000L)), (Object)lazyCheckpoints.fetch(logDir, partition1));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)lazyCheckpoints.fetch(logDir, partition2));
        ((OffsetCheckpointFile)Mockito.verify((Object)mockCheckpointFile, (VerificationMode)Mockito.times((int)1))).read();
    }

    @Test
    public void testLazyOffsetCheckpointFileInvalidLogDir() {
        String logDir = "/tmp/kafka-logs";
        OffsetCheckpointFile mockCheckpointFile = (OffsetCheckpointFile)Mockito.mock(OffsetCheckpointFile.class);
        LazyOffsetCheckpoints lazyCheckpoints = new LazyOffsetCheckpoints((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)logDir), (Object)mockCheckpointFile)})));
        Assertions.assertThrows(IllegalArgumentException.class, () -> lazyCheckpoints.fetch("/invalid/kafka-logs", new TopicPartition("foo", 0)));
    }

    @Test
    public void testWriteIfDirExistsShouldNotThrowWhenDirNotExists() {
        File dir = TestUtils.tempDirectory(null, null);
        File file = dir.toPath().resolve("test-checkpoint").toFile();
        LogDirFailureChannel logDirFailureChannel = new LogDirFailureChannel(10);
        CheckpointFileWithFailureHandler checkpointFile = new CheckpointFileWithFailureHandler(file, 0, (CheckpointFile.EntryFormatter)LeaderEpochCheckpointFile.FORMATTER, logDirFailureChannel, file.getParent());
        dir.renameTo(new File(new StringBuilder(8).append(dir.getAbsolutePath()).append("-renamed").toString()));
        checkpointFile.writeIfDirExists(Collections.singletonList(new EpochEntry(1, 42L)));
    }
}

