/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.request.UserUR;
import org.apache.syncope.common.lib.to.EntityTO;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.lib.to.WorkflowTask;
import org.apache.syncope.common.lib.to.WorkflowTaskExecInput;
import org.apache.syncope.core.flowable.api.WorkflowTaskManager;
import org.apache.syncope.core.logic.AbstractTransactionalLogic;
import org.apache.syncope.core.logic.UnresolvedReferenceException;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.provisioning.api.UserWorkflowResult;
import org.apache.syncope.core.provisioning.api.data.UserDataBinder;
import org.apache.syncope.core.provisioning.api.propagation.PropagationManager;
import org.apache.syncope.core.provisioning.api.propagation.PropagationTaskExecutor;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.springframework.security.access.prepost.PreAuthorize;

public class UserWorkflowTaskLogic
extends AbstractTransactionalLogic<EntityTO> {
    protected final WorkflowTaskManager wfTaskManager;
    protected final PropagationManager propagationManager;
    protected final PropagationTaskExecutor taskExecutor;
    protected final UserDataBinder binder;
    protected final UserDAO userDAO;

    public UserWorkflowTaskLogic(WorkflowTaskManager wfTaskManager, PropagationManager propagationManager, PropagationTaskExecutor taskExecutor, UserDataBinder binder, UserDAO userDAO) {
        this.wfTaskManager = wfTaskManager;
        this.propagationManager = propagationManager;
        this.taskExecutor = taskExecutor;
        this.binder = binder;
        this.userDAO = userDAO;
    }

    @PreAuthorize(value="hasRole('WORKFLOW_TASK_LIST') and hasRole('USER_READ')")
    public List<WorkflowTask> getAvailableTasks(String key) {
        User user = (User)this.userDAO.authFind(key);
        return this.wfTaskManager.getAvailableTasks(user.getKey());
    }

    @PreAuthorize(value="hasRole('USER_UPDATE')")
    public UserTO executeNextTask(WorkflowTaskExecInput workflowTaskExecInput) {
        UserWorkflowResult updated = this.wfTaskManager.executeNextTask(workflowTaskExecInput);
        UserUR userUR = (UserUR)new UserUR.Builder((String)updated.getResult()).build();
        List taskInfos = this.propagationManager.getUserUpdateTasks(new UserWorkflowResult((Object)Pair.of((Object)userUR, null), new UserWorkflowResult.PropagationInfo(updated.getPropByRes(), updated.getPropByLinkedAccount()), updated.getPerformedTasks()));
        this.taskExecutor.execute((Collection)taskInfos, false, AuthContextUtils.getUsername());
        return this.binder.getUserTO((String)updated.getResult());
    }

    protected EntityTO resolveReference(Method method, Object ... args) throws UnresolvedReferenceException {
        throw new UnresolvedReferenceException();
    }
}

