/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class FinalizedControllerFeatures {
    private final Map<String, Short> featureMap;
    private final long epoch;

    public FinalizedControllerFeatures(Map<String, Short> featureMap, long epoch) {
        this.featureMap = Collections.unmodifiableMap(featureMap);
        this.epoch = epoch;
    }

    public Optional<Short> get(String name) {
        return Optional.ofNullable(this.featureMap.get(name));
    }

    public short versionOrDefault(String name, short defaultValue) {
        return this.featureMap.getOrDefault(name, defaultValue);
    }

    public Set<String> featureNames() {
        return this.featureMap.keySet();
    }

    public Map<String, Short> featureMap() {
        return this.featureMap;
    }

    public long epoch() {
        return this.epoch;
    }

    public int hashCode() {
        return Objects.hash(this.featureMap, this.epoch);
    }

    public boolean equals(Object o) {
        if (!(o instanceof FinalizedControllerFeatures)) {
            return false;
        }
        FinalizedControllerFeatures other = (FinalizedControllerFeatures)o;
        return this.featureMap.equals(other.featureMap) && this.epoch == other.epoch;
    }

    public String toString() {
        StringBuilder bld = new StringBuilder();
        bld.append("{");
        bld.append("featureMap=").append(this.featureMap.toString());
        bld.append(", epoch=").append(this.epoch);
        bld.append("}");
        return bld.toString();
    }
}

