/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.common.event;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import org.identityconnectors.common.CollectionUtil;
import org.identityconnectors.framework.api.ConnectorKey;

public class ConnectorEvent
extends EventObject {
    private static final long serialVersionUID = 585375138003446584L;
    public static final String CONNECTOR_REGISTERED = "CONNID_CONNECTOREVENT-REGISTERED";
    public static final String CONNECTOR_UNREGISTERING = "CONNID_CONNECTOREVENT-UNREGISTERING";
    public static final String BUNDLE_SYMBOLICNAME = "bundle.symbolicName";
    public static final String BUNDLE_ID = "bundle.id";
    public static final String BUNDLE = "bundle";
    public static final String BUNDLE_VERSION = "bundle.version";
    public static final String CONNECTOR_BUNDLE_NAME = "connector.bundleName";
    public static final String CONNECTOR_VERSION = "connector.version";
    public static final String CONNECTOR_NAME = "connector.name";
    private final String topic;
    private final Map<String, Object> properties;

    public ConnectorEvent(String topic, ConnectorKey source) {
        super(source);
        this.topic = topic;
        this.properties = new HashMap<String, Object>(2);
        this.properties.put(CONNECTOR_BUNDLE_NAME, source.getBundleName());
        this.properties.put(CONNECTOR_VERSION, source.getBundleVersion());
        this.properties.put(CONNECTOR_NAME, source.getConnectorName());
    }

    public ConnectorEvent(ConnectorEvent source) {
        super(source.getSource());
        this.topic = source.getTopic();
        this.properties = CollectionUtil.asReadOnlyMap(source.getProperties());
    }

    public String getTopic() {
        return this.topic;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }
}

