/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication.attribute;

import java.util.Set;
import lombok.Generated;
import org.apereo.cas.authentication.AuthenticationHandler;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.services.RegisteredService;

@FunctionalInterface
public interface AttributeRepositoryResolver {
    public static final String BEAN_NAME = "attributeRepositoryResolver";

    public Set<String> resolve(AttributeRepositoryQuery var1);

    public static AttributeRepositoryResolver allAttributeRepositories() {
        return query -> Set.of("*");
    }

    public static class AttributeRepositoryQuery {
        private AuthenticationHandler authenticationHandler;
        private final Principal principal;
        private Service service;
        private final Set<String> activeRepositoryIds;
        private RegisteredService registeredService;

        @Generated
        protected AttributeRepositoryQuery(AttributeRepositoryQueryBuilder<?, ?> b) {
            this.authenticationHandler = b.authenticationHandler;
            this.principal = b.principal;
            this.service = b.service;
            this.activeRepositoryIds = b.activeRepositoryIds;
            this.registeredService = b.registeredService;
        }

        @Generated
        public static AttributeRepositoryQueryBuilder<?, ?> builder() {
            return new AttributeRepositoryQueryBuilderImpl();
        }

        @Generated
        public AttributeRepositoryQuery withAuthenticationHandler(AuthenticationHandler authenticationHandler) {
            return this.authenticationHandler == authenticationHandler ? this : new AttributeRepositoryQuery(authenticationHandler, this.principal, this.service, this.activeRepositoryIds, this.registeredService);
        }

        @Generated
        public AttributeRepositoryQuery withPrincipal(Principal principal) {
            return this.principal == principal ? this : new AttributeRepositoryQuery(this.authenticationHandler, principal, this.service, this.activeRepositoryIds, this.registeredService);
        }

        @Generated
        public AttributeRepositoryQuery withService(Service service) {
            return this.service == service ? this : new AttributeRepositoryQuery(this.authenticationHandler, this.principal, service, this.activeRepositoryIds, this.registeredService);
        }

        @Generated
        public AttributeRepositoryQuery withActiveRepositoryIds(Set<String> activeRepositoryIds) {
            return this.activeRepositoryIds == activeRepositoryIds ? this : new AttributeRepositoryQuery(this.authenticationHandler, this.principal, this.service, activeRepositoryIds, this.registeredService);
        }

        @Generated
        public AttributeRepositoryQuery withRegisteredService(RegisteredService registeredService) {
            return this.registeredService == registeredService ? this : new AttributeRepositoryQuery(this.authenticationHandler, this.principal, this.service, this.activeRepositoryIds, registeredService);
        }

        @Generated
        public AttributeRepositoryQuery(AuthenticationHandler authenticationHandler, Principal principal, Service service, Set<String> activeRepositoryIds, RegisteredService registeredService) {
            this.authenticationHandler = authenticationHandler;
            this.principal = principal;
            this.service = service;
            this.activeRepositoryIds = activeRepositoryIds;
            this.registeredService = registeredService;
        }

        @Generated
        public AuthenticationHandler getAuthenticationHandler() {
            return this.authenticationHandler;
        }

        @Generated
        public Principal getPrincipal() {
            return this.principal;
        }

        @Generated
        public Service getService() {
            return this.service;
        }

        @Generated
        public Set<String> getActiveRepositoryIds() {
            return this.activeRepositoryIds;
        }

        @Generated
        public RegisteredService getRegisteredService() {
            return this.registeredService;
        }

        @Generated
        public AttributeRepositoryQuery() {
            this.principal = null;
            this.activeRepositoryIds = null;
        }

        @Generated
        public AttributeRepositoryQuery(Principal principal, Set<String> activeRepositoryIds) {
            this.principal = principal;
            this.activeRepositoryIds = activeRepositoryIds;
        }

        @Generated
        public static abstract class AttributeRepositoryQueryBuilder<C extends AttributeRepositoryQuery, B extends AttributeRepositoryQueryBuilder<C, B>> {
            @Generated
            private AuthenticationHandler authenticationHandler;
            @Generated
            private Principal principal;
            @Generated
            private Service service;
            @Generated
            private Set<String> activeRepositoryIds;
            @Generated
            private RegisteredService registeredService;

            @Generated
            public B authenticationHandler(AuthenticationHandler authenticationHandler) {
                this.authenticationHandler = authenticationHandler;
                return this.self();
            }

            @Generated
            public B principal(Principal principal) {
                this.principal = principal;
                return this.self();
            }

            @Generated
            public B service(Service service) {
                this.service = service;
                return this.self();
            }

            @Generated
            public B activeRepositoryIds(Set<String> activeRepositoryIds) {
                this.activeRepositoryIds = activeRepositoryIds;
                return this.self();
            }

            @Generated
            public B registeredService(RegisteredService registeredService) {
                this.registeredService = registeredService;
                return this.self();
            }

            @Generated
            protected abstract B self();

            @Generated
            public abstract C build();

            @Generated
            public String toString() {
                return "AttributeRepositoryResolver.AttributeRepositoryQuery.AttributeRepositoryQueryBuilder(authenticationHandler=" + String.valueOf(this.authenticationHandler) + ", principal=" + String.valueOf(this.principal) + ", service=" + String.valueOf(this.service) + ", activeRepositoryIds=" + String.valueOf(this.activeRepositoryIds) + ", registeredService=" + String.valueOf(this.registeredService) + ")";
            }
        }

        @Generated
        private static final class AttributeRepositoryQueryBuilderImpl
        extends AttributeRepositoryQueryBuilder<AttributeRepositoryQuery, AttributeRepositoryQueryBuilderImpl> {
            @Generated
            private AttributeRepositoryQueryBuilderImpl() {
            }

            @Override
            @Generated
            protected AttributeRepositoryQueryBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public AttributeRepositoryQuery build() {
                return new AttributeRepositoryQuery(this);
            }
        }
    }
}

