/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.authorization;

import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationConvention;
import io.micrometer.observation.ObservationRegistry;
import java.util.function.Supplier;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceAware;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.authorization.AuthorizationDecision;
import org.springframework.security.authorization.AuthorizationManager;
import org.springframework.security.authorization.AuthorizationObservationContext;
import org.springframework.security.authorization.AuthorizationObservationConvention;
import org.springframework.security.authorization.AuthorizationResult;
import org.springframework.security.authorization.method.MethodAuthorizationDeniedHandler;
import org.springframework.security.authorization.method.MethodInvocationResult;
import org.springframework.security.authorization.method.ThrowingMethodAuthorizationDeniedHandler;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.SpringSecurityMessageSource;
import org.springframework.util.Assert;

public final class ObservationAuthorizationManager<T>
implements AuthorizationManager<T>,
MessageSourceAware,
MethodAuthorizationDeniedHandler {
    private final ObservationRegistry registry;
    private final AuthorizationManager<T> delegate;
    private ObservationConvention<AuthorizationObservationContext<?>> convention = new AuthorizationObservationConvention();
    private MessageSourceAccessor messages = SpringSecurityMessageSource.getAccessor();
    private MethodAuthorizationDeniedHandler handler = new ThrowingMethodAuthorizationDeniedHandler();

    public ObservationAuthorizationManager(ObservationRegistry registry, AuthorizationManager<T> delegate) {
        this.registry = registry;
        this.delegate = delegate;
        if (delegate instanceof MethodAuthorizationDeniedHandler) {
            MethodAuthorizationDeniedHandler h;
            this.handler = h = (MethodAuthorizationDeniedHandler)((Object)delegate);
        }
    }

    @Override
    @Deprecated
    public AuthorizationDecision check(Supplier<Authentication> authentication, T object) {
        AuthorizationObservationContext context = new AuthorizationObservationContext(object);
        Supplier<Authentication> wrapped = () -> {
            context.setAuthentication((Authentication)authentication.get());
            return context.getAuthentication();
        };
        Observation observation = Observation.createNotStarted(this.convention, () -> context, (ObservationRegistry)this.registry).start();
        try {
            AuthorizationDecision authorizationDecision;
            block12: {
                Observation.Scope scope = observation.openScope();
                try {
                    AuthorizationDecision decision = this.delegate.check(wrapped, object);
                    context.setAuthorizationResult(decision);
                    if (decision != null && !decision.isGranted()) {
                        observation.error((Throwable)new AccessDeniedException(this.messages.getMessage("AbstractAccessDecisionManager.accessDenied", "Access Denied")));
                    }
                    authorizationDecision = decision;
                    if (scope == null) break block12;
                }
                catch (Throwable throwable) {
                    try {
                        if (scope != null) {
                            try {
                                scope.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable ex) {
                        observation.error(ex);
                        throw ex;
                    }
                }
                scope.close();
            }
            return authorizationDecision;
        }
        finally {
            observation.stop();
        }
    }

    public void setObservationConvention(ObservationConvention<AuthorizationObservationContext<?>> convention) {
        Assert.notNull(convention, (String)"The observation convention cannot be null");
        this.convention = convention;
    }

    public void setMessageSource(MessageSource messageSource) {
        this.messages = new MessageSourceAccessor(messageSource);
    }

    @Override
    public Object handleDeniedInvocation(MethodInvocation methodInvocation, AuthorizationResult authorizationResult) {
        return this.handler.handleDeniedInvocation(methodInvocation, authorizationResult);
    }

    @Override
    public Object handleDeniedInvocationResult(MethodInvocationResult methodInvocationResult, AuthorizationResult authorizationResult) {
        return this.handler.handleDeniedInvocationResult(methodInvocationResult, authorizationResult);
    }
}

