/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.loader;

import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Properties;
import org.apache.openejb.loader.Embedder;
import org.apache.openejb.loader.IO;
import org.apache.openejb.loader.ProvisioningUtil;
import org.apache.openejb.loader.SystemInstance;

class TomcatHook {
    TomcatHook() {
    }

    static void hook(Properties properties) {
        if (properties == null) {
            throw new NullPointerException("properties is null");
        }
        if (!properties.containsKey("tomee.war")) {
            throw new IllegalArgumentException("properties must contain the tomee.war property");
        }
        File openejbWar = new File(properties.getProperty("tomee.war"));
        if (!openejbWar.isDirectory()) {
            throw new IllegalArgumentException("tomee.war is not a directory: " + String.valueOf(openejbWar));
        }
        if (SystemInstance.isInitialized()) {
            return;
        }
        properties.setProperty("openejb.loader", "tomcat-system");
        String catalinaHome = System.getProperty("catalina.home");
        properties.setProperty("openejb.home", catalinaHome);
        System.setProperty("openejb.home", catalinaHome);
        String catalinaBase = System.getProperty("catalina.base");
        properties.setProperty("openejb.base", catalinaBase);
        System.setProperty("openejb.base", catalinaBase);
        System.setProperty("tomee.war", openejbWar.getAbsolutePath());
        File libDir = new File(openejbWar, "lib");
        String libPath = libDir.getAbsolutePath();
        properties.setProperty("openejb.libs", libPath);
        ClassLoader classLoader = TomcatHook.class.getClassLoader();
        try {
            String serverBuilt;
            String serverInfo;
            Properties tomcatServerInfo = IO.readProperties((InputStream)classLoader.getResourceAsStream("org/apache/catalina/util/ServerInfo.properties"), (Properties)new Properties());
            String serverNumber = tomcatServerInfo.getProperty("server.number");
            if (serverNumber == null && (serverInfo = tomcatServerInfo.getProperty("server.info")) != null) {
                int slash = serverInfo.indexOf(47);
                serverNumber = serverInfo.substring(slash + 1);
            }
            if (serverNumber != null) {
                System.setProperty("tomcat.version", serverNumber);
            }
            if ((serverBuilt = tomcatServerInfo.getProperty("server.built")) != null) {
                System.setProperty("tomcat.built", serverBuilt);
            }
        }
        catch (Throwable tomcatServerInfo) {
            // empty catch block
        }
        if (properties.getProperty("openejb.libs") == null) {
            throw new NullPointerException("openejb.libs property is not set");
        }
        if (URLClassLoader.class.isInstance(classLoader)) {
            URLClassLoader ucl = (URLClassLoader)URLClassLoader.class.cast(classLoader);
            try {
                Method addUrl = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
                for (File f : ProvisioningUtil.addAdditionalLibraries()) {
                    if (!addUrl.isAccessible()) {
                        addUrl.setAccessible(true);
                    }
                    addUrl.invoke((Object)ucl, f.toURI().toURL());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        Embedder embedder = new Embedder("org.apache.tomee.catalina.TomcatLoader");
        SystemInstance.get().setComponent(Embedder.class, (Object)embedder);
        try {
            SystemInstance.init((Properties)properties);
            embedder.init(properties);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

