/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types;

import co.elastic.clients.elasticsearch._types.Retriever;
import co.elastic.clients.elasticsearch._types.RetrieverBase;
import co.elastic.clients.elasticsearch._types.RetrieverVariant;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class RuleRetriever
extends RetrieverBase
implements RetrieverVariant {
    private final List<String> rulesetIds;
    private final JsonData matchCriteria;
    private final Retriever retriever;
    @Nullable
    private final Integer rankWindowSize;
    public static final JsonpDeserializer<RuleRetriever> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RuleRetriever::setupRuleRetrieverDeserializer);

    private RuleRetriever(Builder builder) {
        super(builder);
        this.rulesetIds = ApiTypeHelper.unmodifiableRequired(builder.rulesetIds, (Object)this, "rulesetIds");
        this.matchCriteria = ApiTypeHelper.requireNonNull(builder.matchCriteria, this, "matchCriteria");
        this.retriever = ApiTypeHelper.requireNonNull(builder.retriever, this, "retriever");
        this.rankWindowSize = builder.rankWindowSize;
    }

    public static RuleRetriever of(Function<Builder, ObjectBuilder<RuleRetriever>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Retriever.Kind _retrieverKind() {
        return Retriever.Kind.Rule;
    }

    public final List<String> rulesetIds() {
        return this.rulesetIds;
    }

    public final JsonData matchCriteria() {
        return this.matchCriteria;
    }

    public final Retriever retriever() {
        return this.retriever;
    }

    @Nullable
    public final Integer rankWindowSize() {
        return this.rankWindowSize;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (ApiTypeHelper.isDefined(this.rulesetIds)) {
            generator.writeKey("ruleset_ids");
            generator.writeStartArray();
            for (String item0 : this.rulesetIds) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        generator.writeKey("match_criteria");
        this.matchCriteria.serialize(generator, mapper);
        generator.writeKey("retriever");
        this.retriever.serialize(generator, mapper);
        if (this.rankWindowSize != null) {
            generator.writeKey("rank_window_size");
            generator.write(this.rankWindowSize.intValue());
        }
    }

    protected static void setupRuleRetrieverDeserializer(ObjectDeserializer<Builder> op) {
        RetrieverBase.setupRetrieverBaseDeserializer(op);
        op.add(Builder::rulesetIds, JsonpDeserializer.arrayDeserializer((JsonpDeserializer)JsonpDeserializer.stringDeserializer()), "ruleset_ids");
        op.add(Builder::matchCriteria, JsonData._DESERIALIZER, "match_criteria");
        op.add(Builder::retriever, Retriever._DESERIALIZER, "retriever");
        op.add(Builder::rankWindowSize, JsonpDeserializer.integerDeserializer(), "rank_window_size");
    }

    public static class Builder
    extends RetrieverBase.AbstractBuilder<Builder>
    implements ObjectBuilder<RuleRetriever> {
        private List<String> rulesetIds;
        private JsonData matchCriteria;
        private Retriever retriever;
        @Nullable
        private Integer rankWindowSize;

        public final Builder rulesetIds(List<String> list) {
            this.rulesetIds = Builder._listAddAll(this.rulesetIds, list);
            return this;
        }

        public final Builder rulesetIds(String value, String ... values) {
            this.rulesetIds = Builder._listAdd(this.rulesetIds, value, values);
            return this;
        }

        public final Builder matchCriteria(JsonData value) {
            this.matchCriteria = value;
            return this;
        }

        public final Builder retriever(Retriever value) {
            this.retriever = value;
            return this;
        }

        public final Builder retriever(Function<Retriever.Builder, ObjectBuilder<Retriever>> fn) {
            return this.retriever(fn.apply(new Retriever.Builder()).build());
        }

        public final Builder retriever(RetrieverVariant value) {
            this.retriever = value._toRetriever();
            return this;
        }

        public final Builder rankWindowSize(@Nullable Integer value) {
            this.rankWindowSize = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public RuleRetriever build() {
            this._checkSingleUse();
            return new RuleRetriever(this);
        }
    }
}

