/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache;

import org.gradle.cache.CacheDecorator;
import org.gradle.internal.serialize.BaseSerializerFactory;
import org.gradle.internal.serialize.Serializer;
import org.jspecify.annotations.Nullable;

public class IndexedCacheParameters<K, V> {
    private static final BaseSerializerFactory SERIALIZER_FACTORY = new BaseSerializerFactory();
    private final String cacheName;
    private final Serializer<K> keySerializer;
    private final Serializer<V> valueSerializer;
    private final CacheDecorator cacheDecorator;

    public static <K, V> IndexedCacheParameters<K, V> of(String cacheName, Serializer<K> keySerializer, Serializer<V> valueSerializer) {
        return new IndexedCacheParameters<K, V>(cacheName, keySerializer, valueSerializer, null);
    }

    public static <K, V> IndexedCacheParameters<K, V> of(String cacheName, Class<K> keyType, Serializer<V> valueSerializer) {
        return new IndexedCacheParameters<K, V>(cacheName, SERIALIZER_FACTORY.getSerializerFor(keyType), valueSerializer, null);
    }

    public static <K, V> IndexedCacheParameters<K, V> of(String cacheName, Class<K> keyType, Class<V> valueType) {
        return new IndexedCacheParameters<K, V>(cacheName, SERIALIZER_FACTORY.getSerializerFor(keyType), SERIALIZER_FACTORY.getSerializerFor(valueType), null);
    }

    private IndexedCacheParameters(String cacheName, Serializer<K> keySerializer, Serializer<V> valueSerializer, @Nullable CacheDecorator cacheDecorator) {
        this.cacheName = cacheName;
        this.keySerializer = keySerializer;
        this.valueSerializer = valueSerializer;
        this.cacheDecorator = cacheDecorator;
    }

    public String getCacheName() {
        return this.cacheName;
    }

    public Serializer<K> getKeySerializer() {
        return this.keySerializer;
    }

    public Serializer<V> getValueSerializer() {
        return this.valueSerializer;
    }

    public @Nullable CacheDecorator getCacheDecorator() {
        return this.cacheDecorator;
    }

    public IndexedCacheParameters<K, V> withCacheDecorator(CacheDecorator cacheDecorator) {
        return new IndexedCacheParameters<K, V>(this.cacheName, this.keySerializer, this.valueSerializer, cacheDecorator);
    }
}

