/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.aalto.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;

public final class URLUtil {
    private URLUtil() {
    }

    public static URL urlFromSystemId(String sysId) throws IOException {
        try {
            int ix = sysId.indexOf(58, 0);
            if (ix >= 3 && ix <= 8) {
                return new URL(sysId);
            }
            return URLUtil.fileToURL(new File(sysId));
        }
        catch (MalformedURLException e) {
            URLUtil.throwIoException(e, sysId);
            return null;
        }
    }

    public static URL urlFromSystemId(String sysId, URL ctxt) throws IOException {
        if (ctxt == null) {
            return URLUtil.urlFromSystemId(sysId);
        }
        try {
            return new URL(ctxt, sysId);
        }
        catch (MalformedURLException e) {
            URLUtil.throwIoException(e, sysId);
            return null;
        }
    }

    public static URL urlFromCurrentDir() throws IOException {
        return URLUtil.fileToURL(new File("a").getAbsoluteFile().getParentFile());
    }

    public static InputStream inputStreamFromURL(URL url) throws IOException {
        String host;
        if ("file".equals(url.getProtocol()) && ((host = url.getHost()) == null || host.length() == 0)) {
            return new FileInputStream(url.getPath());
        }
        return url.openStream();
    }

    public static OutputStream outputStreamFromURL(URL url) throws IOException {
        String host;
        if ("file".equals(url.getProtocol()) && ((host = url.getHost()) == null || host.length() == 0)) {
            return new FileOutputStream(url.getPath());
        }
        return url.openConnection().getOutputStream();
    }

    public static URL fileToURL(File f) throws IOException {
        String absPath = f.getAbsolutePath();
        char sep = File.separatorChar;
        if (sep != '/') {
            absPath = absPath.replace(sep, '/');
        }
        if (absPath.length() > 0 && absPath.charAt(0) != '/') {
            absPath = "/" + absPath;
        }
        return new URL("file", "", absPath);
    }

    public static String fileToSystemId(File f) throws IOException {
        return URLUtil.fileToURL(f).toExternalForm();
    }

    public static String urlToSystemId(URL u) {
        return u.toExternalForm();
    }

    private static void throwIoException(MalformedURLException mex, String sysId) throws IOException {
        IOException ie = new IOException("[resolving systemId '" + sysId + "']: " + mex.toString());
        ie.initCause(mex);
        throw ie;
    }
}

