/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.IndexSet;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.ViewIndexSet;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public abstract class ModelIndexSet<S>
extends IndexSet<ModelIndex<S>> {
    public static <Row> ModelIndexSet<Row> forRows(CoreGrid<Row, ?> grid, int ... rows) {
        return ModelIndexSet.forRows(grid.getDataModel(DataAccessType.DATABASE_DATA), rows);
    }

    public static <Row> ModelIndexSet<Row> forRows(GridModel<Row, ?> model, int ... rows) {
        return new Rows(rows);
    }

    public static <Row> ModelIndexSet<Row> forRows(GridModel<Row, ?> model, ModelIndex<Row> ... rows) {
        int[] rowsIdx = ArrayUtil.toIntArray((Collection)ContainerUtil.map((Object[])rows, row -> row.asInteger()));
        return new Rows(rowsIdx);
    }

    public static <Row> ModelIndexSet<Row> forRows(CoreGrid<Row, ?> grid, Iterable<ModelIndex<Row>> rows) {
        return ModelIndexSet.forRows(grid.getDataModel(DataAccessType.DATABASE_DATA), rows);
    }

    public static <Row> ModelIndexSet<Row> forRows(GridModel<Row, ?> model, Iterable<ModelIndex<Row>> rows) {
        int[] rowsIdx = ArrayUtil.toIntArray((Collection)ContainerUtil.map(rows, row -> row.asInteger()));
        return new Rows(rowsIdx);
    }

    public static <Column> ModelIndexSet<Column> forColumns(CoreGrid<?, Column> grid, int ... columns) {
        return ModelIndexSet.forColumns(grid.getDataModel(DataAccessType.DATABASE_DATA), columns);
    }

    public static <Column> ModelIndexSet<Column> forColumns(GridModel<?, Column> model, int ... columns) {
        return new Columns(columns);
    }

    public static <Column> ModelIndexSet<Column> forColumns(GridModel<?, Column> model, ModelIndex<Column> ... columns) {
        int[] columnsIdx = ArrayUtil.toIntArray((Collection)ContainerUtil.map((Object[])columns, column -> column.asInteger()));
        return new Columns(columnsIdx);
    }

    public static <Column> ModelIndexSet<Column> forColumns(CoreGrid<?, Column> grid, Iterable<ModelIndex<Column>> columns) {
        return ModelIndexSet.forColumns(grid.getDataModel(DataAccessType.DATABASE_DATA), columns);
    }

    public static <Column> ModelIndexSet<Column> forColumns(GridModel<?, Column> model, Iterable<ModelIndex<Column>> columns) {
        int[] columnsIdx = ArrayUtil.toIntArray((Collection)ContainerUtil.map(columns, column -> column.asInteger()));
        return new Columns(columnsIdx);
    }

    private ModelIndexSet(int ... indices) {
        super(indices);
    }

    @NotNull
    public abstract ViewIndexSet<S> toView(@NotNull CoreGrid<?, ?> var1);

    public String toString() {
        return "Model" + this.getClass().getSimpleName() + "{" + StringUtil.join((int[])this.values, (String)",") + "}";
    }

    private static class Rows<Row>
    extends ModelIndexSet<Row> {
        Rows(int ... indices) {
            super(indices);
        }

        @Override
        @NotNull
        public ViewIndexSet<Row> toView(@NotNull CoreGrid<?, ?> grid) {
            if (grid == null) {
                Rows.$$$reportNull$$$0(0);
            }
            ViewIndexSet<?> viewIndexSet = ViewIndexSet.forRows(grid, IndexSet.convert(ModelIndex.row2View(grid), this.asArray()));
            if (viewIndexSet == null) {
                Rows.$$$reportNull$$$0(1);
            }
            return viewIndexSet;
        }

        @Override
        protected ModelIndex<Row> forValue(int value) {
            return ModelIndex.forRow((GridModel)null, value);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "grid";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/datagrid/ModelIndexSet$Rows";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/datagrid/ModelIndexSet$Rows";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toView";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "toView";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private static class Columns<Column>
    extends ModelIndexSet<Column> {
        Columns(int ... indices) {
            super(indices);
        }

        @Override
        @NotNull
        public ViewIndexSet<Column> toView(@NotNull CoreGrid<?, ?> grid) {
            if (grid == null) {
                Columns.$$$reportNull$$$0(0);
            }
            ViewIndexSet<?> viewIndexSet = ViewIndexSet.forColumns(grid, IndexSet.convert(ModelIndex.col2View(grid), this.asArray()));
            if (viewIndexSet == null) {
                Columns.$$$reportNull$$$0(1);
            }
            return viewIndexSet;
        }

        @Override
        protected ModelIndex<Column> forValue(int value) {
            return ModelIndex.forColumn((GridModel)null, value);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "grid";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/datagrid/ModelIndexSet$Columns";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/datagrid/ModelIndexSet$Columns";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toView";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "toView";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

